<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme and one
 * of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query,
 * e.g., it puts together the home page when no home.php file exists.
 *
 * Template Name: Page No Padding
 *
 */

$pixtheme_custom = isset( $wp_query ) ? get_post_custom( $wp_query->get_queried_object_id() ) : '';
$pixtheme_layout = isset( $pixtheme_custom['pix_page_layout'] ) ? $pixtheme_custom['pix_page_layout'][0] : '2';
$pixtheme_sidebar = isset( $pixtheme_custom['pix_selected_sidebar'][0] ) ? $pixtheme_custom['pix_selected_sidebar'][0] : 'sidebar-1';

if ( ! is_active_sidebar($pixtheme_sidebar) ) $pixtheme_layout = '1';

?>

<?php get_header();?>
    <section class="blog pix-page-no-padding" >
        <div class="container">
            <div class="row">
            
                <?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>

				<div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12 col-md-12<?php else : ?>col-lg-8 col-md-8 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?><?php endif; ?> col-sm-12 col-xs-12">

                    <div class="rtd"> <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                    <?php $pixtheme_page_com_id = $post; ?>
                    <?php the_content(); ?>
                    <?php
                    if('open' == $pixtheme_page_com_id->comment_status) {
                        comments_template();
                    }
                    ?>
                    <?php endwhile; ?>
                    </div>
                </div>
                
                <?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>
                
            </div>
        </div>
    </section>
<?php get_footer(); ?>