<?php

	function pixtheme_customize_header_tab($wp_customize, $theme_name){

		$wp_customize->add_panel('pixtheme_header_panel',  array(
            'title' => 'Header',
            'priority' => 30,
            )
        );



		$wp_customize->add_section( 'pixtheme_header_settings' , array(
		    'title'      => esc_html__( 'General Settings', 'cutstyle' ),
		    'priority'   => 5,
			'panel' => 'pixtheme_header_panel'
		) );


		$wp_customize->add_setting( 'pixtheme_header_type' , array(
				'default'     => 'header1',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_type',
            array(
                'label'    => esc_html__( 'Type', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings',
                'settings' => 'pixtheme_header_type',
                'type'     => 'select',
                'choices'  => array(
                    'header1' => esc_html__( 'Default', 'cutstyle' ),
                    'header2' => esc_html__( 'Centered Logo', 'cutstyle' ),
//		            'header3' => esc_html__( 'Centered Logo (2 levels)', 'cutstyle' ),
		            'header4' => esc_html__( 'Header Info (2 levels)', 'cutstyle' ),
//		            'header5' => esc_html__( 'Slideout Sidebar', 'cutstyle' ),
                ),
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_layout' , array(
			'default'     => 'container',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_layout',
            array(
                'label'    => esc_html__( 'Layout', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings',
                'settings' => 'pixtheme_header_layout',
                'type'     => 'select',
                'choices'  => array(
                    'container'  => esc_html__( 'Normal', 'cutstyle' ),
		            'container-fluid' => esc_html__( 'Full Width', 'cutstyle' ),
                ),
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_sticky' , array(
				'default'     => 'sticky',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_sticky',
            array(
                'label'         => esc_html__( 'Sticky', 'cutstyle' ),
                'section'       => 'pixtheme_header_settings',
                'settings'      => 'pixtheme_header_sticky',
                'type'          => 'select',
                'choices'       => array(
                    '' => esc_html__( 'No', 'cutstyle' ),
                    'sticky'  => esc_html__( 'Yes', 'cutstyle' ),
                ),
            )
        );



		/// HEADER STYLE ///

		$wp_customize->add_section( 'pixtheme_header_settings_style' , array(
		    'title'      => esc_html__( 'Colors', 'cutstyle' ),
		    'priority'   => 10,
			'panel' => 'pixtheme_header_panel'
		) );


		$wp_customize->add_setting( 'pixtheme_top_bar_background' , array(
				'default'     => 'black',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_top_bar_background',
            array(
                'label'    => esc_html__( 'Top Bar Background Color', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_style',
                'settings' => 'pixtheme_top_bar_background',
                'type'     => 'select',
                'choices'  => array(
                    'white' => esc_html__( 'White', 'cutstyle' ),
		            'black' => esc_html__( 'Black', 'cutstyle' ),
                ),
            )
        );

		$wp_customize->add_setting( 'pixtheme_top_bar_transparent' , array(
			'default'     => '100',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'esc_attr'
		) );
		$wp_customize->add_control(
			new PixTheme_Slider_Single_Control(
				$wp_customize,
				'pixtheme_top_bar_transparent',
				array(
					'label' => esc_html__( 'Top Bar Transparent', 'cutstyle' ),
					'section' => 'pixtheme_header_settings_style',
					'settings' => 'pixtheme_top_bar_transparent',
					'min' => 0,
					'max' => 100,
					'unit'=> '%',
				)
			)
	    );

		$wp_customize->add_setting( 'pixtheme_header_background' , array(
				'default'     => 'white',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_background',
            array(
                'label'    => esc_html__( 'Background Color', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_style',
                'settings' => 'pixtheme_header_background',
                'type'     => 'select',
                'choices'  => array(
                    'white' => esc_html__( 'White', 'cutstyle' ),
		            'black' => esc_html__( 'Black', 'cutstyle' ),
                ),
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_transparent' , array(
			'default'     => '100',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'esc_attr'
		) );
		$wp_customize->add_control(
			new PixTheme_Slider_Single_Control(
				$wp_customize,
				'pixtheme_header_transparent',
				array(
					'label' => esc_html__( 'Transparent', 'cutstyle' ),
					'section' => 'pixtheme_header_settings_style',
					'settings' => 'pixtheme_header_transparent',
					'min' => 0,
					'max' => 100,
					'unit'=> '%',
				)
			)
	    );

		$wp_customize->add_setting( 'pixtheme_header_menu_background' , array(
				'default'     => get_option('pixtheme_default_header_menu_background'),
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_menu_background',
            array(
                'label'    => esc_html__( 'Menu Background Color', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_style',
                'settings' => 'pixtheme_header_menu_background',
                'type'     => 'select',
                'choices'  => array(
                    'white' => esc_html__( 'White', 'cutstyle' ),
		            'black' => esc_html__( 'Black', 'cutstyle' ),
                    'main-color' => esc_html__( 'Main Color', 'cutstyle' ),
                    'add-color' => esc_html__( 'Additional Color', 'cutstyle' ),
                    'gradient' => esc_html__( 'Gradient', 'cutstyle' ),
                ),
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_menu_transparent' , array(
			'default'     => '100',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'esc_attr'
		) );
		$wp_customize->add_control(
			new PixTheme_Slider_Single_Control(
				$wp_customize,
				'pixtheme_header_menu_transparent',
				array(
					'label' => esc_html__( 'Menu Transparent', 'cutstyle' ),
					'section' => 'pixtheme_header_settings_style',
					'settings' => 'pixtheme_header_menu_transparent',
					'min' => 0,
					'max' => 100,
					'unit'=> '%',
				)
			)
	    );



        /// HEADER ELEMENTS ///

		$wp_customize->add_section( 'pixtheme_header_settings_elements' , array(
		    'title'      => esc_html__( 'Elements', 'cutstyle' ),
		    'priority'   => 15,
			'panel' => 'pixtheme_header_panel'
		) );


		$wp_customize->add_setting( 'pixtheme_header_bar' , array(
				'default'     => '0',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
			'pixtheme_header_bar',
			array(
				'label'    => esc_html__( 'Top Bar', 'cutstyle' ),
				'section'  => 'pixtheme_header_settings_elements',
				'settings' => 'pixtheme_header_bar',
				'type'     => 'select',
				'choices'  => array(
						'1'  => esc_html__( 'On', 'cutstyle' ),
						'0' => esc_html__( 'Off', 'cutstyle' ),
				),
				'priority'   => 10
			)
		);

		$wp_customize->add_setting( 'pixtheme_header_minicart' , array(
				'default'     => '1',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_minicart',
            array(
                'label'    => esc_html__( 'Minicart', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_elements',
                'settings' => 'pixtheme_header_minicart',
                'type'     => 'select',
                'choices'  => array(
                    '1'  => esc_html__( 'On', 'cutstyle' ),
                    '0' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 20
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_search' , array(
				'default'     => '1',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_search',
            array(
                'label'    => esc_html__( 'Search', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_elements',
                'settings' => 'pixtheme_header_search',
                'type'     => 'select',
                'choices'  => array(
                    '1'  => esc_html__( 'On', 'cutstyle' ),
                    '0' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 30
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_socials' , array(
				'default'     => '1',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
            'pixtheme_header_socials',
            array(
                'label'    => esc_html__( 'Socials', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_elements',
                'settings' => 'pixtheme_header_socials',
                'type'     => 'select',
                'choices'  => array(
                    '1'  => esc_html__( 'On', 'cutstyle' ),
                    '0' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 40
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_button' , array(
				'default'     => '0',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
				'pixtheme_header_button',
				array(
						'label'    => esc_html__( 'Button', 'cutstyle' ),
						'section'  => 'pixtheme_header_settings_elements',
						'settings' => 'pixtheme_header_button',
						'type'     => 'select',
						'choices'  => array(
								'1'  => esc_html__( 'On', 'cutstyle' ),
								'0' => esc_html__( 'Off', 'cutstyle' ),
						),
						'priority'   => 50
				)
		);



        /// HEADER INFO ///

		$wp_customize->add_section( 'pixtheme_header_settings_info' , array(
		    'title'      => esc_html__( 'Info Texts', 'cutstyle' ),
		    'priority'   => 25,
			'panel' => 'pixtheme_header_panel'
		) );


		$wp_customize->add_setting( 'pixtheme_header_phone' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_phone',
			array(
				'label'    => esc_html__( 'Phone', 'cutstyle' ),
				'section'  => 'pixtheme_header_settings_info',
				'settings' => 'pixtheme_header_phone',
				'type'     => 'text',
			)
		);
        
		$wp_customize->add_setting( 'pixtheme_header_email' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_email',
			array(
				'label'    => esc_html__( 'E-mail', 'cutstyle' ),
				'section'  => 'pixtheme_header_settings_info',
				'settings' => 'pixtheme_header_email',
				'type'     => 'text',
			)
		);
        
		$wp_customize->add_setting( 'pixtheme_header_button_text' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_button_text',
			array(
					'label'    => esc_html__( 'Button Text', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_button_text',
					'type'     => 'text',
			)
		);

		$wp_customize->add_setting( 'pixtheme_header_button_link' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'esc_url'
		) );
		$wp_customize->add_control(
				'pixtheme_header_button_link',
				array(
						'label'    => esc_html__( 'Button Link', 'cutstyle' ),
						'section'  => 'pixtheme_header_settings_info',
						'settings' => 'pixtheme_header_button_link',
						'type'     => 'text',
				)
		);



		$wp_customize->add_setting( 'pixtheme_header_info_segment', array(
            'default' => 'info_1',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new PixTheme_Segmented_Control(
                $wp_customize,
                'pixtheme_header_info_segment',
                array(
                    'label' => esc_html__( 'Info Sections', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_info',
                    'settings' => 'pixtheme_header_info_segment',
                    'choices'  => array(
                        'info_1' => esc_html__( 'Info 1', 'cutstyle' ),
                        'info_2' => esc_html__( 'Info 2', 'cutstyle' ),
                        'info_3' => esc_html__( 'Info 3', 'cutstyle' ),
                    ),
                    'align' => 'center',
                    'type' => 'tabs',
                    'hide_label' => 'hide',
                )
            )
        );

		$wp_customize->add_setting( 'pixtheme_header_info_icon_1' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_icon_1',
			array(
					'label'    => esc_html__( 'Icon 1', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_icon_1',
					'type'     => 'text',
			)
		);
		$wp_customize->add_setting( 'pixtheme_header_info_title_1' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_title_1',
			array(
					'label'    => esc_html__( 'Title 1', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_title_1',
					'type'     => 'text',
			)
		);
		$wp_customize->add_setting( 'pixtheme_header_info_1' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_1',
			array(
					'label'    => esc_html__( 'Info 1', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_1',
					'type'     => 'text',
			)
		);

		$wp_customize->add_setting( 'pixtheme_header_info_icon_2' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_icon_2',
			array(
					'label'    => esc_html__( 'Icon 2', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_icon_2',
					'type'     => 'text',
			)
		);
		$wp_customize->add_setting( 'pixtheme_header_info_title_2' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_title_2',
			array(
					'label'    => esc_html__( 'Title 2', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_title_2',
					'type'     => 'text',
			)
		);
		$wp_customize->add_setting( 'pixtheme_header_info_2' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_2',
			array(
					'label'    => esc_html__( 'Info 2', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_2',
					'type'     => 'text',
			)
		);

		$wp_customize->add_setting( 'pixtheme_header_info_icon_3' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_icon_3',
			array(
					'label'    => esc_html__( 'Icon 3', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_icon_3',
					'type'     => 'text',
			)
		);
		$wp_customize->add_setting( 'pixtheme_header_info_title_3' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_title_3',
			array(
					'label'    => esc_html__( 'Title 3', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_title_3',
					'type'     => 'text',
			)
		);
		$wp_customize->add_setting( 'pixtheme_header_info_3' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'wp_kses_post'
		) );
		$wp_customize->add_control(
			'pixtheme_header_info_3',
			array(
					'label'    => esc_html__( 'Info 3', 'cutstyle' ),
					'section'  => 'pixtheme_header_settings_info',
					'settings' => 'pixtheme_header_info_3',
					'type'     => 'text',
			)
		);



        /// HEADER BACKGROUND ///

        $wp_customize->add_section( 'pixtheme_header_settings_bg_image' , array(
            'title'      => esc_html__( 'Background Image', 'cutstyle' ),
            'priority'   => 30,
            'panel' => 'pixtheme_header_panel'
        ) );


        $wp_customize->add_setting( 'pixtheme_tab_bg_image' , array(
            'default'     => '',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'pixtheme_tab_bg_image',
                array(
                    'label'      => esc_html__( 'Background Image', 'cutstyle' ),
                    'section'    => 'pixtheme_header_settings_bg_image',
                    'settings'   => 'pixtheme_tab_bg_image',
                    'priority'   => 10
                )
            )
        );

        $wp_customize->add_setting(	'pixtheme_tab_bg_image_horizontal_pos', array(
            'default' => '0',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new PixTheme_Slider_Single_Control(
                $wp_customize,
                'pixtheme_tab_bg_image_horizontal_pos',
                array(
                    'label' => esc_html__( 'Horizontal Position', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_bg_image',
                    'settings' => 'pixtheme_tab_bg_image_horizontal_pos',
                    'min' => 0,
                    'max' => 100,
                    'unit' => '%',
                    'priority'   => 12
                )
            )
        );

        $wp_customize->add_setting(	'pixtheme_tab_bg_image_vertical_pos', array(
            'default' => '0',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new PixTheme_Slider_Single_Control(
                $wp_customize,
                'pixtheme_tab_bg_image_vertical_pos',
                array(
                    'label' => esc_html__( 'Vertical Position', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_bg_image',
                    'settings' => 'pixtheme_tab_bg_image_vertical_pos',
                    'min' => 0,
                    'max' => 100,
                    'unit' => '%',
                    'priority'   => 13
                )
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_bg_image_fixed' , array(
            'default'     => '1',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            'pixtheme_tab_bg_image_fixed',
            array(
                'label'    => esc_html__( 'Fixed Image', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_bg_image',
                'settings' => 'pixtheme_tab_bg_image_fixed',
                'type'     => 'select',
                'choices'  => array(
                    '0' => esc_html__( 'No', 'cutstyle' ),
                    '1' => esc_html__( 'Yes', 'cutstyle' ),
                ),
                'priority'   => 15
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_bg_color' , array(
            'default'     => get_option('pixtheme_default_tab_bg_color'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Color_Control(
                $wp_customize,
                'pixtheme_tab_bg_color',
                array(
                    'label'      => esc_html__( 'Overlay Color', 'cutstyle' ),
                    'section'    => 'pixtheme_header_settings_bg_image',
                    'settings'   => 'pixtheme_tab_bg_color',
                    'priority'   => 20
                )
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_bg_color_gradient' , array(
            'default'     => get_option('pixtheme_default_tab_bg_color_gradient'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Color_Control(
                $wp_customize,
                'pixtheme_tab_bg_color_gradient',
                array(
                    'label'      => esc_html__( 'Gradient Color', 'cutstyle' ),
                    'description'    => esc_html__( 'Set this color for gradient overlay', 'cutstyle'),
                    'section'    => 'pixtheme_header_settings_bg_image',
                    'settings'   => 'pixtheme_tab_bg_color_gradient',
                    'priority'   => 30
                )
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_gradient_direction' , array(
            'default'     => get_option('pixtheme_default_tab_gradient_direction'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            'pixtheme_tab_gradient_direction',
            array(
                'label'    => esc_html__( 'Gradient Direction', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_bg_image',
                'settings' => 'pixtheme_tab_gradient_direction',
                'type'     => 'select',
                'choices'  => array(
                    'to right' => esc_html__( 'To Right ', 'cutstyle' ).html_entity_decode('&rarr;'),
                    'to left' => esc_html__( 'To Left ', 'cutstyle' ).html_entity_decode('&larr;'),
                    'to bottom' => esc_html__( 'To Bottom ', 'cutstyle' ).html_entity_decode('&darr;'),
                    'to top' => esc_html__( 'To Top ', 'cutstyle' ).html_entity_decode('&uarr;'),
                    'to bottom right' => esc_html__( 'To Bottom Right ', 'cutstyle' ).html_entity_decode('&#8600;'),
                    'to bottom left' => esc_html__( 'To Bottom Left ', 'cutstyle' ).html_entity_decode('&#8601;'),
                    'to top right' => esc_html__( 'To Top Right ', 'cutstyle' ).html_entity_decode('&#8599;'),
                    'to top left' => esc_html__( 'To Top Left ', 'cutstyle' ).html_entity_decode('&#8598;'),
                    //'angle' => esc_html__( 'Angle ', 'cutstyle' ).html_entity_decode('&#10227;'),
                ),
                'priority' => 40
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_bg_opacity' , array(
            'default'     => get_option('pixtheme_default_tab_bg_opacity'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            new PixTheme_Slider_Single_Control(
                $wp_customize,
                'pixtheme_tab_bg_opacity',
                array(
                    'label' => esc_html__( 'Overlay Opacity', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_bg_image',
                    'settings' => 'pixtheme_tab_bg_opacity',
                    'min' => 0,
                    'max' => 100,
                    'unit' => '%',
                    'priority' => 45
                )
            )
        );




        /// TITLE & BREADCRUMBS ///

        $wp_customize->add_section( 'pixtheme_header_settings_tab' , array(
            'title'      => esc_html__( 'Title & Breadcrumbs', 'cutstyle' ),
            'priority'   => 35,
            'panel' => 'pixtheme_header_panel'
        ) );


        $wp_customize->add_setting( 'pixtheme_tab_tone' , array(
            'default'     => '',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            'pixtheme_tab_tone',
            array(
                'label'    => esc_html__( 'Text Tone', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_tab',
                'settings' => 'pixtheme_tab_tone',
                'type'     => 'select',
                'choices'  => array(
                    '' => esc_html__( 'Light', 'cutstyle' ),
                    'pix-tab-tone-dark' => esc_html__( 'Dark', 'cutstyle' ),
                ),
            )
        );


        $wp_customize->add_setting( 'pixtheme_tab_title_position' , array(
            'default'     => '',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            'pixtheme_tab_title_position',
            array(
                'label'    => esc_html__( 'Page Title Position', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_tab',
                'settings' => 'pixtheme_tab_title_position',
                'type'     => 'select',
                'choices'  => array(
                    '' => esc_html__( 'Center', 'cutstyle' ),
                    'left' => esc_html__( 'Left', 'cutstyle' ),
                    'right' => esc_html__( 'Right', 'cutstyle' ),
                    'hide' => esc_html__( 'Hide', 'cutstyle' ),
                ),
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_breadcrumbs_position' , array(
            'default'     => '',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            'pixtheme_tab_breadcrumbs_position',
            array(
                'label'    => esc_html__( 'Breadcrumbs Position', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_tab',
                'settings' => 'pixtheme_tab_breadcrumbs_position',
                'type'     => 'select',
                'choices'  => array(
                    '' => esc_html__( 'Center', 'cutstyle' ),
                    'left' => esc_html__( 'Left', 'cutstyle' ),
                    'right' => esc_html__( 'Right', 'cutstyle' ),
                    'hide' => esc_html__( 'Hide', 'cutstyle' ),
                ),
            )
        );

        $wp_customize->add_setting( 'pixtheme_tab_breadcrumbs_current' , array(
            'default'     => '0',
            'transport'   => 'postMessage',
            'sanitize_callback' => 'esc_attr'
        ) );
        $wp_customize->add_control(
            'pixtheme_tab_breadcrumbs_current',
            array(
                'label'    => esc_html__( 'Breadcrumbs Show Current Page', 'cutstyle' ),
                'section'  => 'pixtheme_header_settings_tab',
                'settings' => 'pixtheme_tab_breadcrumbs_current',
                'type'     => 'select',
                'choices'  => array(
                    '0' => esc_html__( 'No', 'cutstyle' ),
                    '1' => esc_html__( 'Yes', 'cutstyle' ),
                ),
            )
        );

        $wp_customize->add_setting(	'pixtheme_tab_padding_top', array(
            'default' => get_option('pixtheme_default_tab_padding_top'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new PixTheme_Slider_Single_Control(
                $wp_customize,
                'pixtheme_tab_padding_top',
                array(
                    'label' => esc_html__( 'Padding Top', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_tab',
                    'settings' => 'pixtheme_tab_padding_top',
                    'min' => 0,
                    'max' => 500,
                    'unit' => 'px',
                )
            )
        );

        $wp_customize->add_setting(	'pixtheme_tab_padding_bottom', array(
            'default' => get_option('pixtheme_default_tab_padding_bottom'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new PixTheme_Slider_Single_Control(
                $wp_customize,
                'pixtheme_tab_padding_bottom',
                array(
                    'label' => esc_html__( 'Padding Bottom', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_tab',
                    'settings' => 'pixtheme_tab_padding_bottom',
                    'min' => 0,
                    'max' => 500,
                    'unit' => 'px',
                )
            )
        );

        $wp_customize->add_setting(	'pixtheme_tab_margin_bottom', array(
            'default' => get_option('pixtheme_default_tab_margin_bottom'),
            'transport'   => 'postMessage',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new PixTheme_Slider_Single_Control(
                $wp_customize,
                'pixtheme_tab_margin_bottom',
                array(
                    'label' => esc_html__( 'Margin Bottom', 'cutstyle' ),
                    'section' => 'pixtheme_header_settings_tab',
                    'settings' => 'pixtheme_tab_margin_bottom',
                    'min' => 0,
                    'max' => 200,
                    'unit' => 'px',
                )
            )
        );

		
	}
		
?>