<?php
	
	function pixtheme_customize_shop_tab($wp_customize, $theme_name){

		$pixtheme_pix_slider = array( 0 => esc_html__( 'No RevSlider', 'cutstyle' ) );
		if (class_exists('RevSlider')) {
			$arr = array( 0 => esc_html__( 'No RevSlider', 'cutstyle' ) );

			$pix_sliders 	= new RevSlider();
			$pix_arrSliders = $pix_sliders->getArrSliders();

			foreach($pix_arrSliders as $slider){
			  $arr[$slider->getAlias()] = $slider->getTitle();
			}
			if($arr){
			  $pixtheme_pix_slider = $arr;
			}

		}

		$wp_customize->add_section( 'pixtheme_shop_settings' , array(
		    'title'      => esc_html__( 'Shop', 'cutstyle' ),
		    'priority'   => 50,
		) );



		$wp_customize->add_setting( 'pixtheme_shop_header_slider' , array(
			'default'     => 0,
			'transport'   => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control(
			'pixtheme_shop_header_slider',
			array(
					'label'    => esc_html__( 'Header RevSlider On Main Shop Page', 'cutstyle' ),
					'section'  => 'pixtheme_shop_settings',
					'settings' => 'pixtheme_shop_header_slider',
					'type'     => 'select',
					'choices'  => $pixtheme_pix_slider,
					'priority' => 10
			)
		);

		$wp_customize->add_setting( 'pixtheme_shop_header_image' , array(
			'default'     => '',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field'
		) );
        $wp_customize->add_control(
	        new WP_Customize_Image_Control(
	            $wp_customize,
	            'pixtheme_shop_header_image',
				array(
				   'label'      => esc_html__( 'Header Image', 'cutstyle' ),
				   'section'    => 'pixtheme_shop_settings',
				   'context'    => 'pixtheme_shop_header_image',
				   'settings'   => 'pixtheme_shop_header_image',
				   'priority'   => 20
				)
	       )
	    );

	    $wp_customize->add_setting( 'pixtheme_shop_settings_global_product' , array(
			'default'     => 'on',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'pixtheme_sanitize_onoff'
		) );
		$wp_customize->add_control(
			'pixtheme_shop_settings_global_product',
			array(
				'label'    => esc_html__( 'Global sidebar settings for Product pages', 'cutstyle' ),
				'section'  => 'pixtheme_shop_settings',
				'settings' => 'pixtheme_shop_settings_global_product',
				'description' => esc_html__( 'Global sidebar settings for all Product pages.', 'cutstyle' ),
				'type'     => 'select',
				'choices'  => array(
					'on'  => esc_html__( 'On', 'cutstyle' ),
					'off'  => esc_html__( 'Off', 'cutstyle' ),
				),
				'priority'   => 30
			)
		);

		$wp_customize->add_setting( 'pixtheme_shop_settings_sidebar_type' , array(
			'default'     => '2',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'pixtheme_sanitize_sidebar_blog_type'
		) );
		$wp_customize->add_control(
			'pixtheme_shop_settings_sidebar_type',
			array(
				'label'    => esc_html__( 'Product sidebar type', 'cutstyle' ),
				'section'  => 'pixtheme_shop_settings',
				'settings' => 'pixtheme_shop_settings_sidebar_type',
				'description' => esc_html__( 'Select sidebar type for Product pages.', 'cutstyle' ),
				'type'     => 'select',
				'choices'  => array(
					'1' => esc_html__( 'Full width', 'cutstyle' ),
					'2' => esc_html__( 'Right Sidebar', 'cutstyle' ),
					'3' => esc_html__( 'Left Sidebar', 'cutstyle' ),
				),
				'priority' => 40
			)
		);

		$wp_customize->add_setting( 'pixtheme_shop_settings_sidebar_content' , array(
			'default'     => 'product-sidebar-1',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'pixtheme_sanitize_sidebar_blog_content'
		) );
		$wp_customize->add_control(
			'pixtheme_shop_settings_sidebar_content',
			array(
				'label'    => esc_html__( 'Product sidebar content', 'cutstyle' ),
				'section'  => 'pixtheme_shop_settings',
				'settings' => 'pixtheme_shop_settings_sidebar_content',
				'description' => esc_html__( 'Select sidebar content for product pages', 'cutstyle' ),
				'type'     => 'select',
				'choices'  => array(
					'sidebar-1' => esc_html__( 'WP Default Sidebar', 'cutstyle' ),
					'global-sidebar-1' => esc_html__( 'Blog Sidebar', 'cutstyle' ),
					'portfolio-sidebar-1' => esc_html__( 'Portfolio Sidebar', 'cutstyle' ),
					'shop-sidebar-1' => esc_html__( 'Shop Sidebar', 'cutstyle' ),
					'product-sidebar-1' => esc_html__( 'Product Sidebar', 'cutstyle' ),
					'custom-area-1' => esc_html__( 'Custom Area', 'cutstyle' ),
				),
				'priority' => 50
			)
		);


				
	}
?>