<?php

    function pixtheme_get_option($slug,$_default = false){

	    $slug = 'pixtheme_' . $slug;

        $pix_options = get_theme_mods();

		if (isset($pix_options[$slug])){
			return wp_kses_post($pix_options[$slug]);
		}else{
			if (isset($_default))
				return wp_kses_post($_default);
			else
				return false;
		}

	}

	function pixtheme_vc_get_params_array($arr, $key){
	    $keys_arr = array();
	    if( !empty($key) ){
            foreach($arr as $k => $v){
                if(substr_count($k, $key) > 0){
                    $keys_arr[$k] = $v;
                }
            }
        }
	    return $keys_arr;
    }

	function pixtheme_get_section_content($section_id){

        if ($section_id == 'global'){
            return '';
        }
    
        $section = get_post($section_id);
        $shortcodes_custom_css = get_post_meta( $section_id, '_wpb_shortcodes_custom_css', true );
        if ( ! empty( $shortcodes_custom_css ) ) {
            echo '
                <script>
                    jQuery(function($){
                        $("head").append("<style>'.esc_html($shortcodes_custom_css).'</style>");
                    });
                </script>';
        }
        echo apply_filters('the_content', $section->post_content);

	}

	function pixtheme_get_sections_array(){
		$args = array(
			'post_type'        => 'pixsections',
			'post_status'      => 'publish',
		);
		$pix_sections = array();
		$pix_sections[] = 'Select Section';
		$pix_sections_data = get_posts( $args );
		foreach($pix_sections_data as $pix_section){
			$pix_sections[$pix_section->ID] = $pix_section->post_title;
		}
		return $pix_sections;
	}
