/* customizer preview */

jQuery(function($){

    "use strict";

    var customize = wp.customize;

    customize.bind('ready', function(){
        $.each($('.pix-google-font'), function(){
            var weight_id = $(this).data('weight-id');
            var weights = [];
            var font_weights = $(this).find(':selected').data('weights');
            $('#'+weight_id).find('option').remove().end();
            if(typeof font_weights !== 'undefined' && font_weights.length > 0){
                weights = font_weights.split(",");
                $.each(weights, function(i, item){
                    var $selected = item == $('#'+weight_id).data('value') ? 'selected="selected"' : '';
                    $('#'+weight_id).append("<option value='" + item + "' " + $selected +">" + item + "</option>");
                });
            } else {
                $('#'+weight_id).append("<option value='400'>400</option>");
            }
        })

    });

    customize( 'pixtheme_decor_show', function( value ) {
        if( value.get() == '0' ){
            customize.control( 'pixtheme_decor_img' ).container.hide();
            customize.control( 'pixtheme_decor_width' ).container.hide();
            customize.control( 'pixtheme_decor_height' ).container.hide();
        }

        value.bind( function( to ) {
            if( to == '0' ) {
                customize.control( 'pixtheme_decor_img' ).container.hide();
                customize.control( 'pixtheme_decor_width' ).container.hide();
                customize.control( 'pixtheme_decor_height' ).container.hide();
            } else {
                customize.control( 'pixtheme_decor_img' ).container.show();
                customize.control( 'pixtheme_decor_width' ).container.show();
                customize.control( 'pixtheme_decor_height' ).container.show();
            }
        } );
    } );

    customize( 'pixtheme_decor_img', function( value ) {
        var width = customize.control( 'pixtheme_decor_width' ).setting.get();
        if( value.get() ){
            var img = customize.control( 'pixtheme_decor_img' ).container.find( '.thumbnail.thumbnail-image img' );
            if( img[0] ){
                img[0].width = width;
            }
        }
        value.bind( function( to ) {
            if( to != '' ) {
                var img = customize.control( 'pixtheme_decor_img' ).container.find( '.thumbnail.thumbnail-image img' );
                if( img[0] ){
                    img[0].width = width;
                }
            }
        } );
    } );

    customize( 'pixtheme_decor_width', function( value ) {
        value.bind( function( to ) {
            var img = customize.control( 'pixtheme_decor_img' ).container.find( '.thumbnail.thumbnail-image img' );
            if( img[0] ){
                img[0].width = to;
            }
        } );
    } );



    customize( 'pixtheme_general_settings_logo', function( value ) {
        var width = customize.control( 'pixtheme_general_settings_logo_width' ).setting.get();
        if( value.get() ){
            var img = customize.control( 'pixtheme_general_settings_logo' ).container.find( '.thumbnail.thumbnail-image img' );
            if( img[0] ){
                img[0].width = width;
            }
        }
        value.bind( function( to ) {
            if( to != '' ) {
                var img = customize.control( 'pixtheme_general_settings_logo' ).container.find( '.thumbnail.thumbnail-image img' );
                if( img[0] ){
                    img[0].width = width;
                }
            }
        } );
    } );

    customize( 'pixtheme_general_settings_logo_width', function( value ) {
        value.bind( function( to ) {
            var img = customize.control( 'pixtheme_general_settings_logo' ).container.find( '.thumbnail.thumbnail-image img' );
            if( img[0] ){
                img[0].width = to;
            }
        } );
    } );



    /// Header

    customize( 'pixtheme_header_bar', function( value ) {
        if( value.get() == '0' ){
            customize.control( 'pixtheme_top_bar_background' ).container.hide();
            customize.control( 'pixtheme_top_bar_transparent' ).container.hide();
        }
        value.bind( function( to ) {
            if( to == '0' ) {
                customize.control( 'pixtheme_top_bar_background' ).container.hide();
                customize.control( 'pixtheme_top_bar_transparent' ).container.hide();
            } else {
                customize.control( 'pixtheme_top_bar_background' ).container.show();
                customize.control( 'pixtheme_top_bar_transparent' ).container.show();
            }
        } );
    } );

    function pix_info_sections_hide(){
        customize.control( 'pixtheme_header_info_icon_1' ).container.hide();
        customize.control( 'pixtheme_header_info_title_1' ).container.hide();
        customize.control( 'pixtheme_header_info_1' ).container.hide();
        customize.control( 'pixtheme_header_info_icon_2' ).container.hide();
        customize.control( 'pixtheme_header_info_title_2' ).container.hide();
        customize.control( 'pixtheme_header_info_2' ).container.hide();
        customize.control( 'pixtheme_header_info_icon_3' ).container.hide();
        customize.control( 'pixtheme_header_info_title_3' ).container.hide();
        customize.control( 'pixtheme_header_info_3' ).container.hide();
    }

    function pix_info_sections_toogle(val) {
        if( val == 'info_1' ) {
            pix_info_sections_hide();
            customize.control( 'pixtheme_header_info_icon_1' ).container.show();
            customize.control( 'pixtheme_header_info_title_1' ).container.show();
            customize.control( 'pixtheme_header_info_1' ).container.show();
        } else if( val == 'info_2' ) {
            pix_info_sections_hide();
            customize.control( 'pixtheme_header_info_icon_2' ).container.show();
            customize.control( 'pixtheme_header_info_title_2' ).container.show();
            customize.control( 'pixtheme_header_info_2' ).container.show();
        } else if( val == 'info_3' ) {
            pix_info_sections_hide();
            customize.control( 'pixtheme_header_info_icon_3' ).container.show();
            customize.control( 'pixtheme_header_info_title_3' ).container.show();
            customize.control( 'pixtheme_header_info_3' ).container.show();
        }
    }

    customize( 'pixtheme_header_info_segment', function( value ) {
        if( value.get() == '' ){
            pix_info_sections_hide();
        } else {
            pix_info_sections_toogle(value.get());
        }

        $('#customize-control-pixtheme_header_info_segment .pix-vc-segmented-button input[type=radio]').on('change', function(){
            var val = $(this).val();
            pix_info_sections_toogle(val);
        });

    } );

    customize( 'pixtheme_header_type', function( value ) {
        if( value.get() != 'header3' && value.get() != 'header4' ){
            customize.control( 'pixtheme_header_menu_background' ).container.hide();
            customize.control( 'pixtheme_header_menu_transparent' ).container.hide();
            if( value.get() != 'header4' ){
                customize.control( 'pixtheme_header_info_segment' ).container.hide();
                pix_info_sections_hide();
            }
        }
        value.bind( function( to ) {
            if( to != 'header3' && to != 'header4' ) {
                customize.control( 'pixtheme_header_menu_background' ).container.hide();
                customize.control( 'pixtheme_header_menu_transparent' ).container.hide();
                if( value.get() != 'header4' ){
                    customize.control( 'pixtheme_header_info_segment' ).container.hide();
                    pix_info_sections_hide();
                }
            } else {
                customize.control( 'pixtheme_header_menu_background' ).container.show();
                customize.control( 'pixtheme_header_menu_transparent' ).container.show();
                if( value.get() != 'header4' ){
                    customize.control( 'pixtheme_header_info_segment' ).container.show();
                    pix_info_sections_hide();
                    pix_fonts_use_toogle('info_1');
                }
            }
        } );
    } );



    customize( 'pixtheme_buttons_shadow', function( value ) {
        if( value.get() == '0' ){
            customize.control( 'pixtheme_buttons_shadow_h' ).container.hide();
            customize.control( 'pixtheme_buttons_shadow_v' ).container.hide();
            customize.control( 'pixtheme_buttons_shadow_blur' ).container.hide();
            customize.control( 'pixtheme_buttons_shadow_spread' ).container.hide();
            customize.control( 'pixtheme_buttons_shadow_color' ).container.hide();
            customize.control( 'pixtheme_buttons_shadow_opacity' ).container.hide();
        }

        value.bind( function( to ) {
            if( to == '0' ) {
                customize.control( 'pixtheme_buttons_shadow_h' ).container.hide();
                customize.control( 'pixtheme_buttons_shadow_v' ).container.hide();
                customize.control( 'pixtheme_buttons_shadow_blur' ).container.hide();
                customize.control( 'pixtheme_buttons_shadow_spread' ).container.hide();
                customize.control( 'pixtheme_buttons_shadow_color' ).container.hide();
                customize.control( 'pixtheme_buttons_shadow_opacity' ).container.hide();
            } else {
                customize.control( 'pixtheme_buttons_shadow_h' ).container.show();
                customize.control( 'pixtheme_buttons_shadow_v' ).container.show();
                customize.control( 'pixtheme_buttons_shadow_blur' ).container.show();
                customize.control( 'pixtheme_buttons_shadow_spread' ).container.show();
                customize.control( 'pixtheme_buttons_shadow_color' ).container.show();
                customize.control( 'pixtheme_buttons_shadow_opacity' ).container.show();
            }
        } );
    } );


    function pix_fonts_method_hide(){
        customize.control( 'pixtheme_fonts_embed' ).container.hide();
        customize.control( 'pixtheme_font_api' ).container.hide();
        customize.control( 'pixtheme_fonts_loader' ).container.hide();
    }

    function pix_fonts_method_toogle(val) {
        if( val == 'embed' ) {
            pix_fonts_method_hide();
            customize.control( 'pixtheme_fonts_embed' ).container.show();
        } else if( val == 'gapi' ) {
            pix_fonts_method_hide();
            customize.control( 'pixtheme_font_api' ).container.show();
            customize.control( 'pixtheme_fonts_loader' ).container.show();
        }
    }

    customize( 'pixtheme_fonts_method_segment', function( value ) {

        if( value.get() == '' ){
            pix_fonts_method_toogle('embed');
        } else {
            pix_fonts_method_toogle(value.get());
        }

        $('#customize-control-pixtheme_fonts_method_segment .pix-vc-segmented-button input[type=radio]').on('change', function(){
            var val = $(this).val();
            pix_fonts_method_toogle(val);
        });

    } );



    function pix_fonts_use_hide(){
        customize.control( 'pixtheme_font' ).container.hide();
        customize.control( 'pixtheme_font_weight' ).container.hide();
        customize.control( 'pixtheme_font_size' ).container.hide();
        customize.control( 'pixtheme_font_color' ).container.hide();
        customize.control( 'pixtheme_title_font' ).container.hide();
        customize.control( 'pixtheme_title_font_weight' ).container.hide();
        customize.control( 'pixtheme_title_font_size' ).container.hide();
        customize.control( 'pixtheme_title_font_color' ).container.hide();
        customize.control( 'pixtheme_title_font_style' ).container.hide();
        customize.control( 'pixtheme_title_letter_spacing' ).container.hide();
        customize.control( 'pixtheme_subtitle_font' ).container.hide();
        customize.control( 'pixtheme_subtitle_font_weight' ).container.hide();
        customize.control( 'pixtheme_subtitle_font_size' ).container.hide();
        customize.control( 'pixtheme_subtitle_font_color' ).container.hide();
        customize.control( 'pixtheme_subtitle_font_style' ).container.hide();
        customize.control( 'pixtheme_subtitle_letter_spacing' ).container.hide();
        customize.control( 'pixtheme_link_font' ).container.hide();
        customize.control( 'pixtheme_link_font_weight' ).container.hide();
        customize.control( 'pixtheme_link_font_size' ).container.hide();
        customize.control( 'pixtheme_link_font_color' ).container.hide();
        customize.control( 'pixtheme_link_font_style' ).container.hide();
        customize.control( 'pixtheme_buttons_font' ).container.hide();
        customize.control( 'pixtheme_buttons_font_weight' ).container.hide();
        customize.control( 'pixtheme_buttons_font_size' ).container.hide();
        customize.control( 'pixtheme_buttons_text_transform' ).container.hide();
        customize.control( 'pixtheme_buttons_font_style' ).container.hide();
        customize.control( 'pixtheme_buttons_letter_spacing' ).container.hide();
    }

    function pix_fonts_use_toogle(val) {
        if( val == 'text' ) {
            pix_fonts_use_hide();
            customize.control( 'pixtheme_font' ).container.show();
            customize.control( 'pixtheme_font_weight' ).container.show();
            customize.control( 'pixtheme_font_size' ).container.show();
            customize.control( 'pixtheme_font_color' ).container.show();
        } else if( val == 'title' ) {
            pix_fonts_use_hide();
            customize.control( 'pixtheme_title_font' ).container.show();
            customize.control( 'pixtheme_title_font_weight' ).container.show();
            customize.control( 'pixtheme_title_font_size' ).container.show();
            customize.control( 'pixtheme_title_font_color' ).container.show();
            customize.control( 'pixtheme_title_font_style' ).container.show();
            customize.control( 'pixtheme_title_letter_spacing' ).container.show();
        } else if( val == 'subtitle' ) {
            pix_fonts_use_hide();
            customize.control( 'pixtheme_subtitle_font' ).container.show();
            customize.control( 'pixtheme_subtitle_font_weight' ).container.show();
            customize.control( 'pixtheme_subtitle_font_size' ).container.show();
            customize.control( 'pixtheme_subtitle_font_color' ).container.show();
            customize.control( 'pixtheme_subtitle_font_style' ).container.show();
            customize.control( 'pixtheme_subtitle_letter_spacing' ).container.show();
        } else if( val == 'link' ) {
            pix_fonts_use_hide();
            customize.control( 'pixtheme_link_font' ).container.show();
            customize.control( 'pixtheme_link_font_weight' ).container.show();
            customize.control( 'pixtheme_link_font_size' ).container.show();
            customize.control( 'pixtheme_link_font_color' ).container.show();
            customize.control( 'pixtheme_link_font_style' ).container.show();
        } else if( val == 'button' ) {
            pix_fonts_use_hide();
            customize.control( 'pixtheme_buttons_font' ).container.show();
            customize.control( 'pixtheme_buttons_font_weight' ).container.show();
            customize.control( 'pixtheme_buttons_font_size' ).container.show();
            customize.control( 'pixtheme_buttons_text_transform' ).container.show();
            customize.control( 'pixtheme_buttons_font_style' ).container.show();
            customize.control( 'pixtheme_buttons_letter_spacing' ).container.show();
        }
    }

    customize( 'pixtheme_fonts_use_segment', function( value ) {

        if( value.get() == '' ){
            pix_fonts_use_hide();
        } else {
            pix_fonts_use_toogle(value.get());
        }

        $('#customize-control-pixtheme_fonts_use_segment .pix-vc-segmented-button input[type=radio]').on('change', function(){
            var val = $(this).val();
            pix_fonts_use_toogle(val);
        });

    } );



    $('.pix-vc-segmented-button').each(function () {

        var $container = $(this),
        $input = $container.find('input.pix-input-vc-segmented-button'),
        $radioboxes = $container.find('.pix-segmented-button-field'),
        $value = $input.val();

        //reset all selected value
        $container.find('.pix-segmented-button-field').prop('checked', false);
        $container.find('.pix-segmented-button-field[value="'+ $value +'"]').prop('checked', true);

        $radioboxes.on('click', function() {
            if($(this).prop('checked')) {
                $container.find('.pix-segmented-button-field').prop('checked', false);
                $(this).prop('checked', true);
                $value = $(this).val();
            }
            $input.val($value);
            if( !$input.hasClass('tabs') ) {
                $input.trigger("change");
            }
        });

    });






    /// Google Fonts Loader

    function pix_set_fonts(){
    	var fonts_arr = {};
    	$.each($('.pix-google-font-str'), function(){
    		var num = $(this).attr('data-font-num');
    		if(num >= 0) {
                fonts_arr[num] = $(this).val();
            }
        });
    	var pixJSON = JSON.stringify(fonts_arr)
    	$('#pix-fonts-hidden').val(pixJSON);
    	$('#pix-fonts-hidden').change();
	}

	function pix_set_selected_fonts(){
    	$('.pix-google-font').find('option').remove().end();
    	$.each($('.pix-google-font-str'), function(){
    		var font_family = $(this).val().split(":");
    		var font_weights = '';
    		if(typeof font_family[1] !== 'undefined') {
				font_weights = font_family[1];
			}
    		$('.pix-google-font').append("<option value='" + font_family[0] + "' data-weights='" + font_weights + "'>" + font_family[0] + "</option>");
        });
	}

	function pix_change_selected_weights(){
    	$.each($('.pix-google-font'), function(){
            var weight_id = $(this).data('weight-id');
            var current_weight = $('#'+weight_id).find(':selected').val();
            var font_weights = [];
            font_weights = String($(this).find(':selected').data('weights')).split(',');

            $('#'+weight_id).find('option').remove().end();
            if(font_weights[0] != ''){
                $.each(font_weights, function(i, item){
                    $('#'+weight_id).append("<option value='" + item + "'>" + item + "</option>");
                });
                $('#'+weight_id).val(current_weight);
            } else {
                $('#'+weight_id).append("<option value='400'>400</option>");
            }
        });
	}

	$('#_customize-input-pixtheme_fonts_embed').live('change', function(){
	    $('.pix-google-font').find('option').remove().end();
	    var font_families = [];
	    font_families = $(this).val().split("|");
	    $.each(font_families, function(i, item){
	        var font_family = item.split(":");
	        var font_weights = '';
            if(typeof font_family[1] !== 'undefined') {
				font_weights = font_family[1];
			}
			var font_family_name = font_family[0].replace('+', ' ');
			$('.pix-google-font').append("<option value='" + font_family_name + "' data-weights='" + font_weights + "'>" + font_family_name + "</option>");
        });
    });

	$('.pix-google-font').live('change', function(){
		var weight_id = $(this).data('weight-id');
		var font_weights = [];
		font_weights = String($(this).find(':selected').data('weights')).split(",");
		$('#'+weight_id).find('option').remove().end();
		if(font_weights[0] != ''){
		    $.each(font_weights, function(i, item){
                $('#'+weight_id).append("<option value='" + item + "'>" + item + "</option>");
            });
        } else {
		    $('#'+weight_id).append("<option value='400'>400</option>");
        }
    });

	$('.pix-google-font-add').live('click', function(){
		var pix_count = 0;
		$.each($('.pix-google-font-wrapper'), function(){
            pix_count = ($(this).attr('data-font-num') < pix_count) ? $(this).attr('data-font-num') : pix_count;
        });
		pix_count--;
		var new_wrapper = '<div class="pix-google-font-wrapper" data-font-num="'+pix_count+'"><label class="pix-customize-control-label active">Set Font</label><input type="hidden" class="pix-google-font-str" data-font-num="" value=""><button type="button" class="btn pix-wrapper-delete"><i class="fa fa-trash"></i></button></div>';
		$('.pix-google-font-select').attr('data-font-num', pix_count);
		$('#pix-google-fonts').val('');
		$('#pix-font-weights-content').html('');
		$.each($('.pix-google-font-wrapper'), function(){
            $('.pix-customize-control-label', this).removeClass('active');
        });
		$('#pix-google-font-select').removeClass('close');
		$('.pix-google-font-wrapper').last().after(new_wrapper);
	});

    $('.pix-wrapper-delete').live('click', function(){
    	var font_num = $(this).parent().attr('data-font-num');
    	if(font_num == $('#pix-google-font-select').attr('data-font-num')){
    		$('#pix-google-font-select').addClass('close');
    		$('#pix-font-weights-content').html('');
		}
    	$(this).parent().remove();
		pix_set_fonts();
	});

	$('.pix-customize-control-label').live('click', function(){
		var font_num = $(this).parent().attr('data-font-num');
		var lable_state = $(this).toggleClass('active');
		$.each($('.pix-google-font-wrapper'), function(){
            $('.pix-customize-control-label', this).removeClass('active');
        });
		$(this).addClass('active');
		$('#pix-google-font-select').attr('data-font-num', font_num);
		$('#pix-google-font-select').removeClass('close');

		if(font_num > 0){
			var font_str = $(this).parent().find('.pix-google-font-str').val();
			var font_arr_1 = font_str.split(":");
			var font_arr_2 = [];
			if(typeof font_arr_1[1] !== 'undefined') {
				font_arr_2 = font_arr_1[1].split(",");
			}
			$('#pix-google-fonts').val(font_num);
			$('#pix-font-weights-content').html('');
			$.each(pix_fonts_opt[font_num]['variants'], function(j,item){
				if(item == 'italic'){
					var val = item.replace("italic", "400i");
					var title = '400 italic';
				} else if(item == 'regular') {
					var val = item.replace("regular", "400");
					var title = val;
				} else {
					var val = item.replace("italic", "i");
					var title = item.replace("italic", " italic");
				}
				var checked = $.inArray( val, font_arr_2 ) >= 0 ? "checked='checked'" : "";
				$('#pix-font-weights-content').append("<label><input type='checkbox' class='font_variants_checkbox' value='" + val + "' " + checked + ">" + title + "</label>");
			});
		} else {
			$('#pix-google-fonts').val('');
			$('#pix-font-weights-content').html('');
        }
	});


	if(meta_image.font_api != '') {
        var pix_fonts_opt = [];
        $.getJSON('https://www.googleapis.com/webfonts/v1/webfonts?key=' + meta_image.font_api, function (data) {
            $.each(data["items"], function (i, item) {
                var temp = [];
                temp['category'] = item.category;
                temp['family'] = item.family;
                temp['subsets'] = item.subsets;
                temp['variants'] = item.variants;
                pix_fonts_opt[i] = temp;
            });

            $.each(pix_fonts_opt, function (i, item) {
                $('#pix-google-fonts').append("<option value='" + i + "' data-family='" + item['family'] + "'>" + item['family'] + "</option>");
            });

            $('#pix-google-fonts').on('change', function (e) {
                var font_num = $(this).parent().attr('data-font-num');
                var font_family = $(this).find(':selected').data('family');
                var font_i = $(this).val();
                $('.pix-google-font-wrapper[data-font-num="' + font_num + '"]').attr('data-font-num', font_i);
                $('#pix-google-font-select').attr('data-font-num', font_i);
                $('.pix-google-font-wrapper[data-font-num="' + font_i + '"] .pix-customize-control-label').html(font_family);
                $('.pix-google-font-wrapper[data-font-num="' + font_i + '"] .pix-google-font-str').val(font_family);
                $('.pix-google-font-wrapper[data-font-num="' + font_i + '"] .pix-google-font-str').attr('data-font-num', font_i);
                pix_set_fonts();
                pix_set_selected_fonts();
                $('#pix-font-weights-content').html('');
                $.each(pix_fonts_opt[$(this).val()]['variants'], function (j, item) {
                    if (item == 'italic') {
                        var val = item.replace("italic", "400i");
                        var title = '400 italic';
                    } else if (item == 'regular') {
                        var val = item.replace("regular", "400");
                        var title = val;
                    } else {
                        var val = item.replace("italic", "i");
                        var title = item.replace("italic", " italic");
                    }
                    $('#pix-font-weights-content').append("<label><input type='checkbox' class='font_variants_checkbox' value='" + val + "'>" + title + "</label>");
                });

            });

            $('.font_variants_checkbox').live('change', function (e) {
                var font_num = $('#pix-font-weights-content').parent().attr('data-font-num');
                var font_family = $('#pix-google-fonts').find(':selected').data('family');
                var str = '';
                $("input.font_variants_checkbox:checked").each(function (i, item) {
                    if (i == 0)
                        str = $(this).val()
                    else
                        str = str + ',' + $(this).val();
                });
                $('.pix-google-font-wrapper[data-font-num="' + font_num + '"] .pix-customize-control-label').html(font_family + ': ' + str);
                $('.pix-google-font-wrapper[data-font-num="' + font_num + '"] .pix-google-font-str').val(font_family + ':' + str);
                pix_set_fonts();
                pix_set_selected_fonts();
                pix_change_selected_weights();
            });

        });

    }


});
