<?php header("Content-type: text/css; charset: UTF-8");

$page_id = isset($_REQUEST['pageID']) ? $_REQUEST['pageID'] : 0;

function pix_hash($val){
    return esc_attr(str_replace('#', '%23', $val));
}

$pixtheme_customize = get_option( 'pixtheme_customize_options' );


$pixtheme_font = pixtheme_get_option('font', get_option('pixtheme_default_font'));
$pixtheme_font_weight = pixtheme_get_option('font_weight', get_option('pixtheme_default_font_weight'));
$pixtheme_font_size = pixtheme_get_option('font_size', get_option('pixtheme_default_font_size'));
$pixtheme_font_color = pixtheme_get_option('font_color', get_option('pixtheme_default_font_color'));

$pixtheme_title = pixtheme_get_option('title_font', get_option('pixtheme_default_title_font'));
$pixtheme_title_weight = pixtheme_get_option('title_font_weight', get_option('pixtheme_default_title_weight'));
$pixtheme_title_size = pixtheme_get_option('title_font_size', get_option('pixtheme_default_title_size'));
$pixtheme_title_style = pixtheme_get_option('title_font_style', 'normal');
$pixtheme_title_color = pixtheme_get_option('title_font_color', get_option('pixtheme_default_title_color'));
$pixtheme_title_letter_spacing = pixtheme_get_option('title_letter_spacing', '0');

$pixtheme_subtitle = pixtheme_get_option('subtitle_font', get_option('pixtheme_default_subtitle_font'));
$pixtheme_subtitle_weight = pixtheme_get_option('subtitle_font_weight', get_option('pixtheme_default_subtitle_weight'));
$pixtheme_subtitle_size = pixtheme_get_option('subtitle_font_size', get_option('pixtheme_default_subtitle_size'));
$pixtheme_subtitle_style = pixtheme_get_option('subtitle_font_style', 'normal');
$pixtheme_subtitle_color = pixtheme_get_option('subtitle_font_color', get_option('pixtheme_default_subtitle_color'));
$pixtheme_subtitle_letter_spacing = pixtheme_get_option('subtitle_letter_spacing', '0');

$pixtheme_hlink = pixtheme_get_option('link_font', get_option('pixtheme_default_link_font'));
$pixtheme_hlink_weight = pixtheme_get_option('link_font_weight', get_option('pixtheme_default_link_weight'));
$pixtheme_hlink_size = pixtheme_get_option('link_font_size', get_option('pixtheme_default_link_size'));
$pixtheme_hlink_style = pixtheme_get_option('link_font_style', 'normal');
$pixtheme_hlink_color = pixtheme_get_option('link_font_color', get_option('pixtheme_default_link_color'));

$pixtheme_main_color = pixtheme_get_option('style_settings_main_color', get_option('pixtheme_default_main_color'));
$pixtheme_gradient_color = pixtheme_get_option('style_settings_gradient_color', get_option('pixtheme_default_gradient_color'));
$pixtheme_gradient_direction = pixtheme_get_option('gradient_direction', get_option('pixtheme_default_gradient_direction'));
$pixtheme_additional_color = pixtheme_get_option('style_settings_additional_color', get_option('pixtheme_default_additional_color'));
$pixtheme_black_color = pixtheme_get_option('style_settings_black_color', get_option('pixtheme_default_black_color'));
$page_color = get_post_meta($_REQUEST['pageID'], 'page_main_color', 1);
if($page_color){
	$pixtheme_main_color = $page_color;
}
$pixtheme_dark = pixtheme_get_option('style_theme_tone', '') == '' ? '#333' : '#fff';

$page_layout = get_post_meta($_REQUEST['pageID'], 'page_layout', 1) != '' ? get_post_meta($_REQUEST['pageID'], 'page_layout', 1) : pixtheme_get_option('style_general_settings_layout', 'normal');
$page_bg_image = get_post_meta($_REQUEST['pageID'], 'boxed_bg_image', 1) != '' ? get_post_meta($_REQUEST['pageID'], 'boxed_bg_image', 1) : pixtheme_get_option('general_settings_bg_image', '');
$page_bg_color = get_post_meta($_REQUEST['pageID'], 'page_bg_color', 1) != '' ? get_post_meta($_REQUEST['pageID'], 'page_bg_color', 1) : pixtheme_get_option('style_settings_bg_color', '');

$tab_bg_image_fixed = pixtheme_get_option('tab_bg_image_fixed', '0');
$tab_bg_color = pixtheme_get_option('tab_bg_color', get_option('pixtheme_default_tab_bg_color')); //pixtheme_hex2rgb(pixtheme_get_option('tab_bg_color', '#000000'));
$tab_bg_color_gradient = pixtheme_get_option('tab_bg_color_gradient', get_option('pixtheme_default_tab_bg_color_gradient'));
$tab_gradient_direction = pixtheme_get_option('tab_gradient_direction', get_option('pixtheme_default_tab_gradient_direction'));
$tab_bg_opacity = pixtheme_get_option('tab_bg_opacity', get_option('pixtheme_default_tab_bg_opacity'))/100;
$tab_padding_top = pixtheme_get_option('tab_padding_top', get_option('pixtheme_default_tab_padding_top'));
$tab_padding_bottom = pixtheme_get_option('tab_padding_bottom', get_option('pixtheme_default_tab_padding_bottom'));
$tab_margin_bottom = pixtheme_get_option('tab_margin_bottom', get_option('pixtheme_default_tab_margin_bottom'));

$gradient_direction = $tab_gradient_direction == '' ? 'to right' : $tab_gradient_direction;
$pix_directions_arr = array(
    'to right' => array('-webkit' => 'left', '-o-linear' => 'right', '-moz-linear' => 'right', 'linear' => 'to right',),
    'to left' => array('-webkit' => 'right', '-o-linear' => 'left', '-moz-linear' => 'left', 'linear' => 'to left',),
    'to bottom' => array('-webkit' => 'top', '-o-linear' => 'bottom', '-moz-linear' => 'bottom', 'linear' => 'to bottom',),
    'to top' => array('-webkit' => 'bottom', '-o-linear' => 'top', '-moz-linear' => 'top', 'linear' => 'to top',),
    'to bottom right' => array('-webkit' => 'left top', '-o-linear' => 'bottom right', '-moz-linear' => 'bottom right', 'linear' => 'to bottom right',),
    'to bottom left' => array('-webkit' => 'right top', '-o-linear' => 'bottom left', '-moz-linear' => 'bottom left', 'linear' => 'to bottom left',),
    'to top right' => array('-webkit' => 'left bottom', '-o-linear' => 'top right', '-moz-linear' => 'top right', 'linear' => 'to top right',),
    'to top left' => array('-webkit' => 'right bottom', '-o-linear' => 'top left', '-moz-linear' => 'top left', 'linear' => 'to top left',),
    //'angle' => array('-webkit' => $gradient_angle.'deg', '-o-linear' => $gradient_angle.'deg', '-moz-linear' => $gradient_angle.'deg', 'linear' => $gradient_angle.'deg',),
);

$decor_show = pixtheme_get_option('decor_show', '1');
$decor_img = pixtheme_get_option('decor_img', '');
$decor_width = pixtheme_get_option('decor_width', '40');
$decor_height = pixtheme_get_option('decor_height', '20');

$buttons_border = pixtheme_get_option('buttons_border', '1');
$buttons_font = pixtheme_get_option('buttons_font', get_option('pixtheme_default_button_font'));
$buttons_font_size = pixtheme_get_option('buttons_font_size', get_option('pixtheme_default_button_font_size'));
$buttons_font_weight = pixtheme_get_option('buttons_font_weight', get_option('pixtheme_default_button_font_weight'));
$buttons_font_style = pixtheme_get_option('buttons_font_style', 'normal');
$buttons_text_transform = pixtheme_get_option('buttons_text_transform', 'none');
$buttons_letter_spacing = pixtheme_get_option('buttons_letter_spacing', '0');
$buttons_shadow = pixtheme_get_option('buttons_shadow', '1');

$loader_img = pixtheme_get_option('loader_img', '');

?>

:root{
    --pix-header-transparent: <?php echo esc_attr(pixtheme_get_option('header_transparent', '0')/100)?>;
    --pix-header-height: <?php echo esc_attr(pixtheme_get_option('general_settings_logo_height', get_option('pixtheme_default_logo_height')))?>px;
    --pix-header-height-levels: <?php echo esc_attr(pixtheme_get_option('general_settings_logo_height', get_option('pixtheme_default_logo_height'))+38)?>px;
    --pix-top-bar-transparent: <?php echo esc_attr(pixtheme_get_option('top_bar_transparent', '100')/100)?>;

    --pix-main-color: <?php echo esc_attr($pixtheme_main_color)?>;
    --pix-main-color-hex: <?php echo esc_attr(pixtheme_hex2rgb($pixtheme_main_color))?>;
    --pix-gradient-color: <?php echo esc_attr($pixtheme_gradient_color)?>;
    --pix-additional-color: <?php echo esc_attr($pixtheme_additional_color)?>;
    --pix-black-color: <?php echo esc_attr($pixtheme_black_color)?>;

    --pix-main-font: <?php echo esc_attr($pixtheme_font)?>;
    --pix-font-size: <?php echo esc_attr($pixtheme_font_size)?>px;
    --pix-font-weight: <?php echo esc_attr($pixtheme_font_weight)?>;
    --pix-font-color: <?php echo esc_attr($pixtheme_font_color)?>;

    --pix-title-font: <?php echo esc_attr($pixtheme_title)?>;
    --pix-title-size: <?php echo esc_attr($pixtheme_title_size)?>px;
    --pix-title-weight: <?php echo esc_attr($pixtheme_title_weight)?>;
    --pix-title-style: <?php echo esc_attr($pixtheme_title_style)?>;
    --pix-title-color: <?php echo esc_attr($pixtheme_title_color)?>;
    --pix-title-letter-spacing: <?php echo esc_attr($pixtheme_title_letter_spacing)?>;

    --pix-subtitle-font: <?php echo esc_attr($pixtheme_subtitle)?>;
    --pix-subtitle-size: <?php echo esc_attr($pixtheme_subtitle_size)?>px;
    --pix-subtitle-weight: <?php echo esc_attr($pixtheme_subtitle_weight)?>;
    --pix-subtitle-style: <?php echo esc_attr($pixtheme_subtitle_style)?>;
    --pix-subtitle-color: <?php echo esc_attr($pixtheme_subtitle_color)?>;
    --pix-subtitle-letter-spacing: <?php echo esc_attr($pixtheme_subtitle_letter_spacing)?>;

    --pix-hlink-font: <?php echo esc_attr($pixtheme_hlink)?>;
    --pix-hlink-size: <?php echo esc_attr($pixtheme_hlink_size)?>px;
    --pix-hlink-weight: <?php echo esc_attr($pixtheme_hlink_weight)?>;
    --pix-hlink-style: <?php echo esc_attr($pixtheme_hlink_style)?>;
    --pix-hlink-color: <?php echo esc_attr($pixtheme_hlink_color)?>;

    --pix-buttons-border: <?php echo esc_attr($buttons_border)?>px;
    --pix-buttons-font: <?php echo esc_attr($buttons_font)?>;
    --pix-buttons-font-size: <?php echo esc_attr($buttons_font_size)?>px;
    --pix-buttons-font-weight: <?php echo esc_attr($buttons_font_weight)?>;
    --pix-buttons-font-style: <?php echo esc_attr($buttons_font_style)?>;
    --pix-buttons-text-transform: <?php echo esc_attr($buttons_text_transform)?>;
    --pix-buttons-letter-spacing: <?php echo esc_attr($buttons_letter_spacing)?>px;
    --pix-buttons-shadow: <?php echo !$buttons_shadow ? 'none' : esc_attr(pixtheme_get_option('buttons_shadow_h', '5')).'px '.esc_attr(pixtheme_get_option('buttons_shadow_v', '5')).'px '.esc_attr(pixtheme_get_option('buttons_shadow_blur', '0')).'px '.esc_attr(pixtheme_get_option('buttons_shadow_spread', '0')).'px rgba('.esc_attr(pixtheme_hex2rgb(pixtheme_get_option('buttons_shadow_color', $pixtheme_main_color))).','.esc_attr(pixtheme_get_option('buttons_shadow_opacity', '100')/100).')' ?>;

    --pix-hover-gradient: linear-gradient(to left, rgba(<?php echo esc_attr(pixtheme_hex2rgb($pixtheme_main_color))?>, 0.9), rgba(<?php echo esc_attr(pixtheme_hex2rgb($pixtheme_gradient_color))?>, 0.9));
    --pix-hover-gradient: rgba(0,0,0,.4);


    --pix-svg-quote: url(<?php if(pixtheme_get_option('dynamic_style', '0') != '1') : ?>'data:image/svg+xml;charset=utf8,%3Csvg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 50 50" fill="<?php echo pix_hash($pixtheme_main_color)?>"%3E  %3Cpath d="M2,6.6v1v19h11v2c0,2-0.6,3.8-1.6,5.1S9.3,35.6,8,35.6H7v7h1c7.7,0,14-6.3,14-14v-3v-2v-17H2z M28,6.6v1v19h11  v2c0,2-0.6,3.8-1.6,5.1s-2.1,1.9-3.4,1.9h-1v7h1c7.7,0,14-6.3,14-14v-3v-2v-17H28z M4,8.6h16v15v2v3c0,6.3-4.9,11.3-11,11.8v-3.1  c1.6-0.3,3-1.1,4-2.5c1.2-1.6,2-3.8,2-6.3v-4H4V8.6z M30,8.6h16v15v2v3c0,6.3-4.9,11.3-11,11.8v-3.1c1.6-0.3,3-1.1,4-2.5  c1.2-1.6,2-3.8,2-6.3v-4H30V8.6z"/%3E %3C/svg%3E'<?php else : echo esc_url(get_template_directory_uri().'/images/svg/color/quote.svg'); endif;?>);

    --pix-svg-search-white: url(<?php echo esc_url(get_template_directory_uri().'/images/svg/search-white.svg'); ?>);
    --pix-svg-search: url(<?php echo esc_url(get_template_directory_uri().'/images/svg/search.svg'); ?>);
    --pix-svg-search-hover: url(<?php if(pixtheme_get_option('dynamic_style', '0') != '1') : ?>"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='<?php echo pix_hash($pixtheme_main_color)?>' viewBox='0 0 56.966 56.966'%3E%3Cpath d='M55.146 51.887L41.588 37.786c3.486-4.144 5.396-9.358 5.396-14.786 0-12.682-10.318-23-23-23s-23 10.318-23 23 10.318 23 23 23c4.761 0 9.298-1.436 13.177-4.162l13.661 14.208c.571.593 1.339.92 2.162.92.779 0 1.518-.297 2.079-.837 1.192-1.147 1.23-3.049.083-4.242zM23.984 6c9.374 0 17 7.626 17 17s-7.626 17-17 17-17-7.626-17-17 7.626-17 17-17z'/%3E%3C/svg%3E"<?php else : echo esc_url(get_template_directory_uri().'/images/svg/color/search-hover.svg'); endif;?>);

    --pix-svg-services: url(<?php echo esc_url(get_template_directory_uri().'/images/svg/service.svg'); ?>);
    --pix-svg-services-hover: url(<?php if(pixtheme_get_option('dynamic_style', '0') != '1') : ?>"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='<?php echo pix_hash($pixtheme_main_color)?>' viewBox='0 0 56 56'%3E%3Cpath d='M8 40c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM28 40c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM48 40c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM8 20c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM28 20c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM48 20c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM8 0C3.589 0 0 3.589 0 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM28 0c-4.411 0-8 3.589-8 8s3.589 8 8 8 8-3.589 8-8-3.589-8-8-8zM48 16c4.411 0 8-3.589 8-8s-3.589-8-8-8-8 3.589-8 8 3.589 8 8 8z'/%3E%3C/svg%3E"<?php else : echo esc_url(get_template_directory_uri().'/images/svg/color/services-hover.svg'); endif;?>);

    --pix-svg-checked: url(<?php if(pixtheme_get_option('dynamic_style', '0') != '1') : ?>"data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' width='15px' fill='<?php echo pix_hash($pixtheme_main_color)?>' viewBox='0 0 442.533 442.533'%3E%3Cpath d='M434.539 98.499l-38.828-38.828c-5.324-5.328-11.799-7.993-19.41-7.993-7.618 0-14.093 2.665-19.417 7.993L169.59 247.248l-83.939-84.225c-5.33-5.33-11.801-7.992-19.412-7.992-7.616 0-14.087 2.662-19.417 7.992L7.994 201.852C2.664 207.181 0 213.654 0 221.269c0 7.609 2.664 14.088 7.994 19.416l103.351 103.349 38.831 38.828c5.327 5.332 11.8 7.994 19.414 7.994 7.611 0 14.084-2.669 19.414-7.994l38.83-38.828L434.539 137.33c5.325-5.33 7.994-11.802 7.994-19.417.004-7.611-2.669-14.084-7.994-19.414z' /%3E%3C/svg%3E"<?php else : echo esc_url(get_template_directory_uri().'/images/svg/color/checked.svg'); endif;?>);
    --pix-svg-checked-dark: url(<?php echo esc_url(get_template_directory_uri().'/images/svg/checked-dark.svg'); ?>);

    --pix-svg-loader: url(<?php if($loader_img == '') : ?>'data:image/svg+xml;utf8,%3Csvg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="<?php echo pix_hash($pixtheme_main_color)?>" viewBox="0 0 140 64" xml:space="preserve"%3E%3Cg%3E%3Cpath d="M19.7,24.9c0,0,2.2-2.9,0.9-5.5C17,12,5,17.5,5.8,27.6c0,0,0.8,20.8,32.6,21.8c8.3,0.3,19.5-1.4,28.5-10.7 c6.2-6.4,4.5-18.2-3.4-20.9c-8.6-3-19.6-0.8-27.8,10.9c-7.8,11.1-23.2,3.4-23-4C12.8,17.8,21.3,20.4,19.7,24.9z"/%3E%3Cpath d="M119.8,24.9c0,0-2.2-2.9-0.9-5.5c3.6-7.4,15.6-1.9,14.8,8.2c0,0-0.8,20.8-32.6,21.8 c-8.3,0.3-19.5-1.4-28.5-10.7c-6.2-6.4-4.5-18.2,3.4-20.9c8.6-3,19.6-0.8,27.8,10.9c7.8,11.1,23.2,3.4,23-4 C126.7,17.8,118.2,20.4,119.8,24.9z"/%3E%3C/g%3E%3C/svg%3E'<?php else : echo esc_url($loader_img); endif;?>);

}

<?php if($decor_show) : ?>
html .sep-element{
    <?php if($decor_img) : ?>
    background: url(<?php echo esc_url($decor_img)?>) no-repeat;
    background-size: contain;
    width: <?php echo esc_attr($decor_width)?>px;
    height: <?php echo esc_attr($decor_height)?>px;
    border: none !important;
    <?php endif; ?>
}
<?php else : ?>
html .sep-element{
	display: none;
}
<?php endif; ?>




<?php
		/*   PAGE HEADER BACKGROUND   */
?>
<?php
if($tab_bg_color != '' && $tab_bg_color_gradient != ''){
	//$gradient_angle = $tab_bg_color_gradient == '' ? '90' : $tab_bg_color_gradient;

	$pix_gradient = ', '.$tab_bg_color.','.$tab_bg_color_gradient;

	?>

	html .header-section span.vc_row-overlay{
		background: <?php echo esc_attr($tab_bg_color)?>; /* For browsers that do not support gradients */
		background: -webkit-linear-gradient(<?php echo esc_attr($pix_directions_arr[$gradient_direction]['-webkit'].$pix_gradient)?>); /*Safari 5.1-6*/
		background: -o-linear-gradient(<?php echo esc_attr($pix_directions_arr[$gradient_direction]['-o-linear'].$pix_gradient)?>); /*Opera 11.1-12*/
		background: -moz-linear-gradient(<?php echo esc_attr($pix_directions_arr[$gradient_direction]['-moz-linear'].$pix_gradient)?>); /*Fx 3.6-15*/
		background: linear-gradient(<?php echo esc_attr($pix_directions_arr[$gradient_direction]['linear'].$pix_gradient)?>); /*Standard*/
		opacity: <?php echo esc_attr($tab_bg_opacity)?>;
	}

	<?php
} else {
?>
html .header-section span.vc_row-overlay{
	background-color: <?php echo esc_attr($tab_bg_color); ?> !important;
	opacity: <?php echo esc_attr($tab_bg_opacity)?>;
}
<?php
}
?>




<?php
		/*   GRADIENT   */
?>
<?php
if($pixtheme_main_color != '' && $pixtheme_gradient_color != '' && $pixtheme_main_color != $pixtheme_gradient_color){

	$pix_theme_gradient = ', '.$pixtheme_main_color.','.$pixtheme_gradient_color;

	?>

	html .pix-gradient,
    html .pix-item-review .round,
    html .pix-item-left .round,
    html .pix-item-default .round,
    html .news-card-price__header,
    html .pix-progress-bar,
    html .news-card-centered__image .overlay,
    html .pix-overlay.pix-color
    {
		background: <?php echo esc_attr($pixtheme_main_color)?>; /* For browsers that do not support gradients */
		background: -webkit-linear-gradient(<?php echo esc_attr($pix_directions_arr[$pixtheme_gradient_direction]['-webkit'].$pix_theme_gradient)?>); /*Safari 5.1-6*/
		background: -o-linear-gradient(<?php echo esc_attr($pix_directions_arr[$pixtheme_gradient_direction]['-o-linear'].$pix_theme_gradient)?>); /*Opera 11.1-12*/
		background: -moz-linear-gradient(<?php echo esc_attr($pix_directions_arr[$pixtheme_gradient_direction]['-moz-linear'].$pix_theme_gradient)?>); /*Fx 3.6-15*/
		background: linear-gradient(<?php echo esc_attr($pix_directions_arr[$pixtheme_gradient_direction]['linear'].$pix_theme_gradient)?>); /*Standard*/
	}

    html .transparent.pix-icon-color .icon span,
    html .news-item-price-long__price .icon-message span
    {
        background: -webkit-linear-gradient(<?php echo esc_attr($pix_directions_arr[$pixtheme_gradient_direction]['-webkit'].$pix_theme_gradient)?>); /*Safari 5.1-6*/
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
	}

	<?php
}
?>




<?php
		/*   DECOR   */
?>

html .header-section{
	padding: <?php echo esc_attr($tab_padding_top)?>px 0 <?php echo esc_attr($tab_padding_bottom)?>px;
	margin-bottom: <?php echo esc_attr($tab_margin_bottom)?>px;
    background-size: cover;
    background-repeat: no-repeat;
    background-position: 50% 50%;
    <?php if($tab_bg_image_fixed) : ?>
    background-attachment: fixed;
    <?php endif; ?>
}

section.pix-page-no-padding{
    margin-top: -<?php echo esc_attr($tab_margin_bottom)?>px;
}

<?php
		/*   IMAGE FILTER   */
?>
<?php
if(pixtheme_get_option('img_filter', '') == 'pix-filter-mist'){

	?>

	html .news-card-gradient img,
    html .rtd .wpb_single_image:not(.pix-no-filter) img
    {
		-webkit-filter: sepia(10%) brightness(80%) contrast(65%);
		filter: sepia(10%) brightness(80%) contrast(65%);
	}

    html .woocommerce img,
    html .woocommerce-page img,
    html .news-card-profile__header img,
    html .news-card-people__image img,
    html .news-card-feedback__image img,
    html .wpb_single_image img
    {
        -webkit-filter: sepia(10%) saturate(70%);
		filter: sepia(15%) saturate(70%);
	}

	<?php
}
?>
