<?php 
	/**  Theme_index  **/

    include_once( get_template_directory() . '/pixtheme/functions/styles_scripts.php' );
    include_once( get_template_directory() . '/pixtheme/functions/functions.php' );
    include_once( get_template_directory() . '/pixtheme/functions/comment_walker.php' );
    include_once( get_template_directory() . '/pixtheme/functions/menu_walker.php' );
    include_once( get_template_directory() . '/pixtheme/functions/portfolio_walker.php' );
    include_once( get_template_directory() . '/pixtheme/functions/woo.php' );
    include_once( get_template_directory() . '/pixtheme/functions/defaults.php' );


	function pixtheme_setup()
    {
	    // Language support
	    load_theme_textdomain('cutstyle', get_template_directory() . '/languages');
	    $locale      = get_locale();
	    $locale_file = get_template_directory() . "/languages/$locale.php";
	    if (is_readable($locale_file)) {
	        require_once(get_template_directory() . "/languages/$locale.php");
	    }

	    // ADD SUPPORT FOR POST THUMBS
	    add_theme_support('post-thumbnails');
	    // Define various thumbnail sizes
		$width = ( ( pixtheme_get_option( 'portfolio_settings_thumb_width', '555' ) ) &&
					 is_numeric( pixtheme_get_option( 'portfolio_settings_thumb_width', '555' ) ) &&
					 pixtheme_get_option( 'portfolio_settings_thumb_width', '555' ) > 0
				 ) ? pixtheme_get_option( 'portfolio_settings_thumb_width', '555' ) : 555;
		$height = ( ( pixtheme_get_option( 'portfolio_settings_thumb_height', '555' ) ) &&
					 is_numeric( pixtheme_get_option( 'portfolio_settings_thumb_height', '555' ) ) &&
					 pixtheme_get_option( 'portfolio_settings_thumb_height', '555' ) > 0
				 ) ? pixtheme_get_option( 'portfolio_settings_thumb_height', '555' ) : 555;
		add_image_size('pixtheme-portfolio-thumb', $width, $height, true);
		add_image_size('pixtheme-blog-thumb', 840, 415, true);
		add_image_size('pixtheme-services-thumb', 410, 280, true);
		add_image_size('pixtheme-post-thumb', 400, 560, true);
		add_image_size('pixtheme-thumb', 200, 110, true);

	    add_theme_support('widgets');
	    add_theme_support('title-tag');
	    add_theme_support('automatic-feed-links');
	    add_theme_support('post-formats', array(
	        'gallery',
	        'video',
	        'quote',
	    ));
	    $args = array(
	        'flex-width' => true,
	        'width' => 350,
	        'flex-height' => true,
	        'height' => 'auto',
	        'default-image' => get_template_directory_uri() . '/images/logo.svg'
	    );
	    add_theme_support('custom-header', $args);
	    $args = array(
	        'default-color' => 'FFFFFF'
	    );
	    add_theme_support('custom-background', $args);

	    add_theme_support( 'woocommerce', array(
	        'single_image_width'            => 600,
            'thumbnail_image_width'         => 400,
            'gallery_thumbnail_image_width' => 300,
        ) );
		//add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

	}

	/* Register 5 navi types */
	function pixtheme_custom_menus() {

	    /* Register Navigations */
        register_nav_menus(array(
            'primary_nav' => esc_html__('Primary Navigation', 'cutstyle'),
            'secondary_nav' => esc_html__('Secondary Navigation', 'cutstyle'),
            'top_nav' => esc_html__('Top Navigation', 'cutstyle'),
            'footer_nav' => esc_html__('Footer Navigation', 'cutstyle'),
		    'mobile_nav' => esc_html__('Mobile Navigation', 'cutstyle'),
        ));
    }


	add_action('after_setup_theme', 'pixtheme_setup');
	add_action('init', 'pixtheme_custom_menus');

	if ( ! isset( $content_width ) ) {
		$content_width = 1200;
	}

?>