<?php
function pixtheme_fonts_url($post_id) {
	$fonts_url = '';

	$font_families = array();

	if(pixtheme_get_option('fonts_method_segment', 'embed') == 'embed') {
	    $font_families[] = pixtheme_get_option('fonts_embed', get_option('pixtheme_default_fonts_embed'));
    } else {
        $pix_fonts = json_decode(pixtheme_get_option('fonts_loader', get_option('pixtheme_default_fonts')));
        if(!empty($pix_fonts)) {
            foreach ($pix_fonts as $key => $val) {
                $font_families[] = $val;
            }
        }
    }

    if(!empty($font_families)) {
        $query_args = array(
            'family' => str_replace('%2B', '+', urlencode(implode('|', $font_families))),
            'subset' => urlencode('latin,latin-ext'),
        );
        $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
    }

	return esc_url_raw( $fonts_url );
}

add_filter('woocommerce_enqueue_styles', 'pixtheme_load_woo_styles');
function pixtheme_load_woo_styles($styles){
	if (isset($styles['woocommerce-general']) && isset($styles['woocommerce-general']['src'])){
		$styles['woocommerce-general']['src'] = get_template_directory_uri() . '/assets/woocommerce/css/woocommerce.css';
	}
	return $styles;
}


function pixtheme_load_styles_scripts(){

    wp_enqueue_style('style', get_stylesheet_uri());

    /* PRIMARY CSS */
    $booking_page = get_page_by_title( 'Booking');
    $booking_page_id = isset($booking_page->ID) ? $booking_page->ID : '';
	if (pixtheme_get_option('general_settings_responsive','1') && get_the_ID() != $booking_page_id){
		wp_enqueue_style('pixtheme-responsive', get_template_directory_uri() . '/css/responsive.css');
	}else{
		wp_enqueue_style('pixtheme-no-responsive', get_template_directory_uri() . '/css/no-responsive.css');
	}
    wp_enqueue_style('pixtheme-fonts', pixtheme_fonts_url(get_the_ID()), array(), null );
    wp_enqueue_style('grid', get_template_directory_uri() . '/assets/grid/grid.min.css');

    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/fonts/font-awesome/css/font-awesome.min.css');
    wp_enqueue_style('simple-line-icons', get_template_directory_uri() . '/fonts/simple/simple-line-icons.css');

	wp_enqueue_style('pixtheme-main', get_template_directory_uri() . '/css/main.css');


	wp_enqueue_style('owl.carousel', get_template_directory_uri() . '/assets/owl-carousel/owl.carousel.min.css');
	wp_enqueue_style('owl.theme.default', get_template_directory_uri() . '/assets/owl-carousel/owl.theme.default.min.css');

	wp_enqueue_style('animate', get_template_directory_uri() . '/assets/animate/animate.css');




    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

    // Magnific-Popup
    wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/assets/magnific-popup/magnific-popup.css');
    wp_enqueue_script('magnific-popup', get_template_directory_uri() . '/assets/magnific-popup/jquery.magnific-popup.min.js', array('jquery') , null, true);
    
    wp_enqueue_script('animate-css', get_template_directory_uri() . '/assets/animate/animate-css.js', array() , null, true);
    wp_enqueue_script('owl.carousel', get_template_directory_uri() . '/assets/owl-carousel/owl.carousel.min.js', array() , null, true);
    wp_enqueue_script('isotope', get_template_directory_uri() . '/assets/isotope/isotope.pkgd.min.js', array() , null, true);
    wp_enqueue_script('waypoints', get_template_directory_uri() . '/assets/waypoints/waypoints.min.js', array() , null, true);
    wp_enqueue_script('easypiechart', get_template_directory_uri() . '/assets/easypiechart/jquery.easypiechart.min.js', array('jquery') , null, true);

    $map_api = pixtheme_get_option('map_api', '');
    if($map_api != '') {
        wp_enqueue_script('google-maps-api', "//maps.googleapis.com/maps/api/js?key=$map_api&libraries=places");
    }
    
    // CUSTOM SCRIPT
    wp_enqueue_style('pixtheme-dynamic-styles', admin_url('admin-ajax.php').'?action=dynamic_styles&pageID='.get_the_ID());
    wp_enqueue_script('pixtheme-common', get_template_directory_uri() . '/js/common.js', array() , null, true);

    ob_start();
    get_template_part('searchform');
    $search_form = ob_get_contents();
    ob_end_clean();

    wp_localize_script( 'pixtheme-common', 'pix_js_vars',
        array(
            'search_form' => $search_form,
        )
    );



}
add_action('wp_enqueue_scripts', 'pixtheme_load_styles_scripts');


function pixtheme_dynamic_styles() {
	include( get_template_directory().'/pixtheme/functions/dynamic-styles.php' );
	exit;
}
add_action('wp_ajax_dynamic_styles', 'pixtheme_dynamic_styles');
add_action('wp_ajax_nopriv_dynamic_styles', 'pixtheme_dynamic_styles');



add_filter('body_class','pixtheme_browser_body_class');
function pixtheme_browser_body_class($classes = '') {

    $classes[] = pixtheme_get_option('theme_boxes_shape', 'pix-square');
    $classes[] = pixtheme_get_option('buttons_shape', 'pix-square').'-buttons';
    $classes[] = pixtheme_get_option('style_theme_tone', '');

    return $classes;
}

?>