<?php
/*** The template for displaying search results pages. ***/

$pixtheme_custom =  get_post_custom(get_the_ID());
$pixtheme_layout = isset( $pixtheme_custom['pix_page_layout'] ) ? $pixtheme_custom['pix_page_layout'][0] : '2';
$pixtheme_sidebar = isset( $pixtheme_custom['pix_selected_sidebar'][0] ) ? $pixtheme_custom['pix_selected_sidebar'][0] : 'sidebar-1';


$blog_class = pixtheme_get_option('blog_settings_type', 'classic') == 'grid' ? 'row blog-masonry' : 'blog-list';
?>

<?php get_header();?>
    <section class="blog" id="pageContent">
        <div class="container">
            <div class="row">

                <?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>

				<div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12<?php else : ?>col-lg-8 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?><?php endif; ?> col-md-12 col-sm-12 col-xs-12">

                <?php if ( have_posts() ) : ?>

                    <section class="<?php echo esc_attr($blog_class) ?>">

                    <?php get_template_part( 'loop', 'search' );?>
                        
                    </section>

                    <?php
                        the_posts_pagination( array(
                            'prev_text'          => wp_kses_post(__( '<i class="icon-arrow-left"></i>', 'cutstyle' )),
                            'next_text'          => wp_kses_post(__( '<i class="icon-arrow-right"></i>', 'cutstyle' )),
                            'screen_reader_text' => esc_html__( '&nbsp;', 'cutstyle'),
                        ) );
                    ?>

			    <?php else : ?>
			        <div id="post-0" class="blog-article post no-results not-found">
			            <h2><?php esc_html_e( 'Nothing Found', 'cutstyle' ); ?></h2>
			            <div class="entry-content">
			                <p><?php esc_html_e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'cutstyle' ); ?></p>
			             </div><!-- .entry-content -->
			        </div><!-- #post-0 -->
			    <?php endif; ?>

                </div>

                <?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>

            </div>
        </div>
    </section>
<?php get_footer(); ?>
			
            
            