<?php 
/*** The taxonomy for portfolio category. ***/
get_header(); 

 	$pixtheme_pix_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
	$services_page = pixtheme_get_option('services_settings_page', '');
	$all_services = '';
	if ( '' != $services_page ) {
		$all_services = get_the_permalink($services_page);
	}
	
?>
<section class="page-content taxonomy-page">
	<div class="container">
		<div class="services">
		    <div class="row">
				<div class="col-lg-4 col-md-12">
					<div class="side-menu">
						<div class="row">
                            <div class="col-lg-12 col-md-6">
                                <div class="side-menu__item">
                                    <h3><?php esc_html_e('Departments', 'cutstyle') ?></h3>
                                    <div class="side-menu__item-categories">
                                        <ul>
                                            <li><a href="<?php echo esc_url($all_services) ?>"><?php esc_html_e('All services', 'cutstyle') ?></a></li>
                                            <?php $args = array( 'taxonomy' => 'services_category', 'hide_empty' => '1', 'title_li'=> '', 'show_count' => '0', 'current_category' => $pixtheme_pix_term->term_id);
                                            $categories = wp_list_categories ($args);
                                            ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>

						</div>
					</div>
				</div>
				<div class="col-sm-8">
					<div class="row services">
				
<!--				
<div class="container-fluid inner-offset">    
	<div class="row services">
-->		
	<?php
		$pixtheme_pix_services = get_objects_in_term( $pixtheme_pix_term->term_id, 'services_category');
		$args = array(
					'post_type' => 'services', 
					'orderby' => 'menu_order',
					'post__in' => $pixtheme_pix_services,
					'order' => 'ASC'
				);
			
		$wp_query = new WP_Query( $args );
										
		if ($wp_query->have_posts()):
			while ($wp_query->have_posts()) :
				$wp_query->the_post();
				$pixtheme_pix_thumbnail = get_the_post_thumbnail($post->ID, 'pixtheme-services-thumb', array('class' => "full-width"));
	?>
                        <div class="col-md-6">
                            <div class="service-box-5">
                                <a href="<?php echo esc_url(get_permalink(get_the_ID())) ?>">
                                    <div class="pix-img-wrapper"><?php echo wp_kses_post($pixtheme_pix_thumbnail) ?></div>
                                </a>
                                <div class="service-box-5__text">
                                    <h2><a href="<?php echo esc_url(get_permalink(get_the_ID())) ?>"><?php echo wp_kses_post(get_the_title()) ?></a></h2>
                                    <p><?php echo pixtheme_limit_words(get_the_excerpt(), 20) ?></p>
                                </div>
                                <span><a href="<?php echo esc_url(get_permalink(get_the_ID())) ?>"></a></span>
                            </div>
                        </div>
    <?php
			endwhile;
		endif;
	?>
      

					</div>
				</div>
			</div>
	    </div>
	</div>
</section>

<?php get_footer() ?>