<?php /* Header Background Image tamplate */ ?>

<?php
	$title_class = $breadcrumbs_class = $term = '';

	$bg_image = pixtheme_get_option('tab_bg_image', '') ? pixtheme_get_option('tab_bg_image', '') : get_template_directory_uri().'/images/page-img.jpg';
	$tab_tone = pixtheme_get_option('tab_tone', '') == '' ? 'text-white-color' : pixtheme_get_option('tab_tone', '');
	$title_position = pixtheme_get_option('tab_title_position', '');
	$breadcrumbs_position = pixtheme_get_option('tab_breadcrumbs_position', '');
	if( $title_position != $breadcrumbs_position ){
		$title_class = $title_position != '' ? 'pull-'.$title_position : '';
		$breadcrumbs_class = $breadcrumbs_position != '' ? 'pull-'.$breadcrumbs_position : '';
	} elseif($title_position != '') {
		$title_class = $breadcrumbs_class = 'text-'.$title_position;
	}
?>
<!-- ========================== -->
<!-- Top header -->
<!-- ========================== -->
<section class="header-section" style="background-image:url(
	<?php if ( class_exists( 'WooCommerce' ) && is_shop() ) :
	        $thumbnail_id = get_post_thumbnail_id(wc_get_page_id('shop'));
			$image = wp_get_attachment_url( $thumbnail_id );
			$image = $image == '' ? $bg_image : $image;
		?>
	<?php echo esc_url($image) ?>);" >
	<?php
	    elseif ( class_exists( 'WooCommerce' ) && is_product_category() ) :
			$cat = $wp_query->get_queried_object();
	        $thumbnail_id = get_woocommerce_term_meta( $cat->term_id, 'thumbnail_id', true );
			$image = wp_get_attachment_url( $thumbnail_id );
			$image = $image == '' ? $bg_image : $image;
		?>
	<?php echo esc_url($image) ?>);" >
	<?php
	    elseif ( class_exists( 'WooCommerce' ) && is_product() && !empty($post->ID)) :
			$terms = get_the_terms( $post->ID, 'product_cat' );
			$image = '';
			if($terms)
			foreach ($terms as $term) {
				$thumbnail_id = get_woocommerce_term_meta( $term->term_id, 'thumbnail_id', true );
				$image = wp_get_attachment_url( $thumbnail_id );
				if($image != '')
					break;
			}
			$image = $image == '' ? $bg_image : $image;
			echo esc_url($image) ?>
	);" >
	<?php
	    elseif ( is_home() || is_archive() || is_page_template('blog-template.php') ) :
			$term = isset ($wp_query) ? $wp_query->get_queried_object() : '';
			$image = '';
			if(isset($term->taxonomy) && $term->taxonomy == 'category') {
				$post_thumbnail_id = get_post_thumbnail_id($term->term_id);
				$image = wp_get_attachment_url( $post_thumbnail_id );
			}
			elseif(isset($term->term_id)){
				$image = get_option("pixtheme_tax_thumb".$term->term_id);
			}
			$image = $image == '' ? $bg_image : $image;
			echo esc_url($image) ?>
	);" >
	<?php
		elseif ( is_single() && get_post_type($post->ID) == 'post' ) :
			$categories = get_the_category($post->ID);
			$image = '';
			if($categories){
				foreach($categories as $category) {
					$image = get_option('pixtheme_tax_thumb' . $category->term_id);
					if($image != '')
						break;
				}
			}
			$image = $image == '' ? $bg_image : $image;
			echo esc_url($image) ?>
	);" >
	<?php
		elseif( get_post_type() != 'portfolio' && get_post_type() != 'services') :
			if( has_post_thumbnail() ):
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );?>
	<?php 		echo esc_url($post_thumbnail_url) ?>
	);" >
	<?php 	else:?>
	<?php 		echo esc_url($bg_image); ?>);" >
	<?php 	endif;
	    else:
	        echo esc_url($bg_image); ?>);" >

	<?php endif; ?>
	<span class="vc_row-overlay"></span>
	<div class="container">
	    <div class="row">
	        <div class="col-md-12">
		        <div class="page-title-box <?php echo esc_attr($tab_tone) ?>">
		            <?php if( pixtheme_get_option('tab_title_position', '') != 'hide' ) : ?>
		            <div class="ui-title-page <?php echo esc_attr($title_class) ?>">
		                <h1>
						<?php
						    $pixtheme_postpage_id = get_option('page_for_posts');
							$pixtheme_frontpage_id = get_option('page_on_front');
							$pixtheme_page_id = isset ($wp_query) ? $wp_query->get_queried_object_id() : '';
						
							if(is_single() && ! is_attachment()) {
                                echo wp_kses_post(get_the_title());
                            } elseif( class_exists( 'WooCommerce' ) && (is_shop() || is_product_category() || is_product_tag()) ) {
                                wp_kses_post(woocommerce_page_title());
                            } elseif( is_author() ) {
                                echo wp_kses_post(get_the_author());
                            } elseif( is_archive() && get_post_type() != 'post') {
							    if( !isset($term->label) )
							        echo wp_kses_post($term->name);
							    else
                                    echo wp_kses_post($term->label);
                            } elseif( is_404() ) {
                                echo wp_kses_post(esc_html_e('404', 'cutstyle'));
                            }elseif( $pixtheme_page_id == $pixtheme_frontpage_id ) {
                                echo wp_kses_post(esc_html_e('Posts', 'cutstyle'));
                            } elseif( is_home() ) {
                                echo wp_kses_post(get_the_title($pixtheme_postpage_id));
                            } elseif( is_page_template( 'blog-template.php' ) ) {
                                echo wp_kses_post(get_the_title($pixtheme_page_id));
                            } elseif( is_search() ) {
                                echo wp_kses_post(get_search_query());
                            } elseif( is_category() ) {
                                echo wp_kses_post(single_cat_title());
                            } elseif( is_tag() ) {
                                echo wp_kses_post(single_tag_title());
                            } elseif( $pixtheme_page_id > 0 ) {
                                echo wp_kses_post(get_the_title($pixtheme_page_id));
                            } else {
                                echo wp_kses_post(get_the_title());
                            }
                        ?>
				        </h1>
                        <div class="sep-element"></div>
					    <?php if( class_exists( 'RW_Meta_Box' ) && rwmb_meta( 'add_title_text' ) != '' && !is_home() ) : ?>
				            <span class="subtitle"><?php echo wp_kses_post(rwmb_meta( 'add_title_text' ))?></span>
				        <?php endif; ?>
				    </div>
				    <?php endif ?>

				    <?php if( pixtheme_get_option('tab_breadcrumbs_position', '') != 'hide' ) : ?>
		            <div class="breadcrumbs <?php echo esc_attr($breadcrumbs_class) ?>">
		                <?php pixtheme_show_breadcrumbs()?>
		            </div>
		            <?php endif ?>
	            </div>
	        </div>
	    </div>
	</div>

</section><!--./top header -->
