<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $style
 * @var $cat_port
 * @var $perrow
 * @var $count
 * @var $type
 * @var $btnshow
 * @var $btntext
 * @var $css_animation
 * @var $tab_id
 * Shortcode class
 * @var $this WPBakeryShortCode_Section_Portfolio
 */
$shadows_arr = array();
$style = $cat_port = $count = $filter = $btnshow = $btntext = $css_animation = $animate = $animate_data = $tab_id = $greyscale = $radius = '';
$out = $cnt = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$shadows_arr = pixtheme_vc_get_params_array($atts, 'shadow');
extract( $atts );

global $post;


if ( $cat_port == '' ) :
	$out .= '<p>'.esc_html__('No categories selected. To fix this, please login to your WP Admin area and set the categories you want to show by editing this shortcode and setting one or more categories in the multi checkbox field "Categories".', 'cutstyle');

else:

    $style = $style != '' ? $style : 'grid-portfolio';
    $shadow_class = pixtheme_get_shadow($shadows_arr);
    $greyscale = ($greyscale == 'off') ? '' : 'pix-img-greyscale';

	$out .= '<section id="portfolio-'.esc_attr($tab_id).'" class="portfolio '.esc_attr($radius).' '.esc_attr($greyscale).'">';

	if ( $content != '' ) :
		$out .= '
			<div class="section-heading text-center">
				<div class="section-subtitle">'.wp_kses_post(do_shortcode($content)).'</div>
				<div class="design-arrow"></div>
			</div>
		';
	endif;

	$port_categories = explode( ",", $cat_port );

	if ( get_query_var('paged') ) {
		$paged = get_query_var('paged');
	} elseif ( get_query_var('page') ) {
		$paged = get_query_var('page');
	} else {
		$paged = 1;
	}

	$args = array(
				'post_type' => 'portfolio',
				'orderby' => array( 'menu_order' => 'ASC', 'date' => 'DESC' ),
				'tax_query' => array(
					array(
						'taxonomy' => 'portfolio_category',
						'field'    => 'slug',
						'terms'    => $port_categories
					)
				),
				'paged' => $paged
			);

	if ( is_numeric( $count ) && $count > 0 ) {
		$args['posts_per_page'] = $count;
	}
	else {
		$args['posts_per_page'] = -1;
	}

	$wp_query = new WP_Query( $args );

	if ( in_array($style, array('grid-cat', 'grid-portfolio')) && $filter != 'off' ) :
        if( $style == 'grid-cat' ) {

            $out .= '
				<section>
                    <div class="filter">
                        <div class="container">
                            <span>'. esc_html__('Specialties', 'cutstyle').'</span>
                            <div class="filter__select">
                                <ul>
            ';

                $categories = get_categories(array('type' => 'post', 'taxonomy' => 'portfolio_category', 'include' => $cat_port));

                $out .= '
                                <li data-filter="*" class="active">' . esc_html__("All", "cutstyle") . '</li>
            ';
                foreach ($categories as $category) {
                    $group = $category->slug;
                    $out .= '
                                    <li data-filter=".' . $group . '">' . $category->cat_name . '</li>
                                    ';
                }

                $out .= '        
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </section>
                    <div class="container-fluid portfolio__container">
            ';
        } else {
            $out .= '
				<div class="col-md-12">
					<div class="filter-button-group" >           
            ';

            $categories = get_categories(array('type' => 'post', 'taxonomy' => 'portfolio_category', 'include' => $cat_port));

            $out .= '
                        <a data-filter="*" class="active">'.esc_html__("All", "cutstyle").'</a>
            ';
            foreach ($categories as $category) {
                $group = $category->slug;
                $out .= '
                        <a data-filter=".'.esc_attr($group).'">'.wp_kses_post( $category->cat_name ).'</a>
                ';
            }

            $out .= '        
                    </div>
                </div>
                <div class="container-fluid portfolio__container">
            ';
        }
	endif;

	if ( $wp_query->have_posts() ) {
        $out .=  in_array($style, array('grid-cat', 'grid-portfolio')) ? '<div class="'.esc_attr($style).'"><div class="'.esc_attr($style).'__sizer"></div>' : '<div class="'.esc_attr($style).' owl-carousel owl-theme">';

		$i = $offset = 0;
		while ( $wp_query->have_posts() ) :
			$wp_query->the_post();
			$i++;

			$cats = wp_get_object_terms($post->ID, 'portfolio_category');
			$cat_slugs = '';
			if ( ! empty($cats) ) {
				foreach ( $cats as $cat ) {
					$cat_slugs .= $cat->slug . " ";
				}
			}
			$thumbnail = '<div class="pix-img-wrapper">'.get_the_post_thumbnail($post->ID, 'pixtheme-portfolio-thumb', array('class' => 'img-responsive')).'</div>';
			$thumbnail_full = get_the_post_thumbnail_url($post->ID, 'full');

			// potfolio category list linked
			$portfolio_link_term = pixtheme_get_post_terms( array( 'taxonomy' => 'portfolio_category', 'items_wrap' => '%s' ) );

			if($css_animation != '') {
				//$animate = 'class="';
				$animate = 'animated';
				$animate .= !empty($wow_duration) || !empty($wow_delay) || !empty($wow_offset) || !empty($wow_iteration) ? ' wow ' . esc_attr($css_animation) : '';
				//$animate .= '"';
                $animate_data .= ' data-animation="'.esc_attr($css_animation).'"';
				$wow_group = !empty($wow_group) ? $wow_group : 1;
				$wow_group_delay = !empty($wow_group_delay) ? $wow_group_delay : 0;
                $animate_data .= !empty($wow_duration) ? ' data-wow-duration="'.esc_attr($wow_duration).'s"' : '';
                $animate_data .= !empty($wow_delay) ? ' data-wow-delay="'.esc_attr($wow_delay + $offset * $wow_group_delay).'s"' : '';
                $animate_data .= !empty($wow_offset) ? ' data-wow-offset="'.esc_attr($wow_offset).'"' : '';
                $animate_data .= !empty($wow_iteration) ? ' data-wow-iteration="'.esc_attr($wow_iteration).'"' : '';

				$offset = $i % $wow_group == 0 ? ++$offset : $offset;
			}
            if( $style == 'grid-cat' ){

            } elseif( $style == 'grid-portfolio' ){
            $out .= '
                <div class="grid-portfolio__item '.esc_attr($shadow_class).' '. esc_attr($cat_slugs) . ' '.esc_attr($animate).'" '.wp_kses_post($animate_data).'>
                    <div class="grid-portfolio__container">
                        <h3><a href="'.esc_url( get_the_permalink() ).'" class="link-centerline">'.wp_kses_post( get_the_title() ).'</a></h3>
                        <p>'.wp_kses_post( $portfolio_link_term ).'</p>
                    </div>
                    '.wp_kses_post($thumbnail).'
                </div>
			';
            } elseif ( $style == 'portfolio-cards' ){
                $out .= '
                <div class="portfolio-cards__item '.esc_attr($shadow_class).' '.wp_kses_post($animate).'" '.wp_kses_post($animate_data).'>
                    <a href="'.esc_url( get_the_permalink() ).'" >
                        <div class="portfolio-cards__item-image">
                            <div class="gradient"></div>
                            '.wp_kses_post($thumbnail).'
                        </div>
                    </a>
                    <div class="portfolio-cards__item-text">
                        <h3><a href="'.esc_url( get_the_permalink() ).'" >'.wp_kses_post( get_the_title() ).'</a></h3>
                        <span>'.wp_kses_post( $portfolio_link_term ).'</span>
                    </div>
                </div>
			';
            } elseif ( $style == 'cards-beyond' ){
                $out .= '
                <div class="cards-beyond__item '.esc_attr($shadow_class).' '.wp_kses_post($animate).'" '.wp_kses_post($animate_data).'>
                    <div class="cards-beyond__item-container">
                        <h3><a href="'.esc_url( get_the_permalink() ).'">'.wp_kses_post( get_the_title() ).'</a></h3>
                        <span>'.wp_kses_post( $portfolio_link_term ).'</span>
                    </div>
                    '.wp_kses_post($thumbnail).'
                </div>
			';
            } elseif ( $style == 'person' ) {
                $out .= '
                <div class="person__item '.esc_attr($shadow_class).' '.wp_kses_post($animate).'" '.wp_kses_post($animate_data).'>
                    <div class="person__item-container">
                        <a href="'.esc_url( get_the_permalink() ).'">
                            <div class="person__item-overlay"></div>
                            '.wp_kses_post($thumbnail).'
                        </a>
                    </div>
                    <h3><a href="'.esc_url( get_the_permalink() ).'" >'.wp_kses_post( get_the_title() ).'</a></h3>
                    <span>'.wp_kses_post( $portfolio_link_term ).'</span>
                </div>
			';
            }

		endwhile;

		$out .= '
		</div>
		';

		if ( get_next_posts_link( '', $wp_query->max_num_pages ) ) {
			if ( $btnshow == 'on' || $btnshow == "" ) {

				$out .= '
					<div class="row">
						<div class="col-md-12 text-center">
							<div class="portfolio-pagination">
								<span data-current="'.esc_attr($paged).'" data-max-pages="'.esc_attr($wp_query->max_num_pages).'" class="load-more">' . get_next_posts_link( wp_kses_post($btntext), $wp_query->max_num_pages) . '</span>
							</div>
							<div class="portfolio-pagination-loading">
								<a href="javascript: void(0)" class="btn btn-default">'. esc_html__("Loading...", "cutstyle") .'</a>
							</div>
						</div>
					</div>
				';
			}
		}

	}

    if ( in_array($style, array('grid-cat', 'grid-portfolio')) && $filter != 'off' ) {
        $out .= '</div>';
    }

    $out .= '</section>';
endif;

wp_reset_postdata();

if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}