<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $select_type
 * @var $portfolio_id
 * @var $port_category
 * @var $block_size
 * @var $bg_color
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Box_Portfolio
 */
$out = $temp_port_cat_id = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if($select_type == 'select_item') {
    $temp_port_cat_id = preg_split('/pixId/', $port_category);
    $portfolio = isset($temp_port_cat_id[1]) && isset(${"port_" . $temp_port_cat_id[1]}) ? ${"port_" . $temp_port_cat_id[1]} : '';
}
else
    $portfolio = $portfolio_id;

$blank = !empty($target) ? 'target="_blank"' : '';
$pix_class = array('' => 'y1', '15x' => 'y1', '2x' => 'y1', '2y' => 'y1_7', '15x2y' => 'y1', '2xy' => 'x2 y2');

if( $portfolio == '' ):
    $out .= '<p>'.esc_html__('No portfolio id selected. To fix this, please login to your WP Admin area and set the portfolio card you want to show by editing this shortcode and setting one portfolio card in the dropdown "Portfolio Single".', 'cutstyle');
else: 

$out = $css_animation != '' ? '<div class="animated" data-animation="' . esc_attr($css_animation) . '">' : '<div>';

    $args = array(
                'post_type' => 'portfolio',
                'p' => $portfolio,
            );

    $wp_query = new WP_Query( $args );

    if ($wp_query->have_posts()):
        while ($wp_query->have_posts()) :
                $wp_query->the_post();
                //$cnt++;
                //$custom = get_post_custom($post->ID);
                //$pixtheme_pix_format = $custom['post_types_select'][0];

                $cats = wp_get_object_terms($post->ID, 'portfolio_category');

                if ($cats){
                    $cat_slugs = '';
                    foreach( $cats as $cat ){
                        $cat_slugs .= $cat->slug . " ";
                    }
                }

                $position = $phone = $email = $facebook = $twitter = $googleplus = $linkedin = '';
                $thumbnail = get_the_post_thumbnail($post->ID, 'pixtheme-portfolio-'.$block_size, array('class'=> 'img-responsive') );
                $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );

$out .= '
            <div class="pix-item '.esc_attr($pix_class[$block_size]).'">
                <div class="hover-mask" data-background="'.esc_attr($bg_color).'">
                    <a href="'.esc_url($thumbnail_src[0]).'" class="zoom-img"><i class="icon-plus"></i></a>
                    <a '.$blank.' href="'.esc_url(get_permalink($post->ID)).'"><i class="icon-info"></i></a>
                </div>
                <a '.$blank.' href="'.esc_url(get_permalink($post->ID)).'">'.wp_kses_post($thumbnail).'</a>
            </div>
';

         endwhile;
    endif;

$out .= '</div>';
endif;	

if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}