<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $btn_text
 * @var $link
 * @var $skin
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Common_Posts_Block
 */
$carousel_arr = $shadows_arr = array();
$out = $out_news = $radius = $greyscale = $count = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$carousel_arr = pixtheme_vc_get_params_array($atts, 'carousel');
$shadows_arr = pixtheme_vc_get_params_array($atts, 'shadow');
extract( $atts );

$date = '';

$count = $count == '' ? '3' : $count;
$style = !isset($style) || $style == '' ? 'news-card-latest' : $style;
$greyscale = ($greyscale == 'off') ? '' : 'pix-img-greyscale';
$shadow_class = pixtheme_get_shadow($shadows_arr);

$args = array(
    'ignore_sticky_posts' => true,
    'showposts' => $count,
);
if($cats != '') {
    $cats = explode(",", $cats);

    $args = array(
        'ignore_sticky_posts' => true,
        'showposts' => $count,
        'post_type' => 'post',
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field' => 'slug',
                'terms' => $cats
            )
        ),
    );
}

$wp_query = new WP_Query( $args );
			 					
if ($wp_query->have_posts()):
    $i=0;
    $cnt = $wp_query->post_count;

    while ($wp_query->have_posts()) :
        $wp_query->the_post();
        $custom = get_post_custom(get_the_ID());
        $i++;
        if(pixtheme_get_option('blog_show_category', '1')){
            $categories = get_the_category(get_the_ID());
            if($categories){
                $cat = '';
                foreach($categories as $category) {
                    $cat .= '<a href="'.esc_url(get_category_link( $category->term_id )).'" >'.wp_kses_post($category->cat_name).'</a>, ';
                }
                $cat = $cat != '' ? substr($cat, 0, -2) : '';
            }
        }
        if(pixtheme_get_option('blog_show_date', '1')){
            $date = '<span><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_date()).'</a></span>';
        }

        $thumbnail = get_the_post_thumbnail( get_the_ID() ) != '' ? get_the_post_thumbnail( get_the_ID(), 'pixtheme-post-thumb' ) : '<img src="'.esc_url(get_template_directory_uri()).'/images/no_image.png">';

        if($style == 'news-card-latest'){
        $out_news .= '
            <div class="news-card '.esc_attr($shadow_class).'">
                <div class="news-card__image">
                    <div class="label-date">'.wp_kses_post($date).'</div>
                    '.wp_kses_post($thumbnail).'
                </div>
                <div class="news-card__text">
                    <h2><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a></h2>
                    <p>'.pixtheme_limit_words(get_the_excerpt(), 20).'</p>
                </div>
            </div>
        ';
        } else {
        $out_news .= '
            <div class="'.esc_attr($style).' '.esc_attr($shadow_class).'">';
            if($style == 'news-card-long') {
                $out_news .= '
                    <div class="news-card-long__image">
                        <a class="icon-zoom" href="'.esc_url(get_the_permalink()).'"></a>
                        <div class="overlay"></div>
                        '.wp_kses_post($thumbnail).'
                    </div>
                    <div class="news-card-long__text">
                        <h2><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a></h2>
                        <span class="news-date">'.wp_kses_post($date).'</span>
                        <p>'.pixtheme_limit_words(get_the_excerpt(), 20).'</p>
                    </div>
                ';
            } elseif($style == 'news-card-centered') {
                $out_news .= '
                    <div class="news-card-centered__image">
                        <span class="news-date">'.wp_kses_post($date).'</span>
                        <a href="'.esc_url(get_the_permalink()).'">'.pixtheme_limit_words(get_the_excerpt(), 20).'</a>
                        <div class="overlay"></div>
                        '.wp_kses_post($thumbnail).'
                    </div>
                    <div class="news-card-centered__text">
                        <h2><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a></h2>
                    </div>
                ';
            } else {
                $out_news .= '
                    <h2><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a></h2>
                    <div class="news-info clearfix">
                        <span class="news-info__category"><i class="icon-folder-alt"></i>'.wp_kses_post($cat).'</span>
                        <span class="news-info__date"><i class="icon-calendar"></i>'.wp_kses_post($date).'</span>
                    </div>
                    '.wp_kses_post($thumbnail).'
                    <div class="gradient-bg"></div>
                ';
            }
        $out_news .= '            
            </div>
            ';
        }



    endwhile;

endif;

wp_reset_query();

$options_arr = pixtheme_get_carousel($carousel_arr, 'animate_'.str_replace('-', '_', $style));
$data_carousel = empty($options_arr) ? '' : 'data-owl-options=\''.json_encode($options_arr).'\'';
$carousel_class = !empty($options_arr) ? 'row owl-carousel owl-theme' : 'disable-owl-carousel pix-col-'.esc_attr($count);
$animation_class = !empty($options_arr) && !isset($options_arr['onTranslate']) ? 'animation-off' : '';


if($style == 'news-card-latest'){
    $href = vc_build_link( $link );
    $href = isset($href['url']) && !empty($href['url']) ? $href['url'] : '#';

    $out = '
    <div class="row news-latest '.esc_attr($radius).' '.esc_attr($greyscale).'">
        <div class="col-md-4">
            <div class="news-card-latest '.esc_attr($shadow_class).'">
                <h2>'.wp_kses_post($title).'</h2>
                <div class="sep-element"></div>
                <div class="news-card-latest__item">
                    <a class="link-centerline" href="'.esc_url($href).'">'.wp_kses_post($btntxt).'</a>
                    '.wp_kses_post(do_shortcode($content)).'
                    <div id="news-card-latest-nav"></div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="news-card-latest__container owl-carousel owl-theme">
            '.wp_kses_post($out_news).'
            </div>
        </div>
    </div>
    ';
} else {
    $out = '
    <div class="'.esc_attr($style).'__carousel '.esc_attr($carousel_class).' '.esc_attr($radius).' '.esc_attr($greyscale).'" '.wp_kses_post($data_carousel).'>
        '.wp_kses_post($out_news).'
    </div>
    ';
}
	
if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}