<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $title_before
 * @var $show_decor
 * @var $color
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Block_Title
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );

$title = ($title == '') ? '' : '<h2 class="section-title">'.wp_kses_post($title).'</h2>';
$subtitle = ($subtitle == '') ? '' : '<div class="section-subtitle">'.wp_kses_post($subtitle).'</div>';
$show_decor = ($show_decor == 'off') ? '' : '<div class="sep-element"></div>';

$out = '
	<div class="section-heading ' . esc_attr($css_class) . ' ' . esc_attr($position) . ' ' . esc_attr($color) . '">
		'.wp_kses_post($title).'
		'.wp_kses_post($show_decor).'
		'.wp_kses_post($subtitle).'
	</div>
'.$this->endBlockComment('common_title');

if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}