<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $undertitle
 * @var $duration
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Common_Video
 */
$out = $title = $color = $video_opacity = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$height = $height == '' ? '500px' : $height;
$video_opacity = $video_opacity == '100%' ? '1' : '0.'.(int)$video_opacity;
$title = ( $title == '' ) ? '' : '<div class="title">'.wp_kses_post($title).'</div>';
$fullcontent = ($content == '') ? '' : '<div class="duration">'.do_shortcode($content).'</div>';

$pix_video_class = 'pix_video_' . rand();
$pix_video_style = 'jQuery("head").append("<style> .'.esc_attr($pix_video_class).'{display:table-row;height:'.esc_attr($height).'}.'.esc_attr($pix_video_class).' .pix-video{background-color:rgba('.esc_attr(pixtheme_hex2rgb($color)).','.esc_attr($video_opacity).')}</style>");';
wp_add_inline_script( 'pixtheme-common', $pix_video_style );


$out .= '
     <div class="'.esc_attr($pix_video_class).'">
        <div class="pix-video">
            '.wp_kses_post($title).'
            <a class="pix-video-popup" href="'.esc_url($url).'" >
                <img class="play" src="'.get_template_directory_uri().'/images/play.svg" alt="'.esc_attr($title).'">
                <div class="item-pulse"></div>
            </a>
            '.wp_kses_post($fullcontent).'
        </div>
    </div>    
';

if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}