<?php
/* Woocommerce template. */
$pixtheme_id = pixtheme_woo_get_page_id();
$pixtheme_isProduct = false;

if ( is_single() && get_post_type() == 'product' ) {
	$pixtheme_isProduct = true;
}

$pixtheme_custom = $pixtheme_id > 0 ? get_post_custom($pixtheme_id) : array();
$pixtheme_layout = isset ($pixtheme_custom['pix_page_layout']) ? reset($pixtheme_custom['pix_page_layout']) : '2';
$pixtheme_sidebar = isset ($pixtheme_custom['pix_selected_sidebar'][0]) ? reset($pixtheme_custom['pix_selected_sidebar']) : 'sidebar-1';

if ( $pixtheme_isProduct === true ) {
	$pixtheme_useSettingsGlobal = pixtheme_get_option( 'shop_settings_global_product', 'on' );
	if ( $pixtheme_useSettingsGlobal == 'on' ) {
		$pixtheme_layout = pixtheme_get_option( 'shop_settings_sidebar_type', '2');
		$pixtheme_sidebar = pixtheme_get_option( 'shop_settings_sidebar_content', 'product-sidebar-1' );
	}
}

if ( ! is_active_sidebar($pixtheme_sidebar) ) $pixtheme_layout = '1';

get_header(); ?>


<section class="blog" >
    <div class="container">
		<div class="row">

            <?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>

            <div class="rtd <?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12<?php else : ?>col-lg-8<?php endif; ?> col-md-12 col-sm-12 col-xs-12 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?>">

                <?php  woocommerce_content(); ?>

            </div>

            <?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>

		</div>
	</div>
</section>

<?php get_footer();?>
