<?php

// prevent direct file access
if( ! defined( 'ABSPATH' ) ) {
    header( 'Status: 403 Forbidden' );
    header( 'HTTP/1.1 403 Forbidden' );
    exit;
}



class PixCustom_PixSection_Widget extends WP_Widget {


    function __construct() {

        parent::__construct(
            'PixCustom_PixSection_Widget',
            __( 'PixCustom Section Widget', 'pixcustom' ),
            array(
                'description' => __( 'Displays your PixSection in widget', 'pixcustom' ),
            )
        );
    }

    public function widget( $args, $instance ) {

        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $blockId = isset( $instance['block_id'] ) ? $instance['block_id'] : 0;
        $title = apply_filters( 'widget_title', $title );

        echo $args['before_widget'];

        $html = '<div class="product-sidebar-block sidebar-product">';

        $html .= pixtheme_get_section_content($blockId);

        $html .= '</div>';

        echo $html;

        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : 'Pix Section';
        $blockId = isset( $instance['block_id'] ) ? $instance['block_id'] : '';
        $blocks = $this->get_all_sections();


        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'pixcustom' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'block_id' ); ?>"><?php _e( 'Pix Section:', 'pixcustom' ); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'block_id' ); ?>" name="<?php echo $this->get_field_name( 'block_id' ); ?>">
                <?php foreach ($blocks as $block):?>
                    <option <?php if ($blockId == $block->ID):?>selected="selected"<?php endif;?> value=<?php echo $block->ID?>""><?php echo $block->post_title?></option>
                <?php endforeach?>
            </select>
        </p>



        <?php
    }


    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['block_id'] = ( ! empty( $new_instance['block_id'] ) ) ? sanitize_text_field( $new_instance['block_id'] ) : '';
        return $instance;
    }

    private function get_all_sections(){
        $args = array(
            'post_type'        => 'pixsections',
            'post_status'      => 'publish',
        );

        $blocks = get_posts($args);

        return $blocks;
    }

}


class PixCustom_Services_Widget extends WP_Widget {

	// Widget setup.
	function __construct() {

		// Widget settings.
		$widget_ops = array(
			'classname' => 'widget_services_category',
			'description' => esc_html__('Display Services Categories', 'pixcustom')
		);

		// Create the widget.
		parent::__construct('pixtheme-services-widget', esc_html__('Services Categories', 'pixcustom') , $widget_ops);
	}

	// Display the widget on the screen.
	function widget($args, $instance) {
		global $post;
		extract($args);
		$title = apply_filters('widget_title', $instance['serv_title']);
		$terms = wp_get_post_terms( $post->ID, 'services_category' );
		$services_page = pixtheme_get_option('services_settings_page', '');
		$all_services = '';
		if ( '' != $services_page ) {
			$all_services = get_the_permalink($services_page);
		}

		echo wp_kses_post($before_widget);
		if ($title) echo wp_kses_post($before_title . $title . $after_title);

		$args = array( 'taxonomy' => 'services_category', 'hide_empty' => '0');
		$categories = get_categories($args);
		echo '<div class="side-menu__item-categories"><ul>
				<li><a href="'. esc_url($all_services) .'">'. esc_html__('All services', 'pixcustom') .'</a></li>';

		foreach($categories as $category){

			$class = isset($terms[0]->term_id) && ($terms[0]->term_id == $category->term_id) ? 'class="active"' : '';
			?>
			<li <?php echo wp_kses_post($class)?>><a href="<?php echo esc_url(get_category_link( $category->term_id )); ?>"><?php echo wp_kses_post($category->name); ?></a></li>
            <?php
		}
		echo '</ul></div>';
		echo wp_kses_post($after_widget);
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['serv_title'] = strip_tags($new_instance['serv_title']);
		return $instance;
	}

	function form($instance) {
		$defaults = array(
			'serv_title' => esc_html__('Services Categories', 'pixcustom'),
		);
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('serv_title')); ?>"><?php esc_html_e('Title', 'pixcustom'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('serv_title')); ?>" type="text" name="<?php echo esc_attr($this->get_field_name('serv_title')); ?>" value="<?php echo esc_attr($instance['serv_title']); ?>" class="widefat" />
		</p>

	<?php
	}
}

class PixCustom_Latest_News extends WP_Widget {

	// Widget setup.
	function __construct() {
		// Create the widget.
		parent::__construct('pixtheme_latest_news', esc_html__('Latest News', 'pixcustom') , array( 'description' => esc_html__('Display Latest News', 'pixcustom'), ));
	}

	// Display the widget on the screen.
	function widget($args, $instance) {
		global $post;
		extract($args);
		$title = apply_filters('widget_title', $instance['news_title']);
		$count = isset( $instance['news_count'] ) ? $instance['news_count'] : '2';
		$all_title = isset( $instance['news_all_title'] ) ? $instance['news_all_title'] : '';
		$all_page = isset( $instance['news_page'] ) ? $instance['news_page'] : '';

		$args_posts = array(
            'ignore_sticky_posts' => true,
            'showposts' => $count,
        );

        $wp_query = new WP_Query( $args_posts );
        if ($wp_query->have_posts()):

            echo wp_kses_post($before_widget);
		    if ($title) echo wp_kses_post($before_title . $title . $after_title);

            $date = '';
            while ($wp_query->have_posts()) :
                $wp_query->the_post();
                if( pixtheme_get_option('blog_show_date', '1') ){
                    $date = '<span class="time"><a href="'.esc_url(get_the_permalink()).'"><time>'.wp_kses_post(get_the_date()).'</time></a></span>';
                }
                $thumbnail = get_the_post_thumbnail( get_the_ID() ) != '' ? get_the_post_thumbnail( get_the_ID(), 'pixtheme-thumb' ) : '';
                //'<a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post($thumbnail).'</a>';
                echo '
                <div class="side-menu__item-news">
                    <div class="news-image">
                        '.wp_kses_post($date).'
                    </div>
                    <div class="news-text">
                        <a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a>
                    </div>
                </div>
                ';

            endwhile;

            if($all_title){
                echo '<a class="side-menu__item-all_news" href="'.esc_url($all_page).'">'.wp_kses_post($all_title).'</a>';
            }

            echo wp_kses_post($after_widget);

        endif;

        wp_reset_query();

	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['news_title'] = strip_tags($new_instance['news_title']);
		$instance['news_count'] = strip_tags($new_instance['news_count']);
		$instance['news_all_title'] = strip_tags($new_instance['news_all_title']);
		$instance['news_page'] = strip_tags($new_instance['news_page']);
		return $instance;
	}

	function form($instance) {
	    $guid = '';
	    $blog_page  = get_page_by_title( 'Blog' );
	    if($blog_page)
	        $guid = $blog_page->guid;
		$defaults = array(
			'news_title' => esc_html__('Latest News', 'pixcustom'),
            'news_count' => '2',
            'news_all_title' => esc_html__('all', 'pixcustom'),
            'news_page' => esc_url($guid),
		);
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('news_title')); ?>"><?php esc_html_e('Title', 'pixcustom'); ?></label>
            <input id="<?php echo esc_attr($this->get_field_id('news_title')); ?>" type="text" name="<?php echo esc_attr($this->get_field_name('news_title')); ?>" value="<?php echo esc_attr($instance['news_title']); ?>" class="widefat" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('news_count')); ?>"><?php esc_html_e('Count', 'pixcustom'); ?></label>
            <input id="<?php echo esc_attr($this->get_field_id('news_count')); ?>" type="text" name="<?php echo esc_attr($this->get_field_name('news_count')); ?>" value="<?php echo esc_attr($instance['news_count']); ?>" class="widefat" />
        </p>
        <p>
			<label for="<?php echo esc_attr($this->get_field_id('news_all_title')); ?>"><?php esc_html_e('All Button Title', 'pixcustom'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('news_all_title')); ?>" type="text" name="<?php echo esc_attr($this->get_field_name('news_all_title')); ?>" value="<?php echo esc_attr($instance['news_all_title']); ?>" class="widefat" />
		</p>
        <p>
			<label for="<?php echo esc_attr($this->get_field_id('news_page')); ?>"><?php esc_html_e('All Button Url', 'pixcustom'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('news_page')); ?>" type="text" name="<?php echo esc_attr($this->get_field_name('news_page')); ?>" value="<?php echo esc_url($instance['news_page']); ?>" class="widefat" />
		</p>

	<?php
	}
}