<?php
/***********************************

	Plugin Name:  PixCustom
	Plugin URI:   https://help.pix-theme.studio
	Description:  Additional functionality for PixTheme template
	Version:      1.1.0
	Author:       PixTheme
	Author URI:   https://true-emotions.studio
	Text Domain:  pixcustom
	Domain Path:  /languages/
	
***********************************/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // disable direct access
}

/** Register widget for brands */

require_once('pixtheme-font-icons-loader.php');
require_once('pixtheme-custom-widgets.php');
require_once('shortcode.php');
require_once('classes/class.ajax.php');

function register_pixcustom_widget() {
	register_widget('PixCustom_Services_Widget');
	register_widget('PixCustom_Latest_News');
	if (class_exists('YITH_WCBR')){
		register_widget( 'PixCustom_PixSection_Widget' );
	}
}
add_action( 'widgets_init', 'register_pixcustom_widget' );


if ( ! class_exists( 'PixCustom' ) ) :

/************* Custom Post Types ***************/

	class PixCustom {
        
        public function __construct() {
            
            add_action( 'init', array( $this, 'pixtheme_init' ) );
            //add_action( 'admin_init', array( $this, 'pixtheme_permalinks' ));
            add_action( 'customize_save_after', array($this, 'pix_generate_dynamic_style') );
            
            add_action('wp_enqueue_scripts', array($this, 'pix_enqueue_dynamic_style'));
            
        }
        
        public function pix_generate_dynamic_style(){
            if(!is_main_site() && file_exists(get_template_directory() . '/pixtheme/functions/dynamic-styles.php')){
                global $blog_id;
                $current_blog_details = get_blog_details( array( 'blog_id' => $blog_id ) );
                $blogname = isset($current_blog_details->path) ? str_replace('/', '', $current_blog_details->path) : '';
                if(file_exists(get_template_directory() . '/css/'.esc_attr($blogname).'/dynamic-style.css')){
                    ob_start();
                    include(get_template_directory() . '/pixtheme/functions/dynamic-styles.php');
                    $style = ob_get_contents();
                    ob_end_clean();
    
                    $file = get_template_directory() . '/css/'.esc_attr($blogname).'/dynamic-style.css';
                    if($open = fopen( $file, "w+" )) {
                        $write = fputs($open, $style);
                        fclose($open);
                    }
                }
            } elseif ( file_exists(get_template_directory() . '/pixtheme/functions/dynamic-styles.php') && file_exists(get_template_directory() . '/css/dynamic-style.css') ) {
                ob_start();
                include(get_template_directory() . '/pixtheme/functions/dynamic-styles.php');
                $style = ob_get_contents();
                ob_end_clean();
                
                $file = get_template_directory() . '/css/dynamic-style.css';
                if($open = fopen( $file, "w+" )) {
                    $write = fputs($open, $style);
                    fclose($open);
                }
            }
        }
        
        public function pix_enqueue_dynamic_style(){
            if(function_exists('pixtheme_get_option') && pixtheme_get_option('dynamic_style', '0') == '1') {
                if(!is_main_site()){
                    global $blog_id;
                    $current_blog_details = get_blog_details( array( 'blog_id' => $blog_id ) );
                    $blogname = isset($current_blog_details->path) ? str_replace('/', '', $current_blog_details->path) : '';
                    if(file_exists(get_template_directory() . '/css/'.esc_attr($blogname).'/dynamic-style.css')){
                        remove_action('wp_ajax_dynamic_styles', 'pixtheme_dynamic_styles');
                        remove_action('wp_ajax_nopriv_dynamic_styles', 'pixtheme_dynamic_styles');
                        wp_deregister_style('pixtheme-dynamic-styles');
                        wp_enqueue_style('pixtheme-dynamic-styles', get_template_directory_uri() . '/css/'.esc_attr($blogname).'/dynamic-style.css');
                    }
                } elseif ( file_exists(get_template_directory() . '/css/dynamic-style.css') ) {
                    remove_action('wp_ajax_dynamic_styles', 'pixtheme_dynamic_styles');
                    remove_action('wp_ajax_nopriv_dynamic_styles', 'pixtheme_dynamic_styles');
                    wp_deregister_style('pixtheme-dynamic-styles');
                    wp_enqueue_style('pixtheme-dynamic-styles', get_template_directory_uri() . '/css/dynamic-style.css');
                }
            }
        }
		
		static function pixtheme_init(){

		    if(function_exists('pixtheme_get_option')) {
		        $team_slug = pixtheme_get_option('team_slug', 'team') == '' ? 'team' : pixtheme_get_option('team_slug', 'team');
                $team_label = pixtheme_get_option('team_label', 'Team') == '' ? 'Team' : pixtheme_get_option('team_slug', 'Team');
                $team_cat_slug = pixtheme_get_option('team_cat_slug', 'specialty') == '' ? 'specialty' : pixtheme_get_option('team_cat_slug', 'specialty');
                $team_cat_label = pixtheme_get_option('team_cat_label', 'Specialties') == '' ? 'Specialties' : pixtheme_get_option('team_cat_label', 'Specialties');
                $portfolio_slug = pixtheme_get_option('portfolio_slug', 'portfolio') == '' ? 'portfolio' : pixtheme_get_option('portfolio_slug', 'portfolio');
                $portfolio_label = pixtheme_get_option('portfolio_label', 'Portfolio') == '' ? 'Portfolio' : pixtheme_get_option('portfolio_slug', 'Portfolio');
                $portfolio_cat_slug = pixtheme_get_option('portfolio_cat_slug', 'specialty') == '' ? 'portfolio_category' : pixtheme_get_option('portfolio_cat_slug', 'portfolio_category');
                $portfolio_cat_label = pixtheme_get_option('portfolio_cat_label', 'Category') == '' ? 'Category' : pixtheme_get_option('portfolio_cat_label', 'Category');
            } else {
		        $team_slug = 'team';
                $team_label = 'Team';
                $team_cat_slug = 'specialty';
                $team_cat_label = 'Specialties';
		        $portfolio_slug = 'portfolio';
                $portfolio_label = 'Portfolio';
                $portfolio_cat_slug = 'portfolio_category';
                $portfolio_cat_label = 'Category';
            }



            register_post_type( 'pixteam',
								array(
									'label' => $team_label,
									'singular_label' => $team_label,
									'exclude_from_search' => false,
									'publicly_queryable' => true,
									'menu_position' => null,
									'show_ui' => true,
									'public'  =>   true,
									'show_in_menu'  =>   true,
									'menu_icon'     =>   'dashicons-welcome-learn-more',
									'query_var' => true,
									'rewrite' => array('slug' => $team_slug),
									'capability_type' => 'page',
									'has_archive'  => true,
									'hierarchical' => false,
									'edit_item' => __( 'Edit', 'pixcustom'),
									'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'page-attributes', 'comments')
								)
							);

			register_taxonomy( 'pixspecialty',
								'pixteam',
								array( 'hierarchical' => true,
										'label' => $team_cat_label,
										'singular_label' => $team_cat_label,
										'public' => true,
		                                'show_tagcloud' => false,
										'query_var' => true,
					                    'rewrite' => array('slug' => $team_cat_slug , 'with_front' => false)
								)
							);

			add_filter('manage_edit-portfolio_columns', 'pixtheme_pixteam_edit_columns');
			add_action('manage_posts_custom_column',  'pixtheme_pixteam_custom_columns');

			function pixtheme_pixteam_edit_columns($columns){
				$columns = array(
					'cb' => '<input type="checkbox" />',
					'title' => __('Title', 'pixcustom'),
					'team_image' => __('Featured Image', 'pixcustom'),
					'id' => __('ID', 'pixcustom'),
					'team_category' => __('Category', 'pixcustom'),
					'team_description' => __('Description', 'pixcustom'),

				);

				return $columns;
			}

			function pixtheme_pixteam_custom_columns($column){
				global $post;
				switch ($column)
				{
					case "team_category":
						echo get_the_term_list($post->ID, 'pixspecialty', '', ', ','');
						break;

					case 'id':
						echo $post->ID;
						break;

					case 'team_description':
						the_excerpt();
						break;

					case 'team_image':
						the_post_thumbnail('thumbnail');
						break;
				}
			}



	        register_post_type( 'portfolio',
								array(
									'label' => $portfolio_label,
									'singular_label' => $portfolio_label,
									'exclude_from_search' => false,
									'publicly_queryable' => true,
									'menu_position' => null,
									'show_ui' => true,
									'public'  =>   true,
									'show_in_menu'  =>   true,
									'menu_icon'     =>   'dashicons-portfolio',
									'query_var' => true,
									'rewrite' => array('slug' => $portfolio_slug),
									'capability_type' => 'page',
									'has_archive'  => true,
									'hierarchical' => false,
									'edit_item' => __( 'Edit', 'pixcustom'),
									'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'page-attributes', 'comments')
								)
							);

			register_taxonomy( 'portfolio_category',
								'portfolio',
								array( 'hierarchical' => true,
										'label' => $portfolio_cat_label,
										'singular_label' => $portfolio_cat_label,
										'public' => true,
		                                'show_tagcloud' => false,
										'query_var' => true,
					                    'rewrite' => array('slug' => $portfolio_cat_slug , 'with_front' => false)
								)
							);

			add_filter('manage_edit-portfolio_columns', 'pixtheme_portfolio_edit_columns');
			add_action('manage_posts_custom_column',  'pixtheme_portfolio_custom_columns');

			function pixtheme_portfolio_edit_columns($columns){
				$columns = array(
					'cb' => '<input type="checkbox" />',
					'title' => __('Title', 'pixcustom'),
					'portfolio_image' => __('Featured Image', 'pixcustom'),
					'id' => __('ID', 'pixcustom'),
					'portfolio_category' => __('Category', 'pixcustom'),
					'portfolio_description' => __('Description', 'pixcustom'),

				);

				return $columns;
			}

			function pixtheme_portfolio_custom_columns($column){
				global $post;
				switch ($column)
				{
					case "portfolio_category":
						echo get_the_term_list($post->ID, 'portfolio_category', '', ', ','');
						break;

					case 'id':
						echo $post->ID;
						break;

					case 'portfolio_description':
						the_excerpt();
						break;

					case 'portfolio_image':
						the_post_thumbnail('thumbnail');
						break;
				}
			}


			register_post_type( 'services' ,
								array(
									'label' => __('Services', 'pixcustom'),
									'singular_label' => __('Service', 'pixcustom'),
									'exclude_from_search' => false,
									'publicly_queryable' => true,
									'menu_position' => null,
									'show_ui' => true,
									'public'  =>   true,
									'show_in_menu'  =>   true,
									'menu_icon'     =>   'dashicons-cloud',
									'query_var' => true,
									'capability_type' => 'page',
									'hierarchical' => false,
									'edit_item' => __( 'Edit Work', 'pixcustom'),
									'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'page-attributes', 'comments')
								)
							);

			register_taxonomy( 'services_category',
								'services',
								array( 'hierarchical' => true,
										'label' => __('Departments', 'pixcustom'),
										'singular_label' => __('Department', 'pixcustom'),
										'public' => true,
		                                'show_tagcloud' => false,
										'query_var' => true,
					                    'rewrite' => array('slug' => 'departments')
								)
							);

			add_filter('manage_edit-services_columns', 'pixtheme_services_edit_columns');
			add_action('manage_posts_custom_column',  'pixtheme_services_custom_columns');

			function pixtheme_services_edit_columns($columns){
				$columns = array(
					'cb' => '<input type="checkbox" />',
					'title' => __('Title', 'pixcustom'),
					'services_image' => __('Featured Image', 'pixcustom'),
					'services_category' => __('Department', 'pixcustom'),
					'services_description' => __('Description', 'pixcustom'),

				);

				return $columns;
			}

			function pixtheme_services_custom_columns($column){
				global $post;
				switch ($column)
				{
					case "services_category":
						echo get_the_term_list($post->ID, 'services_category', '', ', ','');
						break;

					case 'services_description':
						the_excerpt();
						break;

					case 'services_image':
						the_post_thumbnail('thumbnail');
						break;
				}
			}

			add_filter('manage_edit-services_category_columns', 'pixtheme_services_category_columns');
			add_filter('manage_services_category_custom_column', 'pixtheme_services_category_custom_column', 10, 3);

			function pixtheme_services_category_columns($columns){
				$columns = array(
					'cb' => '<input type="checkbox" />',
					'image' => __('Image', 'pixcustom'),
					'name' => __('Name', 'pixcustom'),
				    'description' => __('Description', 'pixcustom'),
					'icon' => __('Icon', 'pixcustom'),
					'posts' => __('Count', 'pixcustom'),
				);

				return $columns;
			}

			function pixtheme_services_category_custom_column($c, $column_name, $term_id){
				$term = get_term_by( 'term_taxonomy_id', $term_id, 'services_category' );
				$t_slug = $term->slug;
				$cat_meta = get_option("services_category_$t_slug");
				switch ($column_name)
				{
					case "image":
						if(isset($cat_meta['pix_image']) && $cat_meta['pix_image']){
						?>
							<img width="150px" src="<?php echo esc_url($cat_meta['pix_image']) ?>">
						<?php
						}
						break;

					case "icon":
						if(isset($cat_meta['pix_icon']) && $cat_meta['pix_icon']){
						    if(filter_var($cat_meta['pix_icon'], FILTER_VALIDATE_URL)) {
                                ?>
                                <img width="50px" src="<?php echo esc_url($cat_meta['pix_icon']) ?>">
                                <?php
                            } else {
						        echo ($cat_meta['pix_icon']);
                            }
						}
						break;

					default:
		                break;
				}

			}



			$labels = array(
					'name'               => _x( 'Pix Sections', 'post type general name', 'pixcustom' ),
					'singular_name'      => _x( 'Pix Section', 'post type singular name', 'pixcustom' ),
					'menu_name'          => _x( 'Pix Sections', 'admin menu', 'pixcustom' ),
					'name_admin_bar'     => _x( 'Pix Section', 'add new on admin bar', 'pixcustom' ),
					'add_new'            => _x( 'Add New', 'book', 'pixcustom' ),
					'add_new_item'       => __( 'Add New Section', 'pixcustom' ),
					'new_item'           => __( 'New Section', 'pixcustom' ),
					'edit_item'          => __( 'Edit Section', 'pixcustom' ),
					'view_item'          => __( 'View Section', 'pixcustom' ),
					'all_items'          => __( 'All Sections', 'pixcustom' ),
					'search_items'       => __( 'Search Section', 'pixcustom' ),
					'parent_item_colon'  => __( 'Parent Section:', 'pixcustom' ),
					'not_found'          => __( 'No sections found.', 'pixcustom' ),
					'not_found_in_trash' => __( 'No sections found in Trash.', 'pixcustom' )
			);

			$args = array(
					'labels'             => $labels,
					'public'             => true,
					'publicly_queryable' => true,
					'show_ui'            => true,
					'show_in_menu'       => true,
					'query_var'          => true,
					'rewrite'            => array( 'slug' => 'pixsection' ),
					'capability_type'    => 'post',
					'has_archive'        => true,
					'hierarchical'       => false,
					'supports'           => array( 'title', 'editor', 'thumbnail', 'page-attributes', 'comments' ),
					'menu_icon'			 => 'dashicons-layout'
			);


			register_post_type( 'pixsections', $args );

		}

	}
	

				
		
		
		
    if(!function_exists('pixtheme_sections_get')) {
        function pixtheme_sections_get () {
            $return_array = array();
            $args = array( 'post_type' => 'pixsections', 'posts_per_page' => 30);
            $myposts = get_posts( $args );
            $i=0;
            foreach ( $myposts as $post ) {
                $i++;
                $return_array[$i]['label'] = get_the_title($post->ID);
                $return_array[$i]['value'] = $post->ID;
            }
            wp_reset_postdata();
            return $return_array;
        }
    }


    if(!function_exists('pixtheme_sections_show')) {
        function pixtheme_sections_show ($id = false) {
            echo pixtheme_sections_single($id);
        }
    }


    if(!function_exists('pixtheme_sections_single')) {
        function pixtheme_sections_single($id = false) {
            if(!$id) return;

            $output = false;

            $output = wp_cache_get( $id, 'pixtheme_sections_single' );

            if ( !$output ) {

                $args = array( 'include' => $id,'post_type' => 'pixsections', 'posts_per_page' => 1);
                $output = '';
                $myposts = get_posts( $args );
                foreach ( $myposts as $post ) {
                    setup_postdata($post);

                    $output = do_shortcode(get_the_content($post->ID));

                    $shortcodes_custom_css = get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true );
                    if ( ! empty( $shortcodes_custom_css ) ) {
                        $output .= '<style type="text/css" data-type="vc_shortcodes-custom-css">';
                        $output .= $shortcodes_custom_css;
                        $output .= '</style>';
                    }
                }
                wp_reset_postdata();

                wp_cache_add( $id, $output, 'pixtheme_sections_single' );
            }

            return $output;
       }
    }


    add_action('admin_init', 'pix_category_custom_fields', 1);
    function pix_category_custom_fields(){
        add_action( 'edited_services_category', 'pix_category_custom_fields_save');
        add_action( 'services_category_edit_form_fields', 'pix_category_custom_fields_form');
        add_action( 'services_category_add_form_fields', 'pix_category_custom_fields_add_form');
        add_action( 'created_services_category', 'pix_category_custom_fields_save');
    }

    
    add_action( 'add_meta_boxes', 'pix_custom_posts_init' );
    function pix_custom_posts_init(){
        add_meta_box('portfolio_fields', __('Information', 'pixcustom'), 'pixtheme_portfolio_info', 'portfolio', 'advanced', 'high');
        add_meta_box('portfolio_layout_options', __('Book an Appointment', 'pixcustom'), 'pixtheme_portfolio_layout_options', 'portfolio', 'side', 'low');
        add_meta_box('post_formats', esc_html__('Post Format Settings', 'pixcustom'), 'pixtheme_post_formats', array('post'), 'advanced', 'high');
        add_meta_box('sidebar_options', esc_html__('Page Layout', 'pixcustom'), 'pixtheme_sidebar_options', array('post', 'page', 'portfolio', 'services'), 'side', 'low');
        add_meta_box( 'pixtheme_header_style', esc_html__('Header Style', 'pixcustom'), 'pixtheme_header_style_content', array('post', 'page', 'portfolio', 'services'), 'side', 'default' );
        function pix_default_hidden_meta_boxes( $hidden, $screen ) {
            // Grab the current post type
            $post_type = $screen->post_type;
            // If we're on a 'post'...
            if ( $post_type != '' ) {
                // Define which meta boxes we wish to hide
                $hidden = array(
                    'slugdiv',
                    'mymetabox_revslider_0'
                );
                // Pass our new defaults onto WordPress
                return $hidden;
            }
            // If we are not on a 'post', pass the
            // original defaults, as defined by WordPress
            return $hidden;
        }
        add_action( 'default_hidden_meta_boxes', 'pix_default_hidden_meta_boxes', 10, 2 );
    }
    

    function pix_category_custom_fields_form($tag){
            $t_slug = $tag->slug;
            $cat_meta = get_option("services_category_$t_slug");
    ?>
    <!--        <tr class="form-field">-->
    <!--        	<th scope="row" valign="top"><label for="tag-pix_serv_title">--><?php //_e('Title', 'pixcustom'); ?><!--</label></th>-->
    <!--        	<td>-->
    <!--        		<input type="text" name="pix_serv_title" id="tag-pix_serv_title" size="25" style="width:60%;" value="--><?php //echo esc_attr($cat_meta['pix_serv_title']) ? esc_attr($cat_meta['pix_serv_title']) : ''; ?><!--">-->
    <!--        	</td>-->
    <!--        </tr>-->
            <tr class="form-field">
                <th scope="row" valign="top"><label for="tag-pix_serv_add_title"><?php _e('Subtitle', 'pixcustom'); ?></label></th>
                <td>
                    <input type="text" name="pix_serv_add_title" id="tag-pix_serv_add_title" size="25" style="width:60%;" value="<?php echo esc_attr($cat_meta['pix_serv_add_title']) ? esc_attr($cat_meta['pix_serv_add_title']) : ''; ?>">
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row" valign="top"><label for="tag-pix_icon"><?php _e('Icon', 'pixcustom'); ?></label></th>
                <td>
                    <input type="text" name="pix_icon" id="tag-pix_icon" size="25" style="width:60%;" value="<?php echo esc_attr($cat_meta['pix_icon']) ? esc_attr($cat_meta['pix_icon']) : ''; ?>">
                    <button data-input="tag-pix_icon" class="btn pix-image-upload pix-btn-icon"><i class="fa fa-picture-o"></i></button>
                    <button type="button" class="btn pix-reset pix-btn-icon"><i class="fa fa-trash-o"></i></button>
                    <?php if(isset($cat_meta['pix_icon']) && filter_var($cat_meta['pix_icon'], FILTER_VALIDATE_URL)){ ?>
                        <p class="pix-bg"> <img width="60px" src="<?php echo esc_url($cat_meta['pix_icon']) ?>" alt="<?php esc_attr_e('Department Icon', 'pixcustom') ?>"> </p>
                    <?php } ?>
                    <p class="pix-field-description"><?php _e('svg, png or icon class', 'pixcustom'); ?></p>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row" valign="top"><label for="tag-pix_image"><?php _e('Image', 'pixcustom'); ?></label></th>
                <td>
                    <input type="text" name="pix_image" id="tag-pix_image" style="width:60%;" value="<?php echo isset($cat_meta['pix_image']) ? esc_url($cat_meta['pix_image']) : ''; ?>" />
                    <button data-input="tag-pix_image" class="btn pix-image-upload pix-btn-icon"><i class="fa fa-picture-o"></i></button>
                    <button type="button" class="btn pix-reset pix-btn-icon"><i class="fa fa-trash-o"></i></button>
                    <?php if(isset($cat_meta['pix_image']) && $cat_meta['pix_image']){ ?><p class="pix-bg"> <img src="<?php echo esc_url($cat_meta['pix_image']) ?>" alt="<?php esc_attr_e('Department Image', 'pixcustom') ?>"> </p><?php } ?>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row" valign="top"><label for="tag-pix_serv_url"><?php _e('Link', 'pixcustom'); ?></label></th>
                <td>
                    <input type="text" name="pix_serv_url" id="tag-pix_serv_url" size="25" style="width:60%;" value="<?php echo esc_attr($cat_meta['pix_serv_url']) ? esc_attr($cat_meta['pix_serv_url']) : ''; ?>">
                    <p class="pix-field-description"><?php _e('Url', 'pixcustom'); ?></p>
                </td>
            </tr>
            <?php
        }

    function pix_category_custom_fields_add_form($tag) {
    ?>
    <!--    <div class="form-field">-->
    <!--        <label for="tag-pix_serv_title">--><?php //_e('Title', 'pixcustom'); ?><!--</label>-->
    <!--        <input type="text" name="pix_serv_title" id="tag-pix_serv_title" size="40" value="">-->
    <!--    </div>-->
        <div class="form-field">
            <label for="tag-pix_serv_add_title"><?php _e('Subtitle', 'pixcustom'); ?></label>
            <input type="text" name="pix_serv_add_title" id="tag-pix_serv_add_title" size="40" value="">
        </div>
        <div class="form-field">
            <label for="tag-pix_icon"><?php _e('Icon', 'pixcustom'); ?></label>
            <input type="text" name="pix_icon" id="tag-pix_icon" size="40" value="">
            <button data-input="tag-pix_icon" class="btn pix-image-upload pix-btn-icon"><i class="fa fa-picture-o"></i></button>
            <button type="button" class="btn pix-reset pix-btn-icon"><i class="fa fa-trash-o"></i></button>
            <p><?php _e('svg, png or icon class', 'pixcustom'); ?></p>
        </div>
        <div class="form-field">
            <label for="tag-pix_image"><?php _e('Image', 'pixcustom'); ?></label>
            <input type="text" name="pix_image" id="tag-pix_image" value="">
            <button data-input="tag-pix_image" class="btn pix-image-upload pix-btn-icon"><i class="fa fa-picture-o"></i></button>
            <button type="button" class="btn pix-reset pix-btn-icon"><i class="fa fa-trash-o"></i></button>
        </div>
        <div class="form-field">
            <label for="tag-pix_serv_url"><?php _e('Link', 'pixcustom'); ?></label>
            <input type="text" name="pix_serv_url" id="tag-pix_serv_url" size="40" value="">
            <br />
            <p><?php _e('Url', 'pixcustom'); ?></p>
        </div>

        <?php
    }

    function pix_category_custom_fields_save($term_id) {
        if (isset($_POST['pix_image']) || isset($_POST['pix_icon']) || isset($_POST['pix_serv_url'])) {
            $term = get_term_by( 'term_taxonomy_id', $term_id, 'services_category' );
            $t_slug = $term->slug;
            $cat_meta = get_option("services_category_$t_slug");
            if (isset($_POST['pix_image'])) {
                $cat_meta['pix_image'] = $_POST['pix_image'];
            }
            if (isset($_POST['pix_icon'])) {
                $cat_meta['pix_icon'] = $_POST['pix_icon'];
            }
            if (isset($_POST['pix_serv_url'])) {
                $cat_meta['pix_serv_url'] = $_POST['pix_serv_url'];
            }
            if (isset($_POST['pix_serv_title'])) {
                $cat_meta['pix_serv_title'] = $_POST['pix_serv_title'];
            }
            if (isset($_POST['pix_serv_add_title'])) {
                $cat_meta['pix_serv_add_title'] = $_POST['pix_serv_add_title'];
            }
            //save the option array
            update_option("services_category_$t_slug", $cat_meta);
        }
    }


    function pixtheme_post_type_link_filter_function( $post_link, $id = 0, $leavename = FALSE ) {
        if ( strpos('%portfolio_category%', $post_link)  < 0 ) {
          return $post_link;
        }
        $post = get_post($id);
        if ( !is_object($post) || $post->post_type != 'portfolio' ) {
          return $post_link;
        }
        $terms = wp_get_object_terms($post->ID, 'portfolio_category');
        if ( !$terms ) {
          return str_replace('portfolio/category/%portfolio_category%/', '', $post_link);
        }
        return str_replace('%portfolio_category%', $terms[0]->slug, $post_link);
    }

    add_filter('post_type_link', 'pixtheme_post_type_link_filter_function', 1, 3);

    function pixtheme_services_link_filter_function( $post_link, $id = 0, $leavename = FALSE ) {
        if ( strpos('%services_category%', $post_link)  < 0 ) {
          return $post_link;
        }
        $post = get_post($id);
        if ( !is_object($post) || $post->post_type != 'services' ) {
          return $post_link;
        }
        $terms = wp_get_object_terms($post->ID, 'services_category');
        if ( !$terms ) {
          return str_replace('services/category/%services_category%/', '', $post_link);
        }
        return str_replace('%services_category%', $terms[0]->slug, $post_link);
    }

    add_filter('post_type_link', 'pixtheme_services_link_filter_function', 1, 3);

		
endif;

add_action( 'plugins_loaded', 'pix_custom_loaded' );
function pix_custom_loaded() {
    global $pix_custom;
    load_plugin_textdomain( 'pixcustom', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
    $pix_custom = new PixCustom();
}


function pix_get_svg_content($url){
    if( empty($url) )
        return '';
    else
        return file_get_contents($url);
}

function pix_out($out){
    echo $out;
}


?>