<?php
/*** The template for displaying portfolio archive. ***/

get_header();

$pixtheme_layout = pixtheme_get_option('portfolio_settings_sidebar_type', '2');
$pixtheme_sidebar = pixtheme_get_option('portfolio_settings_sidebar_content', 'sidebar-1');

if ( ! is_active_sidebar($pixtheme_sidebar) ) $pixtheme_layout = '1';

$pixtheme_portfolio_perrrow = pixtheme_get_option('portfolio_settings_perrow', '2');
if ( $pixtheme_portfolio_perrrow == '3' ) {
	$pixtheme_add_class_port_col = 'col-md-4 col-sm-4 col-xs-6';
}
elseif ( $pixtheme_portfolio_perrrow == '4' ) {
	$pixtheme_add_class_port_col = 'col-md-3 col-sm-4 col-xs-6';
}
else {
	$pixtheme_add_class_port_col = 'col-md-6 col-sm-6 col-xs-6';
}

$pixtheme_portfolio_perrow = pixtheme_get_option('portfolio_settings_perrow', '2');
$pixtheme_portfolio_css_animation = ( pixtheme_get_option('css_animation_settings_portfolio', '') != '' ) ? ' wow '.pixtheme_get_option('css_animation_settings_portfolio', '') : '';
$pixtheme_portfolio_type = pixtheme_get_option('portfolio_settings_type', 'type_without_icons');
$pixtheme_portfolio_loadmore = pixtheme_get_option('portfolio_settings_loadmore', esc_html__('Load more', 'cutstyle' ) );

?>

<!-- ========================== -->
<!-- BLOG - CONTENT -->
<!-- ========================== -->
<section class="page-section">
	<div class="container">
		<div class="row">

			<?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>

			<div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12 col-md-12<?php else : ?>col-lg-8 col-md-8<?php endif; ?> col-sm-12 col-xs-12 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?>">

				<div id="portfolio-category-section" class="portfolio-list-section portfolio-perrow-<?php echo esc_attr($pixtheme_portfolio_perrow); ?>">

				<?php

					$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

					$pixtheme_portfolio_perpage = pixtheme_get_option('portfolio_settings_perpage');
					if ( is_numeric( $pixtheme_portfolio_perpage ) && $pixtheme_portfolio_perpage > 0 ) {
						$pixtheme_archive_perpage = $pixtheme_portfolio_perpage;
					}
					else {
						$pixtheme_archive_perpage = -1;
					}

					$args = array(
								'post_type' => 'portfolio',
								'orderby' => array( 'menu_order' => 'ASC', 'date' => 'DESC' ),
								'paged' => $paged,
								'posts_per_page' => $pixtheme_archive_perpage
							);

					$wp_query = new WP_Query( $args );

					if ( $wp_query->have_posts() ) : ?>

						<div class="row portfolio-masonry-holder list-works clearfix">
						<?php
						while ( $wp_query->have_posts() ) :
							$wp_query->the_post();

							$pixtheme_portfolio_post_type = ( class_exists( 'RW_Meta_Box' ) && rwmb_meta('post_types_select') != '' ) ? rwmb_meta('post_types_select') : 'image';

							$cats = wp_get_object_terms(get_the_id(), 'portfolio_category');
							$pixtheme_cat_slugs = '';
							if ( ! empty($cats) ) {
								foreach ( $cats as $cat ) {
									$pixtheme_cat_slugs .= $cat->slug . " ";
								}
							}
							$pixtheme_portfolio_thumbnail = get_the_post_thumbnail(get_the_id(), 'pixtheme-portfolio-thumb', array('class' => 'img-responsive'));

							// potfolio category list linked
							$pixtheme_portfolio_linked_list_cats = pixtheme_get_post_terms( array( 'taxonomy' => 'portfolio_category', 'items_wrap' => '%s' ) );

							if ( $pixtheme_portfolio_type == 'type_without_icons' || $pixtheme_portfolio_type == 'type_without_space' ) : ?>
								<?php $pixtheme_no_space_class = $pixtheme_portfolio_type == 'type_without_space' ? 'pix-no-space' : ''; ?>
									<div class="<?php echo esc_attr($pixtheme_add_class_port_col); ?> item <?php echo esc_attr($pixtheme_no_space_class); ?> <?php echo esc_attr($pixtheme_portfolio_css_animation); ?> <?php echo esc_attr($pixtheme_cat_slugs); ?>" id="post-<?php echo esc_attr(get_the_ID()); ?>">
										<div class="portfolio-item">
											<div class="portfolio-image">
												<a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo wp_kses_post($pixtheme_portfolio_thumbnail); ?></a>
											</div>
                                            <div class="portfolio-item-body">
                                                <h3><a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo wp_kses_post( get_the_title() ); ?></a></h3>
                                                <div class="under-name"><?php echo wp_kses_post( $pixtheme_portfolio_linked_list_cats ); ?></div>
                                            </div>
										</div>
									</div>

							<?php
							else : ?>

									<div class="<?php echo esc_attr($pixtheme_add_class_port_col); ?> item <?php echo esc_attr($pixtheme_portfolio_css_animation); ?> <?php echo esc_attr($pixtheme_cat_slugs); ?>" id="post-<?php echo esc_attr(get_the_ID()); ?>">
										<div class="portfolio-item">
											<div class="portfolio-image">
												<a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo wp_kses_post($pixtheme_portfolio_thumbnail); ?></a>
												<div class="portfolio-item-body center-body">
													<ul>
														<?php
														if ( $pixtheme_portfolio_post_type == 'image' ) :
															$pixtheme_portfolio_gallery = ( class_exists( 'RW_Meta_Box' ) ) ? rwmb_meta('portfolio_images', 'type=image&size=full') : '';
															$pixtheme_portfolio_full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_id()), 'full', false);
															$pixtheme_portfolio_full_image_link = $pixtheme_portfolio_full_image[0];
															?>
															<li><a href="<?php echo esc_url($pixtheme_portfolio_full_image_link); ?>"  rel="prettyPhoto[pp_gal_<?php echo esc_attr(get_the_id());?>]"><span class="icon icon-Search"></span></a></li>
															<?php
															if ( $pixtheme_portfolio_gallery ) :
																foreach ( $pixtheme_portfolio_gallery as $key => $slide ) :
																	if ( $key > 0 ) :
																	?>
																		<div class="portfolio-gallery-none">
																			<a href="<?php echo esc_url($slide['url']); ?>" rel="prettyPhoto[pp_gal_<?php echo esc_attr($post->ID); ?>]" ><img src="<?php echo esc_url($slide['url']); ?>" width="<?php echo esc_attr($slide['width']); ?>" height="<?php echo esc_attr($slide['height']); ?>" alt="<?php echo esc_attr($slide['alt']); ?>" title="<?php echo esc_attr($slide['title']); ?>"/></a>
																		</div>
																	<?php
																	endif;
																endforeach;
															endif;
														 ?>
														<?php
														endif; ?>
														<?php
														if ( $pixtheme_portfolio_post_type == 'video' ) :
															$pixtheme_portfolio_video_href = ( class_exists( 'RW_Meta_Box' ) ) ? get_post_meta( get_the_ID(), 'portfolio_video_href', true ) : '';
															if ( $pixtheme_portfolio_video_href != '' ) :
																$pixtheme_portfolio_video_width = ( class_exists( 'RW_Meta_Box' ) ) ? rwmb_meta('portfolio_video_width') : '';
																$pixtheme_portfolio_video_height = ( class_exists( 'RW_Meta_Box' ) ) ? rwmb_meta('portfolio_video_height') : '';
																?>
																<li><a href="<?php echo esc_url($pixtheme_portfolio_video_href.'?width='.esc_attr($pixtheme_portfolio_video_width).'&amp;height='. esc_attr($pixtheme_portfolio_video_height)) ?>" rel="prettyPhoto[pp_video_<?php echo esc_attr(get_the_id());?>]"><span class="icon icon-Media"></span></a></li>
															<?php
															endif;
														endif;
														?>
															<li><a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><span class="icon icon-Info"></span></a></li>
														<?php



														?>
													</ul>
												</div>
											</div>
											<div class="portfolio-item-footer">
												<div class="name"><?php echo wp_kses_post( get_the_title() ); ?></div>
												<div class="under-name"><?php echo wp_kses_post($pixtheme_portfolio_linked_list_cats); ?></div>
											</div>
										</div>
									</div>

							<?php
							endif;

						endwhile; ?>
						</div>

						<?php
						if ( get_next_posts_link( '', $wp_query->max_num_pages ) ) {

							echo '
								<div class="row">
									<div class="col-md-12 text-center">
										<div class="portfolio-pagination">
											<span data-current="'.esc_attr($paged).'" data-max-pages="'.esc_attr($wp_query->max_num_pages).'" class="load-more">' . get_next_posts_link( wp_kses_post($pixtheme_portfolio_loadmore), $wp_query->max_num_pages) . '</span>
										</div>
										<div class="portfolio-pagination-loading">
											<a href="javascript: void(0)" class="btn btn-default">'. esc_html__("Loading...", "cutstyle") .'</a>
										</div>
									</div>
								</div>
							';
						}
						?>

					<?php
					endif;
				?>
				</div>

			</div>

			<?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>

		</div>
	</div>
</section>

<?php get_footer(); ?>