<?php

$pixtheme_layout = pixtheme_get_option('blog_settings_sidebar_type', '2');
$pixtheme_sidebar = pixtheme_get_option('blog_settings_sidebar_content', 'sidebar-1');


if ( ! is_active_sidebar($pixtheme_sidebar) ) $pixtheme_layout = '1';

    $custom = isset ($wp_query) ? get_post_custom($wp_query->get_queried_object_id()) : '';
?>

<?php get_header(); ?>

<section class="blog-content-section" id="main">
	<div class="container">
	    <div class="row">
	        <?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>
	        <div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12 col-md-12<?php else : ?>col-lg-8 col-md-8<?php endif; ?> col-sm-12 col-xs-12 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?>">
	            <?php if ( have_posts() ) : ?>

                     <?php
                         if ( have_posts() )
                            the_post();
                         rewind_posts();
                         get_template_part( 'loop', 'archive' );
                     ?>

                <?php endif ?>
				
                <?php
                    the_posts_pagination( array(
                        'prev_text'          => wp_kses_post(__( '<i class="icon-arrow-left"></i>', 'cutstyle' )),
                        'next_text'          => wp_kses_post(__( '<i class="icon-arrow-right"></i>', 'cutstyle' )),
                        'screen_reader_text' => esc_html__( '&nbsp;', 'cutstyle'),
                    ) );
                ?>
				
	        </div>
	        <?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>
	    </div>
	</div>
</section>

<?php get_footer(); ?>