<?php
/**
 * The main template file
 */

$pixtheme_class = array('', 'pix-no-sidebar', 'pix-right-sidebar', 'pix-left-sidebar');
$pixtheme_postpage_id = get_option( 'page_for_posts' );
$pixtheme_frontpage_id = get_option( 'page_on_front' );
$pixtheme_page_id = isset($wp_query) ? $wp_query->get_queried_object_id() : '';

if ( $pixtheme_page_id == $pixtheme_postpage_id && $pixtheme_postpage_id != $pixtheme_frontpage_id ) :
	$pixtheme_custom = isset( $wp_query ) ? get_post_custom( $wp_query->get_queried_object_id() ) : '';
	$pixtheme_layout = isset( $pixtheme_custom['pix_page_layout'] ) ? $pixtheme_custom['pix_page_layout'][0] : '2';
	$pixtheme_sidebar = isset( $pixtheme_custom['pix_selected_sidebar'][0] ) ? $pixtheme_custom['pix_selected_sidebar'][0] : 'sidebar-1';
else :
	$pixtheme_layout = pixtheme_get_option('blog_settings_sidebar_type', '2');
	$pixtheme_sidebar = pixtheme_get_option('blog_settings_sidebar_content', 'sidebar-1');
endif;

if ( ! is_active_sidebar($pixtheme_sidebar) ) {
    $pixtheme_layout = '1';
}

$blog_class = pixtheme_get_option('blog_settings_type', 'classic') == 'grid' ? 'row blog-masonry' : 'blog-list';

?>
<?php get_header();?>

<section class="blog">
	<div class="container">
		<div class="row sidebar-type-<?php echo esc_attr($pixtheme_layout); ?>">
			<?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>

			<div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12<?php else : ?>col-lg-8<?php endif; ?> col-md-12 col-sm-12 col-xs-12 <?php echo esc_attr($pixtheme_class[$pixtheme_layout])?>">
                <section class="<?php echo esc_attr($blog_class) ?>">
                <?php
                    $wp_query = new WP_Query();
                    $pp = get_option('posts_per_page');
                    $wp_query->query('posts_per_page='.$pp.'&paged='.$paged);
                    get_template_part( 'loop', 'index' );
                ?>
                </section>
                <?php
                    the_posts_pagination( array(
                        'prev_text'          => wp_kses_post(__( '<i class="icon-arrow-left"></i>', 'cutstyle' )),
                        'next_text'          => wp_kses_post(__( '<i class="icon-arrow-right"></i>', 'cutstyle' )),
                        'screen_reader_text' => esc_html__( '&nbsp;', 'cutstyle'),
                    ) );
                ?>
			</div>
			<!-- end col -->

			<?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>
		</div>
		<!-- end row -->
	</div>
</section>
<?php get_footer(); ?>
