<?php
$post_ID = isset ($wp_query) ? $wp_query->get_queried_object_id() : (get_the_ID()>0 ? get_the_ID() : '');
$custom =  get_post_custom($post_ID);
$layout = isset ($custom['_page_layout']) ? $custom['_page_layout'][0] : '1';
$i=0;

$blog_class_item = pixtheme_get_option('blog_settings_type', 'classic') == 'grid' ? 'col-lg-6 blog-masonry-item' : 'blog-list__article';

?>

<?php if ( ! have_posts() ) : ?>
    <div  class="post error404 not-found">
        <h1 class="entry-title"><?php esc_html_e( 'Not Found', 'cutstyle' ); ?></h1>
        <div class="entry-content">
            <p><?php esc_html_e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'cutstyle' ); ?></p>
            <?php get_search_form(); ?>
        </div><!-- .entry-content -->
    </div><!-- #post-0 -->
<?php endif; ?>


	<?php while ( have_posts() ) : the_post(); ?>
        <?php
            $pixtheme_class = $pixtheme_date = $pixtheme_cat = $pixtheme_dev = '';
            $pixtheme_format  = get_post_format();
            $pixtheme_format = !in_array($pixtheme_format, array("quote", "gallery", "video")) ? 'standared' : $pixtheme_format;

			$pixtheme_img_class = !has_post_thumbnail() ? 'no-image' : '';
			$pixtheme_blog_item = get_post_format() ? get_post_format() : 'standared';
            $pixtheme_class_content = '';//'article-three';
			$classes = array($blog_class_item,'blog-item-'.$pixtheme_blog_item,$pixtheme_img_class,$pixtheme_class_content, 'animate', 'fadeInUp');

			if(pixtheme_get_option('blog_settings_type', 'classic') == 'grid') :
        ?>
            <div id="post-<?php esc_attr(the_ID()); ?>" <?php post_class($classes); ?>>
                <div class="blog-masonry__item">
                <?php if( $pixtheme_format == 'standared' ) : ?>
                    <a href="<?php esc_url(the_permalink())?>">
                <?php endif; ?>
                    <div class="blog-masonry__item-image">
                        <div class="overlay"></div>
                        <?php get_template_part( 'templates/post-parts/blog', get_post_format() ); ?>
                        <?php if( $pixtheme_date != '' || $pixtheme_cat != '' ) : ?>
                            <div class="post-date text-uppercase"><?php echo wp_kses_post($pixtheme_date) ?><?php echo wp_kses_post($pixtheme_dev) ?><?php echo wp_kses_post($pixtheme_cat) ?></div>
                        <?php endif; ?>
                    </div>
                <?php if( $pixtheme_format == 'standared' ) : ?>
                    </a>
                <?php endif; ?>
                    <div class="blog-masonry__item-text">
                        <?php get_template_part( 'templates/post-parts/content', get_post_format() ); ?>
                    </div>
                </div>
            </div>
        <?php
            else :
        ?>
            <div id="post-<?php esc_attr(the_ID()); ?>" <?php post_class($classes); ?>>
                <?php if( $pixtheme_format == 'standared' ) : ?>
                <a href="<?php esc_url(the_permalink())?>">
                    <?php endif; ?>
                    <div class="blog-list__article-image">
                        <div class="overlay"></div>
                        <?php get_template_part( 'templates/post-parts/blog', $pixtheme_format); ?>
                        <?php if( $pixtheme_date != '' || $pixtheme_cat != '' ) : ?>
                            <div class="post-date text-uppercase"><?php echo wp_kses_post($pixtheme_date) ?><?php echo wp_kses_post($pixtheme_dev) ?><?php echo wp_kses_post($pixtheme_cat) ?></div>
                        <?php endif; ?>
                    </div>
                    <?php if( $pixtheme_format == 'standared' ) : ?>
                </a>
            <?php endif; ?>
                <div class="blog-list__article-text">
                    <?php get_template_part( 'templates/post-parts/content', get_post_format()); ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endwhile;?>

