<?php 
	
	function pixtheme_customize_footer_tab($wp_customize, $theme_name){

		$wp_customize->add_section( 'pixtheme_footer_settings' , array(
		    'title'      => esc_html__( 'Footer', 'cutstyle' ),
		    'priority'   => 75,
		) );


		$pix_sections = pixtheme_get_sections_array();

		$wp_customize->add_setting( 'pixtheme_footer_section' , array(
			'default'     => '0',
			'transport'   => 'postMessage',
			'sanitize_callback' => 'esc_html'
		) );
		$wp_customize->add_control(
			'pixtheme_footer_section',
			array(
				'label'    => esc_html__( 'Footer Section', 'cutstyle' ),
				'section'  => 'pixtheme_footer_settings',
				'settings' => 'pixtheme_footer_section',
				'type'     => 'select',
				'choices'  => $pix_sections,
			)
		);

		$wp_customize->add_setting( 'pixtheme_footer_socials' , array(
            'default'     => '1',
            'transport'   => 'postMessage',
		    'sanitize_callback' => 'esc_html'
        ) );

		$wp_customize->add_control(
            'pixtheme_footer_socials',
            array(
                'label'    => esc_html__( 'Show Footer Socials', 'cutstyle' ),
                'description' => esc_html__( 'Display, if Footer Section are not selected.', 'cutstyle' ),
                'section'  => 'pixtheme_footer_settings',
                'settings' => 'pixtheme_footer_socials',
                'type'     => 'select',
                'choices'  => array(
                    '1'  => esc_html__( 'On', 'cutstyle' ),
                    '0' => esc_html__( 'Off', 'cutstyle' ),
                ),
            )
        );

        $wp_customize->add_setting( 'pixtheme_footer_copyright' , array(
            'default'     => esc_html__( 'Copyright 2018. Designed by PixTheme', 'cutstyle' ),
            'transport'   => 'postMessage',
		    'sanitize_callback' => 'esc_html'
        ) );

        $wp_customize->add_control(
            'pixtheme_footer_copyright',
            array(
                'label'    => esc_html__( 'Footer Copyright Text', 'cutstyle' ),
                'description' => esc_html__( 'Display, if Footer Section are not selected.', 'cutstyle' ),
                'section'  => 'pixtheme_footer_settings',
                'settings' => 'pixtheme_footer_copyright',
                'type'     => 'textarea',
            )
        );


	}
		
?>