<?php

function pixtheme_customize_portfolio_tab($wp_customize, $theme_name) {

	$wp_customize->add_panel('pixtheme_portfolio_settings',
	array(
		'title' => esc_html__( 'Portfolio', 'cutstyle' ),
		'priority' => 55,
		)
	);

	// portfolio general settings
	$wp_customize->add_section( 'pixtheme_portfolio_general_settings' , array(
		'title'      => esc_html__( 'General', 'cutstyle' ),
		'priority'   => 10,
		'panel' => 'pixtheme_portfolio_settings'
	) );


	$wp_customize->add_setting( 'pixtheme_portfolio_settings_thumb_width' , array(
		'default'     => '555',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_absinteger'
	) );
	$wp_customize->add_control(
		'pixtheme_portfolio_settings_thumb_width',
		array(
			'label'    => esc_html__( 'Tumbnails Width (px)', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_general_settings',
			'settings' => 'pixtheme_portfolio_settings_thumb_width',
			'type'     => 'textfield',
			'description' => esc_html__( 'Default: 555px', 'cutstyle' ),
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_thumb_height' , array(
		'default'     => '555',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_absinteger'
	) );
	$wp_customize->add_control(
		'pixtheme_portfolio_settings_thumb_height',
		array(
			'label'    => esc_html__( 'Tumbnails Height (px)', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_general_settings',
			'settings' => 'pixtheme_portfolio_settings_thumb_height',
			'type'     => 'textfield',
			'description' => esc_html__( 'Default: 555px', 'cutstyle' ),
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_slug' , array(
		'default'     => '',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_absinteger'
	) );
	$wp_customize->add_control(
		'pixtheme_portfolio_slug',
		array(
			'label'    => esc_html__( 'Url Slug', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_general_settings',
			'settings' => 'pixtheme_portfolio_slug',
			'type'     => 'textfield',
			'description' => esc_html__( 'Default: portfolio', 'cutstyle' ),
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_label' , array(
		'default'     => '',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_absinteger'
	) );
	$wp_customize->add_control(
		'pixtheme_portfolio_label',
		array(
			'label'    => esc_html__( 'Label', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_general_settings',
			'settings' => 'pixtheme_portfolio_label',
			'type'     => 'textfield',
			'description' => esc_html__( 'Default: Portfolio', 'cutstyle' ),
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_cat_slug' , array(
		'default'     => '',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_absinteger'
	) );
	$wp_customize->add_control(
		'pixtheme_portfolio_cat_slug',
		array(
			'label'    => esc_html__( 'Url Category Slug', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_general_settings',
			'settings' => 'pixtheme_portfolio_cat_slug',
			'type'     => 'textfield',
			'description' => esc_html__( 'Default: portfolio_category', 'cutstyle' ),
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_cat_label' , array(
		'default'     => '',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_absinteger'
	) );
	$wp_customize->add_control(
		'pixtheme_portfolio_cat_label',
		array(
			'label'    => esc_html__( 'Categories Label', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_general_settings',
			'settings' => 'pixtheme_portfolio_cat_label',
			'type'     => 'textfield',
			'description' => esc_html__( 'Default: Categories', 'cutstyle' ),
		)
	);


	// portfolio categories page settings
	$wp_customize->add_section( 'pixtheme_portfolio_categories_settings' , array(
		'title'      => esc_html__( 'Category and Archive Pages', 'cutstyle' ),
		'priority'   => 20,
		'panel' => 'pixtheme_portfolio_settings'
	) );

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_type' , array(
		'default'     => 'type_without_icons',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_portfolio_type'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_type',
		array(
			'label'    => esc_html__( 'Item type', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_categories_settings',
			'settings' => 'pixtheme_portfolio_settings_type',
			'description' => esc_html__( 'display type', 'cutstyle' ),
			'type'     => 'select',
			'choices'  => array(
				'type_without_icons' => esc_html__( 'Without over icons with space', 'cutstyle' ),
				'type_without_space' => esc_html__( 'Without over icons and space', 'cutstyle' ),
				'type_with_icons' => esc_html__( 'With over icons', 'cutstyle' ),
			),
			'priority' => 10
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_perrow' , array(
		'default'     => '2',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_portfolio_perrow'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_perrow',
		array(
			'label'    => esc_html__( 'Column Number', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_categories_settings',
			'settings' => 'pixtheme_portfolio_settings_perrow',
			'description' => esc_html__( 'Items per row for category and archive pages.', 'cutstyle' ),
			'type'     => 'select',
			'choices'  => array(
				'2' => esc_html__( '2 columns', 'cutstyle' ),
				'3' => esc_html__( '3 columns', 'cutstyle' ),
				'4' => esc_html__( '4 columns', 'cutstyle' ),
			),
			'priority' => 20
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_perpage' , array(
		'default'     => '',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_per_page'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_perpage',
		array(
			'label'    => esc_html__( 'Items per page', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_categories_settings',
			'settings' => 'pixtheme_portfolio_settings_perpage',
			'description' => esc_html__( 'Leave empty to show all items.', 'cutstyle' ),
			'type'     => 'textfield',
			'priority' => 30
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_sidebar_type' , array(
		'default'     => '2',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_sidebar_portfolio_type'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_sidebar_type',
		array(
			'label'    => esc_html__( 'Sidebar type', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_categories_settings',
			'settings' => 'pixtheme_portfolio_settings_sidebar_type',
			'description' => esc_html__( 'Select sidebar type for category and archive pages.', 'cutstyle' ),
			'type'     => 'select',
			'choices'  => array(
				'1' => esc_html__( 'Full width', 'cutstyle' ),
				'2' => esc_html__( 'Right Sidebar', 'cutstyle' ),
				'3' => esc_html__( 'Left Sidebar', 'cutstyle' ),
			),
			'priority' => 40
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_sidebar_content' , array(
		'default'     => 'sidebar-1',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_sidebar_portfolio_content'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_sidebar_content',
		array(
			'label'    => esc_html__( 'Sidebar content', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_categories_settings',
			'settings' => 'pixtheme_portfolio_settings_sidebar_content',
			'description' => esc_html__( 'Select sidebar content for category and archive pages.', 'cutstyle' ),
			'type'     => 'select',
			'choices'  => array(
				'sidebar-1' => esc_html__( 'WP Default Sidebar', 'cutstyle' ),
				'global-sidebar-1' => esc_html__( 'Blog Sidebar', 'cutstyle' ),
				'portfolio-sidebar-1' => esc_html__( 'Portfolio Sidebar', 'cutstyle' ),
				'custom-area-1' => esc_html__( 'Custom Area', 'cutstyle' ),
			),
			'priority' => 50
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_loadmore' , array(
		'default'     => esc_html__('Load more', 'cutstyle' ),
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_text'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_loadmore',
		array(
			'label'    => esc_html__( 'Load More button text', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_categories_settings',
			'settings' => 'pixtheme_portfolio_settings_loadmore',
			'type'     => 'textfield',
			'priority' => 60
		)
	);


	// portfolio single page settings
	$wp_customize->add_section( 'pixtheme_portfolio_single_settings' , array(
		'title'      => esc_html__( 'Single Page', 'cutstyle' ),
		'priority'   => 30,
		'panel' => 'pixtheme_portfolio_settings'
	) );

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_related_show' , array(
		'default'     => 'on',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_onoff'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_related_show',
		array(
			'label'    => esc_html__( 'Show block Related', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_single_settings',
			'settings' => 'pixtheme_portfolio_settings_related_show',
			'description' => esc_html__( 'Select on/off Related for single page.', 'cutstyle' ),
			'type'     => 'select',
			'choices'  => array(
				'on' => esc_html__( 'On', 'cutstyle' ),
				'off' => esc_html__( 'Off', 'cutstyle' ),
			),
			'priority' => 10
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_related_title' , array(
		'default'     => esc_html__('Related', 'cutstyle' ),
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_text'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_related_title',
		array(
			'label'    => esc_html__( 'Title block Related', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_single_settings',
			'settings' => 'pixtheme_portfolio_settings_related_title',
			'type'     => 'textfield',
			'priority' => 20
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_related_desc' , array(
		'default'     => '',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_text'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_related_desc',
		array(
			'label'    => esc_html__( 'Description block Related', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_single_settings',
			'settings' => 'pixtheme_portfolio_settings_related_desc',
			'type'     => 'textarea',
			'priority' => 30
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_share' , array(
		'default'     => 'on',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'pixtheme_sanitize_onoff'
	) );

	$wp_customize->add_control(
		'pixtheme_portfolio_settings_share',
		array(
			'label'    => esc_html__( 'Show share', 'cutstyle' ),
			'section'  => 'pixtheme_portfolio_single_settings',
			'settings' => 'pixtheme_portfolio_settings_share',
			'description' => esc_html__( 'Select on/off share for single pages.', 'cutstyle' ),
			'type'     => 'select',
			'choices'  => array(
				'on' => esc_html__( 'On', 'cutstyle' ),
				'off' => esc_html__( 'Off', 'cutstyle' ),
			),
			'priority' => 40
		)
	);

	$wp_customize->add_setting( 'pixtheme_portfolio_settings_link_to_all' , array(
		'default'     => '0',
		'transport'   => 'postMessage',
		'sanitize_callback' => 'esc_attr'
	) );
	$wp_customize->add_control( 'pixtheme_portfolio_settings_page', array(
		'label'    => esc_html__( 'Select Page For All Portfolio', 'cutstyle' ),
		'section'  => 'pixtheme_portfolio_single_settings',
		'settings' => 'pixtheme_portfolio_settings_link_to_all',
		'type'     => 'dropdown-pages',
		'priority' => 50
	) );


}