<?php

	function pixtheme_customize_responsive_tab($wp_customize, $theme_name){
	
		$wp_customize->add_section( 'pixtheme_responsive_settings' , array(
		    'title'      => esc_html__( 'Responsive', 'cutstyle' ),
		    'priority'   => 35,
		) );

		$wp_customize->add_setting( 'pixtheme_general_settings_responsive' , array(
		    'default'     => '',
		    'transport'   => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'pixtheme_mobile_sticky' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'pixtheme_mobile_topbar' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'pixtheme_tablet_minicart' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'pixtheme_tablet_search' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'pixtheme_tablet_phone' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'pixtheme_tablet_socials' , array(
				'default'     => '',
				'transport'   => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field'
		) );

		

		$wp_customize->add_control(
			'pixtheme_general_settings_responsive',
			array(
				'label'    => esc_html__( 'Responsive', 'cutstyle' ),
				'section'  => 'pixtheme_responsive_settings',
				'settings' => 'pixtheme_general_settings_responsive',
				'type'     => 'select',
				'choices'  => array(
					'off'  => esc_html__( 'Off', 'cutstyle' ),
					'on'   => esc_html__( 'On', 'cutstyle' ),
				),
				'priority'   => 5
			)
		);

		$wp_customize->add_control(
            'pixtheme_mobile_sticky',
            array(
                'label'    => esc_html__( 'Header Mobile Behavior', 'cutstyle' ),
                'description'   => esc_html__( 'Off header sticky or fixed on mobile', 'cutstyle' ),
                'section'  => 'pixtheme_responsive_settings',
                'settings' => 'pixtheme_mobile_sticky',
                'type'     => 'select',
                'choices'  => array(
                    ''  => esc_html__( 'Global', 'cutstyle' ),
                    'mobile-no-sticky' => esc_html__( 'No Sticky', 'cutstyle' ),
		            'mobile-no-fixed' => esc_html__( 'No Fixed', 'cutstyle' ),
                ),
                'priority'   => 10
            )
        );

        $wp_customize->add_control(
            'pixtheme_mobile_topbar',
            array(
                'label'    => esc_html__( 'Header Mobile Behavior', 'cutstyle' ),
                'description'   => esc_html__( 'Off header top bar on mobile', 'cutstyle' ),
                'section'  => 'pixtheme_responsive_settings',
                'settings' => 'pixtheme_mobile_sticky',
                'type'     => 'select',
                'choices'  => array(
                    ''  => esc_html__( 'Global', 'cutstyle' ),
                    'no-mobile-topbar' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 20
            )
        );

        $wp_customize->add_control(
            'pixtheme_tablet_minicart',
            array(
                'label'    => esc_html__( 'Tablet Minicart', 'cutstyle' ),
                'description'   => esc_html__( 'Off header cart on tablet', 'cutstyle' ),
                'section'  => 'pixtheme_responsive_settings',
                'settings' => 'pixtheme_tablet_minicart',
                'type'     => 'select',
                'choices'  => array(
                    ''  => esc_html__( 'Global', 'cutstyle' ),
                    'no-tablet-minicart' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 30
            )
        );

        $wp_customize->add_control(
            'pixtheme_tablet_search',
            array(
                'label'    => esc_html__( 'Tablet Search', 'cutstyle' ),
                'description'   => esc_html__( 'Off header search on tablet', 'cutstyle' ),
                'section'  => 'pixtheme_responsive_settings',
                'settings' => 'pixtheme_tablet_search',
                'type'     => 'select',
                'choices'  => array(
                    ''  => esc_html__( 'Global', 'cutstyle' ),
                    'no-tablet-search' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 40
            )
        );

        $wp_customize->add_control(
            'pixtheme_tablet_phone',
            array(
                'label'    => esc_html__( 'Tablet Header Phone', 'cutstyle' ),
                'description'   => esc_html__( 'Off header phone on tablet', 'cutstyle' ),
                'section'  => 'pixtheme_responsive_settings',
                'settings' => 'pixtheme_tablet_phone',
                'type'     => 'select',
                'choices'  => array(
                    ''  => esc_html__( 'Global', 'cutstyle' ),
                    'no-tablet-phone' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 50
            )
        );

        $wp_customize->add_control(
            'pixtheme_tablet_socials',
            array(
                'label'    => esc_html__( 'Tablet Socials', 'cutstyle' ),
                'description'   => esc_html__( 'Off header social icons on tablet', 'cutstyle' ),
                'section'  => 'pixtheme_responsive_settings',
                'settings' => 'pixtheme_tablet_socials',
                'type'     => 'select',
                'choices'  => array(
                    ''  => esc_html__( 'Global', 'cutstyle' ),
                    'no-tablet-socials' => esc_html__( 'Off', 'cutstyle' ),
                ),
                'priority'   => 60
            )
        );
		
	}
		
?>