/* customizer preview */

jQuery(function($){

    "use strict";
    var api = wp.customize;
    function hexToRgb(hex) {
        // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
        var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
        hex = hex.replace(shorthandRegex, function(m, r, g, b) {
            return r + r + g + g + b + b;
        });

        var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
        return result ? parseInt(result[1], 16)+', '+parseInt(result[2], 16)+', '+parseInt(result[3], 16) : null;
    }


    /////////////////////////////////////////////////////////////////
    //   HEADER SETTINGS
    /////////////////////////////////////////////////////////////////

    api( 'pixtheme_general_settings_logo_height', function( value ) {
        value.bind( function( to ) {
            if ( to > 75 ) {
                $('html').attr('style', '--pix-header-height: '+to+'px');
            }
        } );
    } );

    api( 'pixtheme_general_settings_logo_width', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                $( 'a.navbar-brand').css('width', to+'px');
            }
        } );
    } );

    api( 'pixtheme_header_layout', function( value ) {
        value.bind( function( to ) {
            if ( to == 'container-fluid' ) {
                $( 'header.pix-header > div').addClass('container-fluid').removeClass('container');
            } else {
                $( 'header.pix-header > div').addClass('container').removeClass('container-fluid');
            }
        } );
    } );

    api( 'pixtheme_header_background', function( value ) {
        if( value.get() == 'white' ){
            $( 'header.pix-header').addClass('white').removeClass('black');
        } else {
            $( 'header.pix-header').addClass('black').removeClass('white');
        }
        value.bind( function( to ) {
            if ( to == 'white' ) {
                $( 'header.pix-header').addClass('white').removeClass('black');
            } else {
                $( 'header.pix-header').addClass('black').removeClass('white');
            }
        } );
    } );

    api( 'pixtheme_header_transparent', function( value ) {
        value.bind( function( to ) {
            if ( to < 100 ) {
                $( 'header.pix-header').addClass('transparent');
                document.documentElement.style.setProperty('--pix-header-transparent', to/100);
            } else {
                $( 'header.pix-header').removeClass('transparent');
            }
        } );
    } );



    /////////////////////////////////////////////////////////////////
    //   RANGE SLIDER
    /////////////////////////////////////////////////////////////////

    api( 'pixtheme_shadow_show', function( value ) {
        value.bind( function( to ) {
            if ( to == '0' ) {
                $( '.item-default.item-default-filled').css('box-shadow', 'none');
            } else {
                var h_position = wp.customize( 'pixtheme_shadow_h_position' ).get();
                var v_position = wp.customize( 'pixtheme_shadow_v_position' ).get();
                var blur = wp.customize( 'pixtheme_shadow_blur' ).get();
                var spread = wp.customize( 'pixtheme_shadow_spread' ).get();
                var color = wp.customize( 'pixtheme_shadow_color' ).get();
                var opacity = wp.customize( 'pixtheme_shadow_opacity' ).get()/100;
                $( '.item-default.item-default-filled').css('box-shadow', h_position+'px '+v_position+'px '+blur+'px '+spread+'px rgba('+hexToRgb(color)+','+opacity+' )');
            }
        } );
    } );

    api( 'pixtheme_shadow_h_position', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                var result = $('.item-default.item-default-filled').css('box-shadow').match(/(-?\d+px)|(rgba\(.+\))|(rgb\(.+\))/g);
                $( '.item-default.item-default-filled').css('box-shadow', to+'px ' + result[2] +' '+ result[3] +' '+ result[4] +' '+ result[0]);
            }
        } );
    } );

    api( 'pixtheme_shadow_v_position', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                var result = $('.item-default.item-default-filled').css('box-shadow').match(/(-?\d+px)|(rgba\(.+\))|(rgb\(.+\))/g);
                $( '.item-default.item-default-filled').css('box-shadow', result[1] +' '+ to+'px ' + result[3] +' '+ result[4] +' '+ result[0]);
            }
        } );
    } );

    api( 'pixtheme_shadow_blur', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                var result = $('.item-default.item-default-filled').css('box-shadow').match(/(-?\d+px)|(rgba\(.+\))|(rgb\(.+\))/g);
                $( '.item-default.item-default-filled').css('box-shadow', result[1] +' '+ result[2] +' '+ to+'px ' +' '+ result[4] +' '+ result[0]);
            }
        } );
    } );

    api( 'pixtheme_shadow_spread', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                var result = $('.item-default.item-default-filled').css('box-shadow').match(/(-?\d+px)|(rgba\(.+\))|(rgb\(.+\))/g);
                $( '.item-default.item-default-filled').css('box-shadow', result[1] +' '+ result[2] +' '+ result[3] +' '+ to+'px ' +' '+ result[0]);
            }
        } );
    } );

    api( 'pixtheme_shadow_color', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                var result = $('.item-default.item-default-filled').css('box-shadow').match(/(-?\d+px)|(rgba\(.+\))|(rgb\(.+\))/g);
                var rgba = result[0].match(/(-?\d+,)|(\d+(\.\d{1,2})?)/g);
                var opacity = rgba[3] == null ? 1 : rgba[3];
                $( '.item-default.item-default-filled').css('box-shadow', result[1] +' '+ result[2] +' '+ result[3] +' '+ result[4] +' rgba('+ hexToRgb(to) + ', '+opacity+')');
            }
        } );
    } );

    api( 'pixtheme_shadow_opacity', function( value ) {
        value.bind( function( to ) {
            if ( to ) {
                var result = $('.item-default.item-default-filled').css('box-shadow').match(/(-?\d+px)|(rgba\(.+\))|(rgb\(.+\))/g);
                var rgba = result[0].match(/(-?\d+,)|(\d+(\.\d{1,2})?)/g);
                rgba.forEach(function(item, i, arr) {
                    rgba[i] = item.replace(',', '');
                });
                var opacity = to / 100;
                $( '.item-default.item-default-filled').css('box-shadow', result[1] +' '+ result[2] +' '+ result[3] +' '+ result[4] +' rgba('+ rgba[0]+','+rgba[1]+','+rgba[2]+','+opacity +')');
            }
        } );
    } );

});
