<?php 
/**  Theme defaults values  **/

add_action('after_setup_theme', 'pixtheme_theme_defaults');
function pixtheme_theme_defaults(){

	// Logo
	update_option( 'pixtheme_default_logo_width', '95' );
	update_option( 'pixtheme_default_logo_height', '115' );

	// Header
    update_option( 'pixtheme_default_header_menu_background', 'main-color' );

	// Colors and Fonts
	update_option( 'pixtheme_default_main_color', '#d5b981' );
	update_option( 'pixtheme_default_gradient_color', '#c4aa77' );
	update_option( 'pixtheme_default_gradient_direction', 'to right' );
	update_option( 'pixtheme_default_additional_color', '#d5b981' );
    update_option( 'pixtheme_default_black_color', '#333333' );

	update_option( 'pixtheme_default_fonts', '{"713":"Rufina:400,700","710":"Rubik:400,500,700,700i"}');
	update_option( 'pixtheme_default_fonts_embed', 'Rufina:400,700|Rubik:400,500,700,700i');

	update_option( 'pixtheme_default_font', 'Rubik' );
	update_option( 'pixtheme_default_font_weight', '400' );
	update_option( 'pixtheme_default_font_size', '15' );
	update_option( 'pixtheme_default_font_color', '#797979' );

	update_option( 'pixtheme_default_title_font', 'Rufina' );
	update_option( 'pixtheme_default_title_weight', '400' );
	update_option( 'pixtheme_default_title_size', '34' );
	update_option( 'pixtheme_default_title_color', '#000000' );

	update_option( 'pixtheme_default_subtitle_font', 'Rufina' );
	update_option( 'pixtheme_default_subtitle_weight', '400' );
	update_option( 'pixtheme_default_subtitle_size', '16' );
	update_option( 'pixtheme_default_subtitle_color', '#333333' );

	update_option( 'pixtheme_default_link_font', 'Rubik' );
	update_option( 'pixtheme_default_link_weight', '700' );
	update_option( 'pixtheme_default_link_size', '18' );
	update_option( 'pixtheme_default_link_color', '#333333' );

	update_option( 'pixtheme_default_button_font', 'Rubik' );
	update_option( 'pixtheme_default_button_font_size', '14' );
	update_option( 'pixtheme_default_button_font_weight', '500' );

	// Header Title and Breadcrumbs
	update_option( 'pixtheme_default_tab_bg_color', '#191919' );
	update_option( 'pixtheme_default_tab_bg_color_gradient', '#303030' );
	update_option( 'pixtheme_default_tab_gradient_direction', 'to top left' );
	update_option( 'pixtheme_default_tab_bg_opacity', '80' );
	update_option( 'pixtheme_default_tab_padding_top', '170' );
	update_option( 'pixtheme_default_tab_padding_bottom', '120' );
    update_option( 'pixtheme_default_tab_margin_bottom', '100' );

	update_option( 'pixtheme_default_decor', '1' );

}

add_filter( 'pixtheme_header_settings', 'pixtheme_header_settings_var' );
function pixtheme_header_settings_var( $post_ID=0 ){

	/// Header global parameters
    $cutstyle['header_type'] = pixtheme_get_option('header_type', 'header1');
    $cutstyle['header_background'] = pixtheme_get_option('header_background', 'black');
    $cutstyle['header_transparent'] = pixtheme_get_option('header_transparent', '0');
    $cutstyle['top_bar_background'] = pixtheme_get_option('top_bar_background', 'black');
    $cutstyle['top_bar_transparent'] = pixtheme_get_option('top_bar_transparent', '100');
    $cutstyle['header_layout'] = pixtheme_get_option('header_layout', 'container');
    $cutstyle['header_bar'] = pixtheme_get_option('header_bar', '0');
    $cutstyle['header_sticky'] = pixtheme_get_option('header_sticky', 'sticky');


    /// Header menu settings
    $cutstyle['header_menu'] = pixtheme_get_option('header_menu', '1');

    /// Header widgets
    $cutstyle['header_minicart'] = pixtheme_get_option('header_minicart', '1');
    $cutstyle['header_search'] = pixtheme_get_option('header_search', '1');
    $cutstyle['header_socials'] = pixtheme_get_option('header_socials', '1');
    $cutstyle['header_button'] = pixtheme_get_option('header_button', '0');

    $cutstyle['header_phone'] = pixtheme_get_option('header_phone', '');
    $cutstyle['header_email'] = pixtheme_get_option('header_email', '');

    /// Responsive
    $cutstyle['mobile_sticky'] = pixtheme_get_option('mobile_sticky', '');
    $cutstyle['mobile_topbar'] = pixtheme_get_option('mobile_topbar', '');
    $cutstyle['tablet_minicart'] = pixtheme_get_option('tablet_minicart', '');
    $cutstyle['tablet_search'] = pixtheme_get_option('tablet_search', '');
    $cutstyle['tablet_phone'] = pixtheme_get_option('tablet_phone', '');
    $cutstyle['tablet_socials'] = pixtheme_get_option('tablet_socials', '');


    /// Logo
    $cutstyle['logo'] = pixtheme_get_option('general_settings_logo', '');
    $cutstyle['logo_mobile'] = pixtheme_get_option('general_settings_logo_mobile', '');


	return $cutstyle;
	
}