<?php

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

function pixtheme_import_files() {
    return array(
        array(
            'import_file_name'           => esc_html__( 'CutStyle', 'cutstyle' ),
            'import_file_url'            => esc_url('https://data.true-emotions.studio/themes/cutstyle/cutstyle.xml'),
            'import_widget_file_url'     => '',
            'import_customizer_file_url' => esc_url('https://data.true-emotions.studio/themes/cutstyle/cutstyle.dat'),
            'import_preview_image_url'   => esc_url('https://data.true-emotions.studio/themes/cutstyle/cutstyle.jpg'),
            'preview_url'                => esc_url('https://cutstyle.true-emotions.studio/'),
        ),
        array(
            'import_file_name'           => esc_html__( 'Dark Beard', 'cutstyle' ),
            'import_file_url'            => esc_url('https://data.true-emotions.studio/themes/cutstyle/cutstyle-darkbeard.xml'),
            'import_widget_file_url'     => '',
            'import_customizer_file_url' => esc_url('https://data.true-emotions.studio/themes/cutstyle/cutstyle-darkbeard.dat'),
            'import_preview_image_url'   => esc_url('https://data.true-emotions.studio/themes/cutstyle/cutstyle-darkbeard.jpg'),
            'preview_url'                => esc_url('https://cutstyle.true-emotions.studio/dark-beard'),
        ),

    );
}
add_filter( 'pt-ocdi/import_files', 'pixtheme_import_files' );

function pixtheme_after_import( $selected_import ) {

    $menu_arr = array();
    $main_menu = get_term_by('name', 'Main', 'nav_menu');
    if(is_object($main_menu))
        $menu_arr['primary_nav'] = $main_menu->term_id;
    $second_menu = get_term_by('name', 'Secondary', 'nav_menu');
    if(is_object($second_menu))
        $menu_arr['secondary_nav'] = $second_menu->term_id;
    set_theme_mod( 'nav_menu_locations', $menu_arr );

    if ( 'CutStyle' === $selected_import['import_file_name'] ) {
        $slider_array = array(get_template_directory()."/pixtheme/install/revslider/Barber.zip");
        set_theme_mod( 'pixtheme_footer_block', '2814' );
    } elseif ( 'Dark Beard' === $selected_import['import_file_name'] ) {
        $slider_array = array(get_template_directory()."/pixtheme/install/revslider/DarkBeard.zip");
        set_theme_mod( 'pixtheme_footer_block', '1936' );
    } else {
        $slider_array = array(get_template_directory()."/pixtheme/install/revslider/Barber.zip");
        set_theme_mod( 'pixtheme_footer_block', '3014' );
    }

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

    $absolute_path = __FILE__;
    $path_to_file = explode( 'wp-content', $absolute_path );
    $path_to_wp = $path_to_file[0];

    require_once( $path_to_wp.'/wp-load.php' );
    require_once( $path_to_wp.'/wp-includes/functions.php');

    $slider = new RevSlider();

    foreach($slider_array as $filepath){
        $slider->importSliderFromPost(true,true,$filepath);
    }

    if(function_exists('vc_set_default_editor_post_types')){
        $vc_list = array(
            'page',
            'post',
            'product',
            'portfolio',
            'services',
            'pixteam',
            'pixsections',
        );
        vc_set_default_editor_post_types( $vc_list );
    }

}
add_action( 'pt-ocdi/after_import', 'pixtheme_after_import' );

?>