<?php
/**
 * The Template for displaying all single posts.
 */
$pixtheme_custom =  get_post_custom(get_queried_object()->ID);
$pixtheme_layout = isset ($pixtheme_custom['pix_page_layout']) ? $pixtheme_custom['pix_page_layout'][0] : '2';
$pixtheme_sidebar = isset ($pixtheme_custom['pix_selected_sidebar'][0]) ? $pixtheme_custom['pix_selected_sidebar'][0] : 'sidebar-1';

if ( ! is_active_sidebar($pixtheme_sidebar) ) $pixtheme_layout = '1';

get_header();

?>
<section class="blog">
	<div class="container">
		<div class="row">
		<?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>
			<div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12<?php else : ?>col-lg-8<?php endif; ?> col-md-12 col-sm-12 col-xs-12 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?>">
                <section class="blog-article">
                <?php
                    // Start the loop.
                    while ( have_posts() ) : the_post();

                        /*
                         * Include the post format-specific template for the content. If you want to
                         * use this in a child theme, then include a file called called content-___.php
                         * (where ___ is the post format) and that will be used instead.
                         */
                        get_template_part( 'templates/post-single/content', get_post_format() );

                        // End the loop.
                    endwhile;
                ?>
                </section>
			</div>
		<?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>
		</div>
	</div>
</section>

<?php get_footer();?>
