<?php
/*** The template for displaying portfolio categories. ***/

get_header();

$pixtheme_layout = pixtheme_get_option('portfolio_settings_sidebar_type', '1');
$pixtheme_sidebar = pixtheme_get_option('portfolio_settings_sidebar_content', 'sidebar-1');

if ( ! is_active_sidebar($pixtheme_sidebar) ) $pixtheme_layout = '1';

$pixtheme_portfolio_perrrow = pixtheme_get_option('portfolio_settings_perrow', '3');
if ( $pixtheme_portfolio_perrrow == '3' ) {
	$pixtheme_add_class_port_col = 'col-md-4 col-sm-4 col-xs-6';
}
elseif ( $pixtheme_portfolio_perrrow == '4' ) {
	$pixtheme_add_class_port_col = 'col-md-3 col-sm-4 col-xs-6';
}
else {
	$pixtheme_add_class_port_col = 'col-md-6 col-sm-6 col-xs-6';
}

$pixtheme_portfolio_perrow = pixtheme_get_option('portfolio_settings_perrow', '3');
$pixtheme_portfolio_css_animation = ( pixtheme_get_option('css_animation_settings_portfolio', '') != '' ) ? ' wow '.pixtheme_get_option('css_animation_settings_portfolio', '') : '';
$pixtheme_portfolio_type = pixtheme_get_option('portfolio_settings_type', 'type_without_icons');
$pixtheme_portfolio_loadmore = pixtheme_get_option('portfolio_settings_loadmore', esc_html__('Load more', 'cutstyle' ) );

$pixtheme_portfolio_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

?>

<!-- ========================== -->
<!-- BLOG - CONTENT -->
<!-- ========================== -->
<section class="page-content taxonomy-page">
    <div class="container">
        <div class="services">
            <div class="row">

			<?php pixtheme_show_sidebar( 'left', $pixtheme_layout, $pixtheme_sidebar ); ?>

			<div class="<?php if ( $pixtheme_layout == 1 ) : ?>col-lg-12 col-md-12<?php else : ?>col-lg-9 col-md-8<?php endif; ?> col-sm-12 col-xs-12 left-column sidebar-type-<?php echo esc_attr($pixtheme_layout); ?>">

				<div id="portfolio-category-section" class="portfolio-perrow-<?php echo esc_attr($pixtheme_portfolio_perrow); ?>">

				<?php $pixtheme_portfolio_category_description = get_term_field( 'description', $pixtheme_portfolio_term->term_id, 'portfolio_category' );
				if( !is_wp_error( $pixtheme_portfolio_category_description ) && $pixtheme_portfolio_category_description != '' ) :
				?>
					<div class="section-heading text-center">
						<div class="section-subtitle"><?php echo wp_kses_post($pixtheme_portfolio_category_description);?></div>
						<div class="design-arrow"></div>
					</div>

				<?php
				endif;

                $pixtheme_portfolio_categories = get_objects_in_term( $pixtheme_portfolio_term->term_id, 'portfolio_category');

                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args = array(
                    'post_type' => 'portfolio',
                    'orderby' => array( 'menu_order' => 'ASC', 'date' => 'DESC' ),
                    'post__in' => $pixtheme_portfolio_categories,
                    'posts_per_page' => -1,
                    //'paged' => $paged
                );

                $wp_query = new WP_Query( $args );

                if ( $wp_query->have_posts() ) : ?>

                    <?php
                    while ( $wp_query->have_posts() ) :
                        $wp_query->the_post();

                        $pixtheme_portfolio_post_type = ( class_exists( 'RW_Meta_Box' ) && rwmb_meta('post_types_select') != '' ) ? rwmb_meta('post_types_select') : 'image';

                        $cats = wp_get_object_terms(get_the_id(), 'portfolio_category');
                        $pixtheme_cat_slugs = '';
                        if ( ! empty($cats) ) {
                            foreach ( $cats as $cat ) {
                                $pixtheme_cat_slugs .= $cat->slug . " ";
                            }
                        }
                        $pixtheme_portfolio_thumbnail = get_the_post_thumbnail(get_the_ID(), 'pixtheme-portfolio-thumb', array('class' => 'img-responsive pix-img-greyscale'));
                        $pixtheme_portfolio_thumbnail_full = get_the_post_thumbnail_url(get_the_ID(), 'full');

                        // potfolio category list linked
                        $pixtheme_portfolio_linked_list_cats = pixtheme_get_post_terms( array( 'taxonomy' => 'portfolio_category', 'items_wrap' => '%s' ) );

                        ?>

                            <div class="person__item">
                                <div class="person__item-container">
                                    <a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>">
                                        <div class="person__item-overlay"></div>
                                        <?php echo wp_kses_post($pixtheme_portfolio_thumbnail); ?>
                                    </a>
                                </div>
                                <h3><a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo wp_kses_post( get_the_title() ); ?></a></h3>
                                <span><?php echo wp_kses_post($pixtheme_portfolio_linked_list_cats); ?></span>
                            </div>

                        <?php

                    endwhile; ?>
                    </div>

                    <?php
//                    if ( get_next_posts_link( '', $wp_query->max_num_pages ) ) {
//
//                        echo '
//                            <div class="row">
//                                <div class="col-md-12 text-center">
//                                    <div class="portfolio-pagination">
//                                        <span data-current="'.esc_attr($paged).'" data-max-pages="'.esc_attr($wp_query->max_num_pages).'" class="load-more">' . get_next_posts_link( wp_kses_post($pixtheme_portfolio_loadmore), $wp_query->max_num_pages) . '</span>
//                                    </div>
//                                    <div class="portfolio-pagination-loading">
//                                        <a href="javascript: void(0)" class="btn btn-default">'. esc_html__("Loading...", "cutstyle") .'</a>
//                                    </div>
//                                </div>
//                            </div>
//                        ';
//                    }
                    ?>

                <?php
                endif;
				?>

			</div>

			<?php pixtheme_show_sidebar( 'right', $pixtheme_layout, $pixtheme_sidebar ); ?>

            </div>
		</div>
	</div>
</section>

<?php get_footer(); ?>