<?php /* Header Type 3 */
	$post_ID = isset ($wp_query) ? $wp_query->get_queried_object_id() : get_the_ID();
	if( class_exists( 'WooCommerce' ) && pixtheme_is_woo_page() && pixtheme_get_option('woo_header_global','1') ){
		$post_ID = get_option( 'woocommerce_shop_page_id' ) ? get_option( 'woocommerce_shop_page_id' ) : $post_ID;
	} elseif (!is_page_template('page-home.php') && get_option('page_for_posts') && pixtheme_get_option('header_like_blog','0')){
		$post_ID = get_option('page_for_posts') ? get_option('page_for_posts') : 0;
	}

	$pixtheme_header = apply_filters('pixtheme_header_settings', $post_ID);
	$pixtheme_header['header_background'] = $pixtheme_header['header_background'] == '' ? 'white' : $pixtheme_header['header_background'];
	$pixtheme_header_transparent = $pixtheme_header['header_transparent'] < 100 ? 'transparent' : '';
	$pixtheme_logo = $pixtheme_header['header_background'] == 'black' ? $pixtheme_header['logo'] : $pixtheme_header['logo_inverse'];
	$pixtheme_header['top_bar_background'] = $pixtheme_header['top_bar_background'] == '' ? 'black' : $pixtheme_header['top_bar_background'];
	$pixtheme_top_bar_transparent = $pixtheme_header['top_bar_transparent'] < 100 ? 'transparent' : '';

	$pixtheme_logo_stl = pixtheme_get_option('general_settings_logo_width', get_option('pixtheme_default_logo_width')) != '' ? 'width:'.esc_attr(pixtheme_get_option('general_settings_logo_width', get_option('pixtheme_default_logo_width'))).'px;' : '';
	$pixtheme_logo_stl = $pixtheme_logo_stl != '' ? 'style="'.($pixtheme_logo_stl).'"' : '';

	$pixtheme_logo_text = pixtheme_get_option('general_settings_logo_text') != '' ? '<div class="logo-text">'.wp_kses_post(pixtheme_get_option('general_settings_logo_text')).'</div>' : '';

?>

	<header class="pix-header menu-aroundblock pix-levels <?php echo esc_attr($pixtheme_header['header_background']) ?> <?php echo esc_attr( $pixtheme_header_transparent ) ?> <?php echo esc_attr($pixtheme_header['header_sticky']) ?>
    <?php if ($pixtheme_header['header_bar']) : ?>
	    header-topbar-view
    <?php endif; ?>
    ">
    <?php if ($pixtheme_header['header_bar']) : ?>
        <div class="pix-top-bar <?php echo esc_attr($pixtheme_header['top_bar_background']) ?> <?php echo esc_attr( $pixtheme_top_bar_transparent ) ?>">
            <div class="<?php echo esc_attr($pixtheme_header['header_layout']) ?>">
                <div class="header-topbarbox-1">
                    <ul>
                        <?php if ($pixtheme_header['header_phone']) : ?>
                            <li class="no-hover header-phone"><?php echo wp_kses_post(pixtheme_get_option('header_phone', '')) ?> </li>
                        <?php endif; ?>
                        <?php if ($pixtheme_header['header_email']) : ?>
                            <li><?php echo wp_kses_post(pixtheme_get_option('header_email', '')) ?></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="header-topbarbox-2">
                    <?php
                    if ( has_nav_menu( 'top_nav' ) ) {
                        wp_nav_menu(array(
                            'theme_location'  => 'top_nav',
                            'container'       => false,
                            'menu_id'		  => 'top-menu',
                            'menu_class'      => '',
                            'depth'           => 1
                        ));
                    }
                    ?>
                    <?php if ( $pixtheme_header['header_socials'] ) : ?>
                        <ul class="header-socials hidden-xs">
                        <?php if (pixtheme_get_option('social_facebook', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_facebook', '')); ?>"
                                                              target="_blank"><i class="icon-social-facebook"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_vk', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_vk', '')); ?>"
                                                              target="_blank"><i class="icon-social-vkontakte"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_youtube', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_youtube', '')); ?>"
                                                              target="_blank"><i class="icon-social-youtube"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_vimeo', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_vimeo', '')); ?>"
                                                              target="_blank"><i class="fa fa-vimeo"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_twitter', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_twitter', '')); ?>"
                                                              target="_blank"><i class="icon-social-twitter"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_google', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_google', '')); ?>"
                                                              target="_blank"><i class="icon-social-google"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_tumblr', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_tumblr', '')); ?>"
                                                              target="_blank"><i class="icon-social-tumblr"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_instagram', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_instagram', '')); ?>"
                                                              target="_blank"><i class="icon-social-instagram"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_pinterest', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_pinterest', '')); ?>"
                                                              target="_blank"><i class="icon-social-pinterest"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_linkedin', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_linkedin', '')); ?>"
                                                              target="_blank"><i class="icon-social-linkedin"></i></a></li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_custom_url_1', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_custom_url_1', '')); ?>"
                                                              target="_blank"><i
                                            class="fa <?php echo esc_attr(pixtheme_get_option('social_custom_icon_1', '')); ?>"></i></a>
                            </li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_custom_url_2', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_custom_url_2', '')); ?>"
                                                              target="_blank"><i
                                            class="fa <?php echo esc_attr(pixtheme_get_option('social_custom_icon_2', '')); ?>"></i></a>
                            </li>
                        <?php } ?>
                        <?php if (pixtheme_get_option('social_custom_url_3', '')) { ?>
                            <li class="header-social-link"><a href="<?php echo esc_url(pixtheme_get_option('social_custom_url_3', '')); ?>"
                                                              target="_blank"><i
                                            class="fa <?php echo esc_attr(pixtheme_get_option('social_custom_icon_3', '')); ?>"></i></a>
                            </li>
                        <?php } ?>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
		<div class="<?php echo esc_attr($pixtheme_header['header_layout']) ?>">
		    <div class="row">
		        <div class="col">
                    <nav class="pix-text-left">
                        <ul class="main-menu-elements">
                        <?php if ( $pixtheme_header['header_search'] ) : ?>
                            <li id="js-search-container" class="search">
                                <a><i class="icon-magnifier"></i></a>
                            </li>
                        <?php endif; ?>

                        <?php if (class_exists('WooCommerce') && $pixtheme_header['header_minicart'] && isset($pixtheme_header['header_button']) && $pixtheme_header['header_button']) : ?>
                            <li class="cart">
                                <a href="<?php echo wc_get_cart_url(); ?>">
                                    <div class="pix-cart-items">
                                        <?php echo WC()->cart->cart_contents_count > 0 ? '<i class="icon-basket-loaded"></i>' : '<i class="icon-basket"></i>'; ?>
                                        <span class="pix-cart-count"><?php echo WC()->cart->cart_contents_count; ?></span>
                                    </div>
                                </a>
                            </li>
                        <?php endif; ?>
                        </ul>
                    </nav>
                </div>

                <div class="col-6">
                    <div class="menu-logo">
                        <a class="navbar-brand scroll" href="<?php echo esc_url(home_url('/')) ?>" <?php echo wp_kses_post($pixtheme_logo_stl)?>>
                            <?php if ($pixtheme_logo): ?>
                                <img class="normal-logo"
                                     src="<?php echo esc_url($pixtheme_logo) ?>"
                                     alt="<?php esc_attr_e('Logo', 'cutstyle') ?>"/>
                            <?php else: ?>
                                <img class="normal-logo"
                                     src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="<?php esc_attr_e('Logo', 'cutstyle') ?>"/>
                            <?php endif ?>
                        </a>
                        <?php echo wp_kses_post($pixtheme_logo_text); ?>
                    </div>
                </div>

                <div class="col">
                    <nav class="pix-text-right">
                        <ul class="main-menu-elements">
                            <?php if ( $pixtheme_header['header_search'] && (!class_exists('WooCommerce') || !$pixtheme_header['header_minicart']) ) : ?>
                            <li id="js-search-container" class="search">
                                <a><i class="icon-magnifier"></i></a>
                            </li>
                            <?php endif; ?>

                            <?php if (class_exists('WooCommerce') && $pixtheme_header['header_minicart'] && (!isset($pixtheme_header['header_button']) || !$pixtheme_header['header_button']) ) : ?>
                            <li class="cart">
                                <a href="<?php echo wc_get_cart_url(); ?>">
                                    <div class="pix-cart-items">
                                        <?php echo WC()->cart->cart_contents_count > 0 ? '<i class="icon-basket-loaded"></i>' : '<i class="icon-basket"></i>'; ?>
                                        <span class="pix-cart-count"><?php echo WC()->cart->cart_contents_count; ?></span>
                                    </div>
                                </a>
                            </li>
                            <?php endif; ?>

                            <?php if ( isset($pixtheme_header['header_button']) && $pixtheme_header['header_button'] ) : ?>
                            <li class="js-addmenu">
                                <a class="pix-button pix-h-s pix-v-s" href="<?php echo esc_url(pixtheme_get_option('header_button_link')) ?>"><?php echo wp_kses_post(pixtheme_get_option('header_button_text', esc_html__('Appointment', 'cutstyle'))) ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                    <?php if ( $pixtheme_header['header_search'] ) : ?>
                    <div class="search-container">
                        <div class="input-container">
                            <form method="get" id="searchform" class="searchform" action="<?php echo esc_url(site_url()) ?>">
                                <div>
                                    <input type="text" placeholder="<?php esc_attr_e('Search', 'cutstyle');?>" value="<?php esc_attr(the_search_query()); ?>" name="s" id="search">
                                    <input type="submit" id="searchsubmit" value="">
                                </div>
                            </form>
                        </div>
                        <a class="pix-search-close"><i class="icon-close"></i></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
		        <div class="col">
                    <nav class="pix-text-center">
                    <?php echo pixtheme_site_menu('main-menu nav navbar-nav'); ?>
                    </nav>
                </div>
            </div>
		</div>
	</header>
