<?php
/**
 * This template is for displaying part of blog.
 *
 * @package Pix-Theme
 * @since 1.0
 */
$pixtheme_cat = '';
if( pixtheme_get_option('blog_settings_category', 1) ){
    $pixtheme_categories = get_the_category(get_the_ID());
    if($pixtheme_categories){
        foreach($pixtheme_categories as $category) {
            $pixtheme_cat .= '<a href="'.esc_url(get_category_link( $category->term_id )).'">'.wp_kses_post($category->cat_name).'</a>, ';
        }
        $pixtheme_cat = substr($pixtheme_cat, 0, -2);
    }
}
    if(pixtheme_get_option('blog_settings_type', 'classic') == 'grid') :
?>
    <h2><a href="<?php esc_url(the_permalink()) ?>"><?php wp_kses_post(the_title()) ?></a></h2>
    <?php the_excerpt(); ?>
    <div class="article-info">
        <div class="left">
            <?php if (pixtheme_get_option('blog_settings_date', 1)) : ?>
                <span class="article-info__date"><a href="<?php echo esc_url(get_the_permalink()) ?>"><?php echo wp_kses_post(get_the_date()) ?></a></span>
            <?php endif ?>
        </div>
        <div class="right">
            <?php if (pixtheme_get_option('blog_settings_category', 1) && !empty($pixtheme_cat)) : ?>
                <span class="article-info__categories"> <?php echo wp_kses_post($pixtheme_cat) ?> </span>
            <?php endif ?>
        </div>
    </div>
<?php
    else :
?>
    <div class="article-head">
		<h2><a href="<?php esc_url(the_permalink()); ?>"><?php the_title(); ?></a></h2>
		<div class="post__meta">
            <?php if ( pixtheme_get_option( 'blog_settings_date', 'on' ) == 'on' ) : ?>
                <span><i class="icon-calendar"></i><a href="<?php esc_url(the_permalink()); ?>"><?php echo sprintf( '<span>%s</span>', esc_attr( get_the_date() ) ); ?></a></span>
            <?php endif; ?>
            <?php if (pixtheme_get_option('blog_settings_category', 1) && !empty($pixtheme_cat)) : ?>
                <span class="article-info__categories"><i class="icon-folder-alt"></i><?php echo wp_kses_post($pixtheme_cat) ?> </span>
            <?php endif ?>
			<?php if ( pixtheme_get_option( 'blog_settings_author', 'on' ) == 'on' ) : ?>
				<span class="author"><i class="icon-user"></i><?php the_author_posts_link(); ?></span>
			<?php endif; ?>
			<?php if ( comments_open() ) : ?>
			<span><i class="icon-bubbles"></i><?php comments_popup_link( esc_html__( 'Post a Comment', 'cutstyle' ), esc_html__( '1 comment', 'cutstyle' ), esc_html__( '% comments', 'cutstyle' ), "comments-link"); ?></span>
			<?php endif; ?>

		</div>
	</div>
    <div class="article-title">

        <?php
        $args_pl = array(
            'before'           => '<p class="pix-link-pages"><span>'.esc_html__('Pages:', 'cutstyle').'</span>',
            'after'            => '</p>'
        );
        wp_link_pages($args_pl);
        ?>

        <div class="rtd">
            <?php
            if( get_option('rss_use_excerpt') == 0 && !is_search() ) {
                the_content();
            } else {
                the_excerpt();
            }
            ?>
        </div>

    </div>
<?php
    endif;
