<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $type
 * @var $icon_pixelegant
 * @var $icon_pixflaticon
 * @var $icon_pixicomoon
 * @var $icon_pixfontawesome
 * @var $icon_pixsimple
 * @var $icon_fontawesome
 * @var $icon_openiconic
 * @var $icon_typicons
 * @var $icon_entypo
 * @var $icon_linecons
 * @var $title
 * @var $link
 * @var $spin
 * @var $color
 * @var $position
 * @var $show_decor
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Common_Icon_Box
 */
$css_animation = $icon_type = $icon = $icon_shape = $href_container_before = $href_container_after = $href_before = $href_after = $hover_class = $content_position = '';
$link_overlay = 'on';
$icon_size = 'pix-icon-l';
$icon_color = 'pix-icon-color';
$position = $position_with_center = $position_no_center = 'pix-text-left';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$shadows_arr = pixtheme_vc_get_params_array($atts, 'shadow');
extract( $atts );

$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );

$href = vc_build_link( $link );

$style = !isset($style) || $style == '' ? 'pix-item-left' : $style;
$shadow_class = pixtheme_get_shadow($shadows_arr);

if($style != 'pix-item-review'){
    $position = $position_with_center;
} else {
    $position = $position_no_center;
}

if($icon_type == 'font')
    $icon = isset( ${"icon_" . $type} ) ? ${"icon_" . $type} : '';
$target = empty($href['target']) ? '' : 'target="'.esc_attr($href['target']).'"';
$class_text = in_array($style, array('pix-item-review')) ? 'text '.esc_attr($content_position) : '';
if(!empty( $href['url'] )){
    if($btn_txt == '' && $link_overlay == 'on') {
        $href_container_before = '<a ' . wp_kses_post($target) . ' href="' . esc_url($href['url']) . '">';
        $href_container_after = '</a>';
    } else {
        $href_before = '<a ' . wp_kses_post($target) . ' href="' . esc_url($href['url']) . '">';
        $href_after = '</a>';
        $hover_class = 'pix-icon-hover';
    }
}
if($icon_type == 'svg' && isset($image) && $image != ''){
    $img_id = preg_replace( '/[^\d]/', '', $image );
    $img_path = get_attached_file( $img_id );
    if( function_exists('pix_get_svg_content')){
        $show_icon = '<div class="icon">'.wp_kses_post($href_before).pix_get_svg_content($img_path).wp_kses_post($href_after).'</div>';
    } else {
        $img_path = wp_get_attachment_image_src( $img_id );
	    $show_icon = '<div class="icon">'.wp_kses_post($href_before).'<img src="'.esc_url($img_path[0]).'" alt="'.esc_attr($title).'">'.wp_kses_post($href_after).'</div>';
    }

} elseif($icon_type == 'image' && isset($image) && $image != ''){
	$img_id = preg_replace( '/[^\d]/', '', $image );
    $img_path = wp_get_attachment_image_src( $img_id, 'thumbnail' );
	$show_icon = '<div class="icon">'.wp_kses_post($href_before).'<img src="'.esc_url($img_path[0]).'" alt="'.esc_attr($title).'">'.wp_kses_post($href_after).'</div>';
} else {
	$show_icon = '<div class="icon">'.wp_kses_post($href_before).'<span class="'.esc_attr($icon).'" ></span>'.wp_kses_post($href_after).'</div>';
}

if(isset($bg_image) && $bg_image != ''){
    $bg_img_id = preg_replace( '/[^\d]/', '', $bg_image );
    $bg_img_path = wp_get_attachment_image_src( $bg_img_id, array(555,555) );
    $bg_image = $bg_img_path[0];
}

$final_title = empty( $title ) ? '' : '<h2>'.wp_kses_post($title).'</h2>';
$final_content = ($content == '') ? '' : '<p>'.do_shortcode($content).'</p>';
$final_btn = ($btn_txt == '') ? '' : '<a href="'.esc_url($href['url']).'" class="pix-button" '.wp_kses_post($target).'>'.wp_kses_post($btn_txt).'</a>';



$animate = $animate_data = '';
if($css_animation != '') {
	$animate = 'animated';
	$animate .= !empty($wow_duration) || !empty($wow_delay) || !empty($wow_offset) || !empty($wow_iteration) ? ' wow ' . esc_attr($css_animation) : '';
	$animate_data .= 'data-animation="'.esc_attr($css_animation).'"';
	$animate_data .= !empty($wow_duration) ? ' data-wow-duration="'.esc_attr($wow_duration).'s"' : '';
	$animate_data .= !empty($wow_delay) ? ' data-wow-delay="'.esc_attr($wow_delay).'s"' : '';
	$animate_data .= !empty($wow_offset) ? ' data-wow-offset="'.esc_attr($wow_offset).'"' : '';
	$animate_data .= !empty($wow_iteration) ? ' data-wow-iteration="'.esc_attr($wow_iteration).'"' : '';
}

$out = '<div class="' . esc_attr($css_class) . ' '.esc_attr($shadow_class).' '.esc_attr($radius).' '.esc_attr($animate).'" '.wp_kses_post($animate_data).'>';

$out .= wp_kses_post($href_container_before).'
		<div class="'.esc_attr($style).' '.esc_attr($position).'">';

if($style == 'pix-item-review' && $position_no_center == 'pix-text-review-right'){
    $out .= '
            <div class="pix-block-content">
                <div class="'.esc_attr($class_text).'">
                    '.wp_kses_post($final_title).'
                    '.wp_kses_post($final_content).'
                    '.wp_kses_post($final_btn).'
                </div>
                <div class="'.esc_attr($icon_shape).' '.esc_attr($icon_size).' '.esc_attr($hover_class).'">'.($show_icon).'</div>
            </div>';
} elseif($style == 'pix-item-flip'){
        if(isset($flip) && $flip == 'on'){
            $out .= '
                    <div class="pix-icon-box-flip flip">
                        <div class="service-box-3">
                            <div class="service-box-3__container '.esc_attr($icon_size).'">
                                <div class="icon '.esc_attr($icon_color).' ">'.($show_icon).'</div>
                                '.wp_kses_post($final_title).'
                            </div>
                            <img src="'.esc_url($bg_image).'" alt="'.esc_attr($title).'">
                        </div>
                        <div class="service-box-3 under">
                            '.wp_kses_post($href_before).'
                            <div class="service-box-3__container two">
                                '.wp_kses_post($final_title).'
                                '.wp_kses_post($final_content).'
                            </div>
                            '.wp_kses_post($href_after).'
                            <img src="'.esc_url($bg_image).'" alt="'.esc_attr($title).'">
                        </div>
                    </div>';
        } else {
            $out .= '
                    <div class="pix-icon-box-flip">
                        <div class="service-box-3">
                            '.wp_kses_post($href_before).'
                            <div class="service-box-3__container '.esc_attr($icon_size).'">
                                <div class="icon '.esc_attr($icon_color).' ">'.($show_icon).'</div>
                                '.wp_kses_post($final_title).'
                            </div>
                            '.wp_kses_post($href_after).'
                            <img src="'.esc_url($bg_image).'" alt="'.esc_attr($title).'">
                        </div>
                    </div>';
        }
} else {
    $out .= '
            <div class="pix-overlay pix-color"></div>
            <div class="pix-block-content">
                <div class="'.esc_attr($icon_shape).' '.esc_attr($icon_size).' '.esc_attr($icon_color).' '.esc_attr($hover_class).'">'.($show_icon).'</div>
                <div class="'.esc_attr($class_text).'">
                    '.wp_kses_post($final_title).'
                    '.wp_kses_post($final_content).'
                    '.wp_kses_post($final_btn).'
                </div>
			</div>';
}
$out .= '
		</div>
		'.wp_kses_post($href_container_after);

$out .= '</div>'.$this->endBlockComment('common_icon_box');

if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}