<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $typetable
 * @var $monthtext
 * @var $yeartext
 * @var $monthshort
 * @var $yearshort
 * @var $currency
 * Shortcode class
 * @var $this WPBakeryShortCode_Section_Price_Table
 */
$btntext = $radius = '';
$shadows_arr = array();

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$shadows_arr = pixtheme_vc_get_params_array($atts, 'shadow');
extract( $atts );

$style = !isset($style) || $style == '' ? 'news-card-price' : $style;

$shadow_class = pixtheme_get_shadow($shadows_arr);

$prices = vc_param_group_parse_atts( $atts['prices'] );
$prices_out_1 = $prices_out_2 = array();
$count = 1;
$cnt = count($prices);

foreach($prices as $key => $item){

    $image = '';

    $class = isset($item['ispopular']) && $item['ispopular'] == 'on' ? 'pix-dark' : '';

    $href = isset($item['link']) ? vc_build_link( $item['link'] ) : '';
    $url = empty($href['url']) ? '#' : $href['url'];
    $target = empty($href['target']) ? '' : 'target="'.esc_attr($href['target']).'"';
    $icon_type = $item['type'];
    $icon = isset( $item['icon_'.$icon_type] ) ? $item['icon_'.$icon_type] : '';
    if($item['icon_type'] == 'svg' && isset($item['image']) && $item['image'] != ''){
        $img_id = preg_replace( '/[^\d]/', '', $item['image'] );
        $img_path = get_attached_file( $img_id );
        if( function_exists('pix_get_svg_content')){
            $show_icon = '<div class="icon-message">'.pix_get_svg_content($img_path).'</div>';
        } else {
            $img_path = wp_get_attachment_image_src( $img_id );
            $show_icon = '<div class="icon-message"><img src="'.esc_url($img_path[0]).'" alt="'.esc_attr($item['title']).'"></div>';
        }
    } elseif($item['icon_type'] == 'image' && isset($item['image']) && $item['image'] != ''){
        $img_id = preg_replace( '/[^\d]/', '', $item['image'] );
        $img_path = wp_get_attachment_image_src( $img_id, 'thumbnail' );
        $show_icon = '<div class="icon-message"><img src="'.esc_url($img_path[0]).'" alt="'.esc_attr($item['title']).'"></div>';
    } else {
        $show_icon = '<div class="icon-message"><span class="' . esc_attr( $icon ) . '" ></span></div>';
    }
    $title = isset($item['title']) && $item['title'] != '' ? '<h2>'.wp_kses_post($item['title']).'</h2>' : '';
    $subtitle = isset($item['subtitle']) && $item['subtitle'] != '' ? '<span>'.wp_kses_post($item['subtitle']).'</span>' : '';
    $first_price = isset($item['first_price']) && $item['first_price'] != '' ? '<h3>'.wp_kses_post($currency).wp_kses_post($item['first_price']).'</h3>' : '';
    $second_price = isset($item['second_price']) && $item['second_price'] != '' ? '<h3>'.wp_kses_post($currency).wp_kses_post($item['second_price']).'</h3>' : '';
    $button = $btntext != '' && $url != '' ? '<a class="pix-button '.esc_attr($class).'" '.wp_kses_post( $target ).' href="' . esc_url( $url ) . '">'.wp_kses_post( $btntext ).'</a>' : '';
    $price_content = isset($item['price_content']) ? explode("\n", $item['price_content']) : array();
    $price_content_html = '';
    if( count($price_content) > 1 ){
        foreach($price_content as $val){
            if(!empty($val))
                $price_content_html .= '<li>'.wp_kses_post($val).'</li>';
        }
        $price_content_html = '<ul class="pix-table-price-content-list">'.($price_content_html).'</ul>';
    } else {
        $price_content_html = '<p>'.($price_content[0]).'</p>';
    }


    if ($style == 'news-card-price') {
        $prices_out_1[] = '
            <div class="col">
                <div class="news-card-price '.esc_attr($shadow_class).'">
                    <div class="news-card-price__header '.esc_attr($class).'">
                        '.wp_kses_post($title).'
                        '.wp_kses_post($subtitle).'
                    </div>
                    <div class="news-card-price__text">
                        '.wp_kses_post($first_price).'
                        '.wp_kses_post($price_content_html).'
                        '.wp_kses_post($button).'
                    </div>
                </div>
            </div>
        ';
        $prices_out_2[] = '
            <div class="col">
                <div class="news-card-price '.esc_attr($shadow_class).'">
                    <div class="news-card-price__header '.esc_attr($class).'">
                        '.wp_kses_post($title).'
                        '.wp_kses_post($subtitle).'
                    </div>
                    <div class="news-card-price__text">
                        '.wp_kses_post($second_price).'
                        '.wp_kses_post($price_content_html).'
                        '.wp_kses_post($button).'
                    </div>
                </div>
            </div>
        ';
    } else {
        $prices_out_1[] = '
            <div class="col-md-6">
                <div class="news-item-price-long '.esc_attr($shadow_class).'">
                    <div class="news-item-price-long__service '.esc_attr($class).'">
                        <h2>'.wp_kses_post($item['title']).'</h2>
                        '.wp_kses_post($price_content_html).'
                    </div>
                    <div class="news-item-price-long__price">
                        <h2><sup>'.wp_kses_post($currency).'</sup>'.wp_kses_post($item['first_price']).'</h2>
                        '.($show_icon).'
                        '.wp_kses_post($button).'
                    </div>
                </div>
            </div>
        ';
        $prices_out_2[] = '
            <div class="col-md-6">
                <div class="news-item-price-long '.esc_attr($shadow_class).'">
                    <div class="news-item-price-long__service '.esc_attr($class).'">
                        <h2>'.wp_kses_post($item['title']).'</h2>
                        '.wp_kses_post($price_content_html).'
                    </div>
                    <div class="news-item-price-long__price">
                        <h2><sup>'.wp_kses_post($currency).'</sup>'.wp_kses_post($item['second_price']).'</h2>
                        '.($show_icon).'
                        '.wp_kses_post($button).'
                    </div>
                </div>
            </div>
        ';
    }

    $count ++;
}

if($style == 'news-card-price'){
    $select = '';
    if($typetable == 'single'){
        $select = '
            <a price-container="1" class="active">'.wp_kses_post($first_text).'</a>
            <a price-container="2">'.wp_kses_post($second_text).'</a>
        ';
    }
    $out = '
    <section class="pix-'.esc_attr($style).' '.esc_attr($radius).'">
        <div class="'.esc_attr($style).'__select">
            '.($select).'
        </div>
        <div class="row '.esc_attr($style).'__container card-price-container-1">
            '.implode( "\n", $prices_out_1 ).'
        </div>
        <div class="row '.esc_attr($style).'__container card-price-container-2">
            '.implode( "\n", $prices_out_2 ).'
        </div>
    </section>';
} else {
    $select = '';
    if($typetable != 'single'){
        $select = '
            <a price-long-container="1" class="active">'.wp_kses_post($first_text).'</a>
            <a price-long-container="2">'.wp_kses_post($second_text).'</a>
        ';
    }
    $out = '
    <section class="pix-'.esc_attr($style).' '.esc_attr($radius).'">
        <div class="'.esc_attr($style).'__select">
            '.($select).'
        </div>
        <div class="row '.esc_attr($style).'__container price-long-container-1">
            '.implode( "\n", $prices_out_1 ).'
        </div>
        <div class="row '.esc_attr($style).'__container price-long-container-2">
            '.implode( "\n", $prices_out_2 ).'
        </div>
    </section>';
}
 
if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}