<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $reviews_per_page
 * @var $disable_carousel
 * @var $skin
 * @var $autoplay
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Common_Reviews
 */
$carousel_arr = $shadows_arr = array();

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$carousel_arr = pixtheme_vc_get_params_array($atts, 'carousel');
$shadows_arr = pixtheme_vc_get_params_array($atts, 'shadow');
extract( $atts );

$style = !isset($style) || $style == '' ? 'news-card-feedback' : $style;
$shadow_class = pixtheme_get_shadow($shadows_arr);

$reviews = vc_param_group_parse_atts( $atts['reviews'] );
$reviews_out = array();
$count = 1;
$cnt = count($reviews);
foreach($reviews as $key => $item){
    $image = '';

    $class = $count == 1 ? 'active' : '';

    $href = isset($item['link']) ? vc_build_link( $item['link'] ) : '';
    $blank = empty($href['target']) ? '_self' : $href['target'];
    $href = empty($href['url']) ? '#' : $href['url'];


    if( isset($item['image']) && $item['image'] != ''){
        $img = wp_get_attachment_image_src( $item['image'], 'medium' );
        $img_output = $img[0];
        $image = $style == 'news-card-profile' ? '<img src="'.esc_url($img_output).'" alt="'.esc_attr($item['name']).'">' : '<div class="'.esc_attr($style).'__image"><img src="'.esc_url($img_output).'" alt="'.esc_attr($item['name']).'"></div>';
    }
    $position = isset($item['position']) && $item['position'] != '' ? $item['position'] : '';
    $facebook = isset($item['facebook']) && $item['facebook'] != '' ? '<a href="'.esc_url($item['facebook']).'"><i class="icon-social-facebook"></i></a>' : '';
    $twitter = isset($item['twitter']) && $item['twitter'] != '' ? '<a href="'.esc_url($item['twitter']).'"><i class="icon-social-twitter"></i></a>' : '';
    $instagram = isset($item['instagram']) && $item['instagram'] != '' ? '<a href="'.esc_url($item['instagram']).'"><i class="icon-social-instagram"></i></a>' : '';

    if ($style == 'news-card-people') {
        $reviews_out[] = '
            <div class="col-12 pix-animation-container">
                <div class="news-card-people '.esc_attr($shadow_class).'">
                    <div class="pix-overlay pix-color"></div>
                    '.wp_kses_post($image).'
                    <div class="pix-block-content">    
                        <h2>'.wp_kses_post($item['name']).' <span>'.wp_kses_post($position).'</span></h2>
                        <p>'.wp_kses_post($item['content_d']).'</p>
                        '.wp_kses_post($facebook).'
                        '.wp_kses_post($twitter).'
                        '.wp_kses_post($instagram).'
                    </div>
                </div>
            </div>
        ';
    } elseif ($style == 'news-card-profile') {
        $reviews_out[] = '
            <div class="col-12 pix-animation-container">
                <div class="news-card-profile">
                    <div class="news-card-profile__header">
                        <h2><a target="'.esc_attr($blank).'" href="'.esc_url($href).'">'.wp_kses_post($item['name']).'</a></h2>
                        <div class="news-card-profile__header-social">
                            '.wp_kses_post($facebook).'
                            '.wp_kses_post($twitter).'
                            '.wp_kses_post($instagram).'
                            '.wp_kses_post($image).'
                        </div>
                    </div>
                    <div class="news-card-profile__text '.esc_attr($shadow_class).'">
                        '.pixtheme_echo_if_not_empty('<h3>'.wp_kses_post($position).'</h3>', $position).'
                        <p>'.wp_kses_post($item['content_d']).'</p>
                    </div>
                </div>
            </div>
        ';
    } elseif ($style == 'news-card-message') {
        $reviews_out[] = '
            <div class="col-12 pix-animation-container">
                <div class="news-card-message">
                    <div class="news-card-message__text '.esc_attr($shadow_class).'">
                        <h2>'.wp_kses_post($item['name']).'<span>'.wp_kses_post($position).'</span></h2>
                        <p>'.wp_kses_post($item['content_d']).'</p>
                        <div class="pix-border-shadow-overlay"></div>
                    </div>
                    '.wp_kses_post($image).'
                </div>
            </div>
        ';
    } else {
        $reviews_out[] = '
            <div class="news-card-feedback__user '.esc_attr($class).'">
                '.wp_kses_post($image).'
                <h2>'.wp_kses_post($item['name']).' <span>'.wp_kses_post($position).'</span></h2>
                <p>'.wp_kses_post($item['content_d']).'</p>
                '.wp_kses_post($facebook).'
                '.wp_kses_post($twitter).'
                '.wp_kses_post($instagram).'
            </div>
        ';
    }

    $count ++;
}

$options_arr = pixtheme_get_carousel($carousel_arr, 'animate_'.str_replace('-', '_', $style));
$data_carousel = empty($options_arr) ? '' : 'data-owl-options=\''.json_encode($options_arr).'\'';
$col = isset($options_arr['items']) != '' ? $options_arr['items'] : 3;
$carousel_class = !empty($options_arr) ? 'row owl-carousel owl-theme' : 'disable-owl-carousel pix-col-'.esc_attr($col);
$animation_class = !empty($options_arr) && !isset($options_arr['onTranslate']) ? 'animation-off' : '';

if($style == 'news-card-feedback'){
    $out = '
    <div class="col-md-10 col-offset-1 offset-md-1 news-card-feedback-container '.esc_attr($animation_class).' '.esc_attr($radius).'">
        <div class="news-card-feedback '.esc_attr($shadow_class).'">
            <div class="feedback__users">

                '.implode( "\n", $reviews_out ).'
            </div>
            <div class="news-card-feedback__navigate">
                <button class="prev"><i class="fa fa-chevron-up"></i></button>
                <button class="next"><i class="fa fa-chevron-down"></i></button>
            </div>
        </div>
    </div>';
} else {
    $out = '
    <div class="'.esc_attr($style).'__carousel '.wp_kses_post($carousel_class).' '.esc_attr($animation_class).' '.esc_attr($radius).' " '.wp_kses_post($data_carousel).'>

        '.implode( "\n", $reviews_out ).'

    </div>';
}


if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}
