<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $template
 * @var $cat_serv
 * @var $count
 * @var $buttext
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Section_Services
 */
$out = $cnt = $radius = $buttext = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );


if( $template == 'landing' && $cat_serv == '' ):
	$out .= '<p>'.esc_html__('No departments selected. To fix this, please login to your WP Admin area and set the departments you want to show by editing this shortcode and setting one or more departments in the multi checkbox field "Departments".', 'cutstyle');
else: 

$out = '<div class="services '.esc_attr($radius).'">';

$services = explode( ",", $cat_serv );
$args = array(
			'post_type' => 'services', 
			'orderby' => 'menu_order',
			'tax_query' => array(
				array(
					'taxonomy' => 'services_category',
					'field'    => 'slug',
					'terms'    => $services
				)
			),
			'order' => 'ASC'
		);
if( is_numeric($count) )
	$args['showposts'] = $count;
else
	$args['posts_per_page'] = -1;
	
$wp_query = new WP_Query( $args );
	
if($template == 'isotop'){

	$args = array(
        'post_type' => 'services',
        'orderby' => 'menu_order',
        'order' => 'ASC'
    );
	if( is_numeric($count) )
		$args['showposts'] = $count;
	else
		$args['posts_per_page'] = -1;

	$wp_query = new WP_Query( $args );

	if ($wp_query->have_posts()):

$out .= '
    <div class="row">
		<div class="col-lg-4 col-md-12">
            <div class="side-menu filter-button-menu">
                <div class="row">
                    <div class="col-lg-12 col-md-6">
                        <div class="side-menu__item">
                            <h3 class="widget-title">'.esc_html__('Services', 'cutstyle').'</h3>
                            <div class="sep-element"></div>
                            <div class="side-menu__item-categories">
                                <ul class="pix-services-category">';
                                    $categories = get_categories(array('type' => 'post', 'taxonomy' => 'services_category'));
                                    $i = 0;
                                    foreach ($categories as $category) {
                                        if( $i == 0 ){
                                            $out .= '
                                                <li><a class="active" data-filter=".'.esc_attr($category->slug).'">'.wp_kses_post( $category->cat_name ).'</a></li>
                                            ';
                                        } else {
                                            $out .= '
                                                <li><a data-filter=".'.esc_attr($category->slug).'">'.wp_kses_post( $category->cat_name ).'</a></li>
                                            ';
                                        }
                                        $i++;
                                    }
            $out .= '
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>   
        </div>
        <div class="col-sm-8">
            <div class="grid-services">
                <div class="grid-services-sizer"></div><div class="grid-services-gutter"></div>
		';

		while ($wp_query->have_posts()) :
			$wp_query->the_post();
	        $cat_slugs = '';
			$cats = wp_get_object_terms(get_the_ID(), 'services_category');
            if ($cats){
                foreach( $cats as $cat ){
                    $cat_slugs .= $cat->slug . " ";
                }
            }
			$thumbnail = get_the_post_thumbnail(get_the_ID(), 'pixtheme-services-thumb');


$out .= '
        
                <div class="grid-services-item '.esc_attr($cat_slugs).'">	    
                    <div class="service-box-5 pix-content">
                        <a href="'.esc_url(get_permalink(get_the_ID())).'">
                            <div class="pix-img-wrapper">'.wp_kses_post($thumbnail).'</div>
                        </a>
                        <div class="service-box-5__text">
                            <h2><a href="'.esc_url(get_permalink(get_the_ID())).'">'.wp_kses_post(get_the_title()).'</a></h2>
                            <p>'.pixtheme_limit_words(get_the_excerpt(), 20).'</p>
                        </div>
                        <span class=""><a href="'.esc_url(get_permalink(get_the_ID())).'"></a></span>
                    </div>
                </div>
		';

		endwhile;
$out .= '
            </div>
        </div>
	</div>
	';
	endif;
			
} elseif($template == 'landing') {

	$out .= '
			<div class="container-fluid inner-offset">    
				<div class="row">
			';
	
	if ($wp_query->have_posts()):
			while ($wp_query->have_posts()) :
				$wp_query->the_post();
				$thumbnail = get_the_post_thumbnail(get_the_ID(), 'pixtheme-services-thumb', array('class'	=> "full-width"));
	$out .= '
				<div class="service-item col-xs-12 col-sm-4">
					<div class="img-hover-effect"><a href="'.esc_url(get_permalink(get_the_ID())).'">'.wp_kses_post($thumbnail).'</a></div>
					<h4><a href="'.esc_url(get_permalink(get_the_ID())).'">'. wp_kses_post(get_the_title()) .'</a></h4>
					<p>'. pixtheme_limit_words(get_the_excerpt(), 20) .'</p>
					<a class="btn" href="'. esc_url(get_permalink(get_the_ID())) .'"><span>'.wp_kses_post($buttext).'</span></a>
				</div>
    ';
			endwhile;
		endif;
	
	$out .= '
				</div>               
			</div>
			';
	
} else {

$args = array(
    'post_type' => 'services',
    'orderby' => 'menu_order',
    'order' => 'ASC'
);
    if( is_numeric($count) )
        $args['showposts'] = $count;
    else
        $args['posts_per_page'] = -1;

    $wp_query = new WP_Query( $args );
    $out .= '
	<div class="row">
		<div class="col-lg-4 col-md-12">
			<div class="side-menu">
                <div class="row">
                    <div class="col-lg-12 col-md-6">
                        <div class="side-menu__item">
                            <h3>'.esc_html__('Departments', 'cutstyle').'</h3>
                            <div class="side-menu__item-categories">
                                <ul class="pix-services-category">
                                    <li class="current-cat"><a href>'.esc_html__('All services', 'cutstyle').'</a></li>';
    $args = array( 'taxonomy' => 'services_category', 'hide_empty' => '1', 'title_li'=> '', 'show_count' => '0', 'echo' => '0');
    $categories = wp_list_categories ($args);
    $out .= '
                                    '.$categories.'
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
			<div class="row services">
		';


    if ($wp_query->have_posts()):
        while ($wp_query->have_posts()) :
            $wp_query->the_post();
            $cats = wp_get_object_terms(get_the_ID(), 'services_category');

            $thumbnail = get_the_post_thumbnail(get_the_ID(), 'pixtheme-services-thumb', array('class' => 'full-width'));


            $out .= '	    
	    	    <div class="col-md-6">
                    <div class="service-box-5">
                        <a href="'.esc_url(get_permalink(get_the_ID())).'">
                            <div class="pix-img-wrapper">'.wp_kses_post($thumbnail).'</div>
                        </a>
                        <div class="service-box-5__text">
                            <h2><a href="'.esc_url(get_permalink(get_the_ID())).'">'.wp_kses_post(get_the_title()).'</a></h2>
                            <p>'.pixtheme_limit_words(get_the_excerpt(), 20).'</p>
                        </div>
                        <a href="'.esc_url(get_permalink(get_the_ID())).'"></a>
                    </div>
                </div>	
		';

        endwhile;
    endif;

    $out .= '
			</div>
		</div>
	</div>
	';
}

wp_reset_query();

$out .= '</div>';
endif;	

if(function_exists('pix_out')){
    pix_out($out);
} else {
    echo wp_kses_post($out);
}