<?php

	$carousel = array(
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Carousel', 'cutstyle' ),
            'param_name' => 'carousel',
            'value' => 'on',
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Items per Page', 'cutstyle' ),
            'param_name' => 'carousel_items',
            'value' => array(
                'default' => 3,
                esc_html__( '1', 'cutstyle' ) => 1,
                esc_html__( '2', 'cutstyle' ) => 2,
                esc_html__( '3', 'cutstyle' ) => 3,
                esc_html__( '4', 'cutstyle' ) => 4,
                esc_html__( '5', 'cutstyle' ) => 5,
                esc_html__( '6', 'cutstyle' ) => 6,
                esc_html__( '7', 'cutstyle' ) => 7,
                esc_html__( '8', 'cutstyle' ) => 8,
                esc_html__( '9', 'cutstyle' ) => 9,
                esc_html__( '10', 'cutstyle' ) => 10,
            ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-8',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Pagination', 'cutstyle' ),
            'param_name' => 'carousel_dots',
            'value' => 'on',
            'description' => esc_html__( 'Pagination dots ...', 'cutstyle' ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Navigation', 'cutstyle' ),
            'param_name' => 'carousel_nav',
            'value' => 'off',
            'description' => esc_html__( 'Navigation arrows < >', 'cutstyle' ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Loop', 'cutstyle' ),
            'param_name' => 'carousel_loop',
            'value' => 'off',
            'description' => esc_html__( 'Infinity loop', 'cutstyle' ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Margin', 'cutstyle' ),
            'param_name' => 'carousel_margin',
            'value' => '',
            'description' => esc_html__( 'margin-right(px) on item', 'cutstyle' ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'on Tablet', 'cutstyle' ),
            'param_name' => 'carousel_margin_tablet',
            'value' => '',
            'description' => '',
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'on Mobile', 'cutstyle' ),
            'param_name' => 'carousel_margin_mobile',
            'value' => '',
            'description' => '',
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Padding', 'cutstyle' ),
            'param_name' => 'carousel_stagepadding',
            'value' => '',
            'description' => esc_html__( 'Padding left and right on stage', 'cutstyle' ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'on Tablet', 'cutstyle' ),
            'param_name' => 'carousel_stagepadding_tablet',
            'value' => '',
            'description' => '',
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'on Mobile', 'cutstyle' ),
            'param_name' => 'carousel_stagepadding_mobile',
            'value' => '',
            'description' => '',
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'range_slider',
            'heading' => esc_html__( 'Speed', 'cutstyle' ),
            'param_name' => 'carousel_speed',
            'value' => array(
                'default' => '1000',
                'min' => '0',
                'max' => '10000',
                'step' => '100',
                'unit' => 'ms',
            ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Autoplay', 'cutstyle' ),
            'param_name' => 'carousel_autoplay',
            'value' => 'off',
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'range_slider',
            'heading' => esc_html__( 'Autoplay Speed', 'cutstyle' ),
            'param_name' => 'carousel_autoplaySpeed',
            'value' => array(
                'default' => '1000',
                'min' => '0',
                'max' => '10000',
                'step' => '100',
                'unit' => 'ms',
            ),
            'dependency' => array(
                'element' => 'carousel_autoplay',
                'value' => 'on'
            ),
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Animate Next Slide', 'cutstyle' ),
            'param_name' => 'carousel_animation',
            'value' => 'off',
            'description' => esc_html__( 'FadeInUp animate', 'cutstyle' ),
            'dependency' => array(
                'element' => 'carousel',
                'value' => 'on'
            ),
            'edit_field_class' => 'vc_col-sm-4',
            'group' => esc_html__( 'Carousel', 'cutstyle' ),
        ),
    );

    vc_add_params( 'common_reviews', $carousel );
    vc_add_params( 'common_posts_block', $carousel );
    vc_add_params( 'common_brands', $carousel );
    vc_add_params( 'common_woocommerce', $carousel );

    function pixtheme_get_carousel($carousel_arr, $animation_func = ''){
        $options_arr = array();

        if( isset($carousel_arr['carousel']) && $carousel_arr['carousel'] == 'on' ) {
            unset($carousel_arr['carousel']);
            $stagepadding_tablet = $stagepadding_mobile = $margin_tablet = $margin_mobile = 0;
            foreach ($carousel_arr as $key => $val) {
                $option = str_replace('carousel_', '', $key);
                if ($option == 'speed') {
                    $options_arr['navSpeed'] = $val;
                    $options_arr['dotsSpeed'] = $val;
                } elseif ($option == 'animation' && $val == 'on') {
                    $options_arr['onTranslate'] = $animation_func;
                } elseif ($option == 'margin') {
                    $options_arr[$option] = (int)$val;
                } elseif ($option == 'margin_tablet') {
                    $margin_tablet = (int)$val;
                } elseif ($option == 'margin_mobile') {
                    $margin_mobile = (int)$val;
                } elseif ($option == 'stagepadding') {
                    $options_arr['stagePadding'] = (int)$val;
                } elseif ($option == 'stagepadding_tablet') {
                    $stagepadding_tablet = (int)$val;
                } elseif ($option == 'stagepadding_mobile') {
                    $stagepadding_mobile = (int)$val;
                } elseif ( $val == 'on' || $val == 'off' ) {
                    $options_arr[$option] = $val == 'on' ? true : false;
                } else {
                    $options_arr[$option] = $val;
                }
            }
            $options_arr['responsiveClass'] = true;
            $options_arr['responsive'] = array(
                '0' => array(
                    'items' => 1,
                    'margin' => (int)$margin_mobile,
                    'stagePadding' => (int)$stagepadding_mobile,
                ),
                '480' => array(
                    'items' => 2,
                    'margin' => (int)$margin_tablet,
                    'stagePadding' => (int)$stagepadding_tablet,
                ),
                '768' => array(
                    'items' => isset($options_arr['items']) ? (int)$options_arr['items'] : 3,
                    'margin' => isset($options_arr['margin']) ? (int)$options_arr['margin'] : 0,
                    'stagePadding' => isset($options_arr['stagePadding']) ? (int)$options_arr['stagePadding'] : 0,
                )
            );
            $options_arr['navText'] = array('&lt;i class="icon-arrow-left"&gt;&lt;/i&gt;', '&lt;i class="icon-arrow-right"&gt;&lt;/i&gt;');
        }

        return $options_arr;
    }

?>