<?php

    $padding_attr = array(
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Padding Top', 'cutstyle' ),
            'param_name' => 'pix_padding_top',
            'value' => array(
                'default' => 'pix-padding-top-l',
                esc_html__( 'No Padding', 'cutstyle' ) => 'pix-top-no-padding',
                esc_html__( 'S', 'cutstyle' ) => 'pix-padding-top-s',
                esc_html__( 'M', 'cutstyle' ) => 'pix-padding-top-m',
                esc_html__( 'L', 'cutstyle' ) => 'pix-padding-top-l',
                esc_html__( 'XL', 'cutstyle' ) => 'pix-padding-top-xl',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Padding Bottom', 'cutstyle' ),
            'param_name' => 'pix_padding_bottom',
            'value' => array(
                'default' => 'pix-padding-bottom-l',
                esc_html__( 'No Padding', 'cutstyle' ) => 'pix-bottom-no-padding',
                esc_html__( 'S', 'cutstyle' ) => 'pix-padding-bottom-s',
                esc_html__( 'M', 'cutstyle' ) => 'pix-padding-bottom-m',
                esc_html__( 'L', 'cutstyle' ) => 'pix-padding-bottom-l',
                esc_html__( 'XL', 'cutstyle' ) => 'pix-padding-bottom-xl',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
    );

    $padding_no_attr = array(
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Padding Top', 'cutstyle' ),
            'param_name' => 'pix_padding_top',
            'value' => array(
                'default' => 'pix-top-no-padding',
                esc_html__( 'No Padding', 'cutstyle' ) => 'pix-top-no-padding',
                esc_html__( 'S', 'cutstyle' ) => 'pix-padding-top-s',
                esc_html__( 'M', 'cutstyle' ) => 'pix-padding-top-m',
                esc_html__( 'L', 'cutstyle' ) => 'pix-padding-top-l',
                esc_html__( 'XL', 'cutstyle' ) => 'pix-padding-top-xl',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Padding Bottom', 'cutstyle' ),
            'param_name' => 'pix_padding_bottom',
            'value' => array(
                'default' => 'pix-bottom-no-padding',
                esc_html__( 'No Padding', 'cutstyle' ) => 'pix-bottom-no-padding',
                esc_html__( 'S', 'cutstyle' ) => 'pix-padding-bottom-s',
                esc_html__( 'M', 'cutstyle' ) => 'pix-padding-bottom-m',
                esc_html__( 'L', 'cutstyle' ) => 'pix-padding-bottom-l',
                esc_html__( 'XL', 'cutstyle' ) => 'pix-padding-bottom-xl',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
    );

	$row_attr = array(
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Container Shape', 'cutstyle' ),
            'param_name' => 'radius',
            'value' => array(
                'default' => 'default',
                esc_html__( 'Square', 'cutstyle' ) => 'default',
                esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Text Color', 'cutstyle' ),
            'param_name' => 'ptextcolor',
            'value' => array(
                'default' => 'Default',
                esc_html__( 'Default', 'cutstyle' ) => 'Default',
                esc_html__( 'Light', 'cutstyle' ) => 'White',
                esc_html__( 'Dark', 'cutstyle' ) => 'Black',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
		array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Fixed Background Image', 'cutstyle' ),
            'param_name' => 'bgstyle',
            'value' => 'off',
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'cutstyle' ),
            'param_name' => 'bgimage',
            'value' => '',
            'description' => esc_html__( 'Fixed background image', 'cutstyle' ),
            'dependency' => array(
                'element' => 'bgstyle',
                'value' => 'on',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),

    );

	$column_attr = array(
	    array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Not Stretch Content Alignment', 'cutstyle' ),
            'param_name' => 'pix_not_stretch_content',
            'value' => array(
                'default' => 'off',
                esc_html__( 'Off', 'cutstyle' ) => 'off',
                esc_html__( 'Left', 'cutstyle' ) => 'pix-col-content-left',
                esc_html__( 'Center', 'cutstyle' ) => 'pix-col-content-center',
                esc_html__( 'Right', 'cutstyle' ) => 'pix-col-content-right',
            ),
            'description' => esc_html__( 'If you don\'t want to stretch content in column with row setting \'Stretch row and content\'.', 'cutstyle' ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
        ),
        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Text Color', 'cutstyle' ),
            'param_name' => 'ptextcolor',
            'value' => array(
                'default' => 'Default',
                esc_html__( 'Default', 'cutstyle' ) => 'Default',
                esc_html__( 'Light', 'cutstyle' ) => 'White',
                esc_html__( 'Dark', 'cutstyle' ) => 'Black',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
        ),
		array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Fixed Background Image', 'cutstyle' ),
            'param_name' => 'bgstyle',
            'value' => 'off',
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'cutstyle' ),
            'param_name' => 'bgimage',
            'value' => '',
            'description' => esc_html__( 'Fixed background image', 'cutstyle' ),
            'dependency' => array(
                'element' => 'bgstyle',
                'value' => 'on',
            ),
            'group' => esc_html__( 'PixAdvanced', 'cutstyle' ),
            'edit_field_class' => 'vc_col-sm-6',
        ),
    );


    $gradient_attr = array(
		// Gradient
        array(
            'type' => 'param_group',
            'value' => '',
            'heading' => esc_html__( 'Gradient', 'cutstyle' ),
            'param_name' => 'gradient_colors',
            // Note params is mapped inside param-group:
            'params' => array(
                array(
                    'type' => 'colorpicker',
                    'value' => '',
                    'heading' => esc_html__( 'Color For Gradient', 'cutstyle' ),
                    'param_name' => 'gradient_color',
                )
            ),
		    'group' => esc_html__( 'Gradient', 'cutstyle' ),
        ),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Direction', 'cutstyle' ),
			'param_name' => 'gradient_direction',
			'value' => array(
				esc_html__( 'To Right ', 'cutstyle' ).html_entity_decode('&rarr;') => 'to right',
				esc_html__( 'To Left ', 'cutstyle' ).html_entity_decode('&larr;') => 'to left',
				esc_html__( 'To Bottom ', 'cutstyle' ).html_entity_decode('&darr;') => 'to bottom',
				esc_html__( 'To Top ', 'cutstyle' ).html_entity_decode('&uarr;') => 'to top',
				esc_html__( 'To Bottom Right ', 'cutstyle' ).html_entity_decode('&#8600;') => 'to bottom right',
				esc_html__( 'To Bottom Left ', 'cutstyle' ).html_entity_decode('&#8601;') => 'to bottom left',
				esc_html__( 'To Top Right ', 'cutstyle' ).html_entity_decode('&#8599;') => 'to top right',
				esc_html__( 'To Top Left ', 'cutstyle' ).html_entity_decode('&#8598;') => 'to top left',
				esc_html__( 'Angle ', 'cutstyle' ).html_entity_decode('&#10227;') => 'angle',
			),
			'description' => '',
			'group' => esc_html__( 'Gradient', 'cutstyle' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Angle Direction', 'cutstyle' ),
			'param_name' => 'gradient_angle',
			'value' => '90',
			'description' => esc_html__( 'Values -360 - 360', 'cutstyle' ),
			'dependency' => array(
				'element' => 'gradient_direction',
				'value' => 'angle',
			),
			'group' => esc_html__( 'Gradient', 'cutstyle' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Opacity', 'cutstyle' ),
			'param_name' => 'gradient_opacity',
			'value' => '1',
			'description' => esc_html__( 'Values 0.01 - 0.99', 'cutstyle' ),
			'group' => esc_html__( 'Gradient', 'cutstyle' ),
		),
        
	);


	$decor_attr = array(
        
        // Decors
        // Top Decor
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Show Top Decor', 'cutstyle' ),
            'param_name' => 'pdecor',
            'value' => 'off',
            'description' => esc_html__( 'Show decor at the top of the section.', 'cutstyle' ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Height', 'cutstyle' ),
            'param_name' => 'decor_height',
            'value' => '150',
            'description' => esc_html__( 'Values 0 - 300', 'cutstyle' ),
            'dependency' => array(
                'element' => 'pdecor',
                'value' => 'on',
            ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Top Decor Opacity', 'cutstyle' ),
            'param_name' => 'decor_opacity',
            'value' => '',
            'description' => esc_html__( 'Values 0.01 - 0.99', 'cutstyle' ),
            'dependency' => array(
                'element' => 'pdecor',
                'value' => 'on',
            ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Top Decor Points', 'cutstyle' ),
            'param_name' => 'decor_points_top',
            'value' => '',
            'description' => esc_html__( 'Example: 0,100 50,50 100,100', 'cutstyle' ),
            'dependency' => array(
                'element' => 'pdecor',
                'value' => 'on',
            ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),

        // Bottom Decor
        array(
            'type' => 'switch_button',
            'heading' => esc_html__( 'Show Bottom Decor', 'cutstyle' ),
            'param_name' => 'pdecor_bottom',
            'value' => 'off',
            'description' => esc_html__( "Show decor at the bottom of the section.", 'cutstyle' ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Height', 'cutstyle' ),
            'param_name' => 'decor_bottom_height',
            'value' => '150',
            'description' => esc_html__( 'Values 0 - 300', 'cutstyle' ),
            'dependency' => array(
                'element' => 'pdecor_bottom',
                'value' => 'on',
            ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Bottom Decor Opacity', 'cutstyle' ),
            'param_name' => 'decor_bottom_opacity',
            'value' => '',
            'description' => esc_html__( 'Values 0.01 - 0.99', 'cutstyle' ),
            'dependency' => array(
                'element' => 'pdecor_bottom',
                'value' => 'on',
            ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Bottom Decor Points', 'cutstyle' ),
            'param_name' => 'decor_points_bottom',
            'value' => '',
            'description' => esc_html__( 'Example: 0,100 50,50 100,100', 'cutstyle' ),
            'dependency' => array(
                'element' => 'pdecor_bottom',
                'value' => 'on',
            ),
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Overlay', 'cutstyle' ),
            'param_name' => 'poverlay',
            'value' => array(
                esc_html__( "Use", 'cutstyle' ) => 'pix-row-overlay',
                esc_html__( "None", 'cutstyle' ) => 'no-overlay',
            ),
            'description' => '',
            'group' => esc_html__( 'Decor', 'cutstyle' ),
        ),
	);

	vc_add_params( 'vc_row', array_merge($padding_attr, $row_attr, $gradient_attr) );
	vc_add_params( 'vc_row_inner', array_merge($padding_no_attr, $row_attr, $gradient_attr) );
	vc_add_params( 'vc_column', array_merge($padding_no_attr, $column_attr, $gradient_attr) );

?>