<?php

	$shadows = array(
	    array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Shadows', 'cutstyle' ),
            'param_name' => 'shadow',
            'value' => array(
                'default' => 'no-shadow',
                esc_html__( 'Disable', 'cutstyle' ) => 'no-shadow',
                esc_html__( 'Show', 'cutstyle' ) => 'pix-shadow',
                esc_html__( 'On Hover', 'cutstyle' ) => 'pix-shadow-hover',
            ),
            'group' => esc_html__( 'Shadows', 'cutstyle' ),
        ),
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Values', 'cutstyle' ),
            'param_name' => 'shadow_values',
            'description' => esc_html__( 'Enter values for graph - title and value.', 'cutstyle' ),
            'value' => urlencode( json_encode( array(
                array(
                    'horizontal' => '0',
                    'vertical' => '2',
                    'blur' => '5',
                    'spread' => '0',
                    'color' => '#000',
                    'opacity' => '10',
                ),
                array(
                    'horizontal' => '0',
                    'vertical' => '10',
                    'blur' => '30',
                    'spread' => '0',
                    'color' => '#000',
                    'opacity' => '5',
                ),
            ) ) ),
            'params' => array(
                array(
                    'type' => 'range_slider',
                    'heading' => esc_html__( 'Horizontal Position', 'cutstyle' ),
                    'param_name' => 'horizontal',
                    'value' => array(
                        'default' => '0',
                        'min' => '-100',
                        'max' => '100',
                    ),
                ),
                array(
                    'type' => 'range_slider',
                    'heading' => esc_html__( 'Vertical Position', 'cutstyle' ),
                    'param_name' => 'vertical',
                    'value' => array(
                        'default' => '0',
                        'min' => '-100',
                        'max' => '100',
                    ),
                ),
                array(
                    'type' => 'range_slider',
                    'heading' => esc_html__( 'Blur', 'cutstyle' ),
                    'param_name' => 'blur',
                    'value' => array(
                        'default' => '0',
                        'min' => '0',
                        'max' => '100',
                    ),
                ),
                array(
                    'type' => 'range_slider',
                    'heading' => esc_html__( 'Spread', 'cutstyle' ),
                    'param_name' => 'spread',
                    'value' => array(
                        'default' => '0',
                        'min' => '-100',
                        'max' => '100',
                    ),
                ),
                array(
                    'type' => 'colorpicker',
                    'heading' => esc_html__( 'Color', 'cutstyle' ),
                    'param_name' => 'color',
                    'value' => '#000',
                    'description' => '',
                ),
                array(
                    'type' => 'range_slider',
                    'heading' => esc_html__( 'Opacity', 'cutstyle' ),
                    'param_name' => 'opacity',
                    'value' => array(
                        'default' => '15',
                        'min' => '0',
                        'max' => '100',
                        'unit' => '%',
                    ),
                ),
            ),
            'dependency' => array(
                'element' => 'shadow',
                'value' => array('pix-shadow-hover', 'pix-shadow'),
            ),
            'group' => esc_html__( 'Shadows', 'cutstyle' ),
        ),

        array(
            'type' => 'range_slider',
            'heading' => esc_html__( 'Transition Time', 'cutstyle' ),
            'param_name' => 'shadow_transition',
            'value' => array(
                'default' => '0.35',
                'min' => '0',
                'max' => '3',
                'step' => '0.05',
            ),
            'dependency' => array(
                'element' => 'shadow',
                'value' => array('pix-shadow-hover'),
            ),
            'group' => esc_html__( 'Shadows', 'cutstyle' ),
        ),

        array(
            'type' => 'segmented_button',
            'heading' => esc_html__( 'Preset', 'cutstyle' ),
            'param_name' => 'shadow_effect',
            'value' => array(
                'default' => 'no-effect',
                esc_html__( 'Disable', 'cutstyle' ) => 'no-effect',
                esc_html__( 'Lifted Corners', 'cutstyle' ) => 'lifted-corners',
                esc_html__( 'Bottom Curve', 'cutstyle' ) => 'bottom-curve',
            ),
            'group' => esc_html__( 'Shadows', 'cutstyle' ),
        ),

        
	);

	$buttons_shadow_show = !pixtheme_get_option('buttons_shadow', '0') ? 'no-shadow' : 'pix-shadow-hover';

    $shadows_buttons = $shadows;
    $shadows_buttons[0]['value']['default'] = $buttons_shadow_show;
    $shadows_buttons[1]['value'] = urlencode( json_encode( array(
        array(
            'horizontal' => pixtheme_get_option('buttons_shadow_h', '0'),
            'vertical' => pixtheme_get_option('buttons_shadow_v', '0'),
            'blur' => pixtheme_get_option('buttons_shadow_blur', '0'),
            'spread' => pixtheme_get_option('buttons_shadow_spread', '0'),
            'color' => pixtheme_get_option('buttons_shadow_color', '0'),
            'opacity' => pixtheme_get_option('buttons_shadow_opacity', '100'),
        )
    )));

	vc_add_params( 'vc_row', $shadows );
	vc_add_params( 'common_button', $shadows_buttons);
	vc_add_params( 'common_icon_box', $shadows );
	vc_add_params( 'common_reviews', $shadows );
	vc_add_params( 'common_price_table', $shadows );
	vc_add_params( 'common_posts_block', $shadows );
	vc_add_params( 'common_portfolio', $shadows );

	function pixtheme_get_shadow($shadow_arr){
	    if(isset($shadow_arr['shadow']) && $shadow_arr['shadow'] != 'no-shadow') {
            $pix_shadow_class = 'pix_shadow_' . rand();
            $hover = $shadow_arr['shadow'] == 'pix-shadow-hover' ? ':hover' : '';
            $values = (array) vc_param_group_parse_atts( $shadow_arr['shadow_values'] );
            $shadows_data = array();
            $max_blur = 0;
            foreach ( $values as $data ) {
                $h = isset($data['horizontal']) ? $data['horizontal'] : '';
                $v = isset($data['vertical']) ? $data['vertical'] : '';
                $blur = isset($data['blur']) ? $data['blur'] : '';
                $max_blur = $blur > $max_blur ? $blur : $max_blur;
                $spread = isset($data['spread']) ? $data['spread'] : '';
                $color = isset($data['color']) ? $data['color'] : '';
                $opacity = isset($data['opacity']) ? $data['opacity'] : '';

                $shadows_data[] = esc_attr((int)$h).'px '.esc_attr((int)$v).'px '.esc_attr((int)$blur).'px '.esc_attr((int)$spread).'px rgba('.esc_attr(pixtheme_hex2rgb($color)).','.esc_attr((int)$opacity/100).')';
            }
            $transition = isset($shadow_arr['shadow_transition']) ? 'transition:'.$shadow_arr['shadow_transition'].'s;' : '';
            $shadow_effect = isset($shadow_arr['shadow_effect']) ? $shadow_arr['shadow_effect'] : 'no-effect';
            $pix_shadow_style = 'jQuery(function($){';
            $pix_shadow_style .= ' $("head").append("<style> .'.esc_attr($pix_shadow_class).wp_kses_post($hover).'{box-shadow:'.implode(',', $shadows_data).';}.'.esc_attr($pix_shadow_class).'{transition:.35s;margin-top:'.esc_attr((int)$max_blur*0.5).'px;}</style>");';
            if($shadow_effect == 'lifted-corners')
                $pix_shadow_style .= ' $(".'.esc_attr($pix_shadow_class).'").append(\'<div class="pix-shadow-corner pix-left"></div><div class="pix-shadow-corner pix-right"></div>\');';
            if($shadow_effect == 'bottom-curve')
                $pix_shadow_style .= ' $(".'.esc_attr($pix_shadow_class).'").append(\'<div class="pix-shadow-curve"></div>\');';
            $pix_shadow_style .= '})';
            wp_add_inline_script( 'pixtheme-common', $pix_shadow_style );
            return $pix_shadow_class;
        } else {
	        return '';
        }

    }

?>