<?php

	$vc_icons_data = pixtheme_init_vc_icons();

	$args = array( 'hide_empty' => false );
	$categories = get_terms( $args );
	$cats = $cats_post = $cats_woo = $cats_serv = $calendars = array();
	$calendars[esc_html__('Default Calendar', 'cutstyle')] = 0;
	foreach($categories as $category){
		if( is_object($category) ){
			if( $category->taxonomy == 'portfolio_category' ){
				$cats[$category->name] = $category->slug;
			} elseif( $category->taxonomy == 'category' ) {
				$cats_post[$category->name] = $category->slug;
			} elseif( $category->taxonomy == 'product_cat' ) {
				$cats_woo[$category->name] = $category->term_id;
			} elseif( $category->taxonomy == 'services_category' ) {
				$cats_serv[$category->name] = $category->slug;
			} elseif( $category->taxonomy == 'booked_custom_calendars' ) {
				$calendars[$category->name] = $category->term_id;
			}
		}
	}

	$args = array( 'post_type' => 'services');
	$services = get_posts($args);
	$serv = array();
	if(empty($services['errors'])){
		foreach($services as $service){
			$serv[$service->post_title] = $service->ID;
		}
	}
	
	$args = array( 'post_type' => 'wpcf7_contact_form');
	$forms = get_posts($args);
	$cform7 = array();
	if(empty($forms['errors'])){
		foreach($forms as $form){
			$cform7[$form->post_title] = $form->ID;
		}
	}


	/// common_title
	vc_map(
		array(
			'name' => esc_html__( 'Title', 'cutstyle' ),
			'base' => 'common_title',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array(
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'heading' => esc_html__( 'Title', 'cutstyle' ),
					'param_name' => 'title',
					'value' => esc_html__( 'I am Title', 'cutstyle' ),
					'description' => esc_html__( 'Main title.', 'cutstyle' )
				),
				array(
					'type' => 'textarea',
                    'holder' => 'div',
					'heading' => esc_html__( 'Subtitle', 'cutstyle' ),
					'param_name' => 'subtitle',
					'value' => '',
					'description' => esc_html__( 'Text after title', 'cutstyle' )
				),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Position', 'cutstyle' ),
                    'param_name' => 'position',
                    'value' => array(
                        'default' => 'text-center',
                        esc_html__( 'Left', 'cutstyle' ) => 'text-left',
                        esc_html__( 'Center', 'cutstyle' ) => 'text-center',
                        esc_html__( 'Right', 'cutstyle' ) => 'text-right',
                    ),
                ),
                array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Show Decor', 'cutstyle' ),
                    'param_name' => 'show_decor',
                    'value' => 'on',
                    'edit_field_class' => 'vc_col-sm-6',
                ),
				array(
					'type' => 'segmented_button',
					'heading' => esc_html__( 'Title Tone', 'cutstyle' ),
					'param_name' => 'color',
					'value' => array(
                        'default' => 'default',
						esc_html__( 'Dark', 'cutstyle' ) => 'default',
						esc_html__( 'Light', 'cutstyle' ) => 'white-heading',
					),
                    'edit_field_class' => 'vc_col-sm-6',
				),
                array(
                    'type' => 'css_editor',
                    'heading' => esc_html__( 'Css', 'cutstyle' ),
                    'param_name' => 'css',
                    'group' => esc_html__( 'Design options', 'cutstyle' ),
                ),
			)
		)
	);



	/// common_button
	vc_map(
		array(
			'name' => esc_html__( 'Button', 'cutstyle' ),
			'base' => 'common_button',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array(
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'heading' => esc_html__( 'Text', 'cutstyle' ),
					'param_name' => 'text',
					'value' => esc_html__( 'Go', 'cutstyle' ),
					'description' => esc_html__( 'Button text.', 'cutstyle' )
				),
				array(
                    'type' => 'vc_link',
                    'heading' => esc_html__( 'Link', 'cutstyle' ),
                    'param_name' => 'link',
                    'value' => '',
                    'description' => esc_html__( 'Button link', 'cutstyle' )
                ),
				array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'As Link', 'cutstyle' ),
                    'param_name' => 'button_type',
                    'value' => 'off',
                    'description' => esc_html__( 'Use as simple link with hover underline', 'cutstyle' )
                ),
				array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Shape', 'cutstyle' ),
                    'param_name' => 'radius',
                    'value' => array(
                        'default' => 'pix-round',
                        esc_html__( 'Square', 'cutstyle' ) => 'pix-square',
                        esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                        esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                    ),
                    'dependency' => array(
                        'element' => 'button_type',
                        'value' => array('off')
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Transparent', 'cutstyle' ),
                    'param_name' => 'transparent',
                    'value' => 'off',
                    'dependency' => array(
                        'element' => 'button_type',
                        'value' => array('off')
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Top/Bottom Paddings', 'cutstyle' ),
                    'param_name' => 'size_v',
                    'value' => array(
                        'default' => 'pix-v-s',
                        esc_html__( 'S', 'cutstyle' ) => 'pix-v-s',
                        esc_html__( 'M', 'cutstyle' ) => 'pix-v-m',
                        esc_html__( 'L', 'cutstyle' ) => 'pix-v-l',
                        esc_html__( 'XL', 'cutstyle' ) => 'pix-v-xl',
                    ),
                    'dependency' => array(
                        'element' => 'button_type',
                        'value' => array('off')
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
				array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Left/Right Paddings', 'cutstyle' ),
                    'param_name' => 'size_h',
                    'value' => array(
                        'default' => 'pix-h-l',
                        esc_html__( 'S', 'cutstyle' ) => 'pix-h-s',
                        esc_html__( 'M', 'cutstyle' ) => 'pix-h-m',
                        esc_html__( 'L', 'cutstyle' ) => 'pix-h-l',
                        esc_html__( 'XL', 'cutstyle' ) => 'pix-h-xl',
                    ),
                    'dependency' => array(
                        'element' => 'button_type',
                        'value' => array('off')
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
				array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Font Size', 'cutstyle' ),
                    'param_name' => 'font_size',
                    'value' => array(
                        'default' => 'pix-font-m',
                        esc_html__( 'S', 'cutstyle' ) => 'pix-font-s',
                        esc_html__( 'M', 'cutstyle' ) => 'pix-font-m',
                        esc_html__( 'L', 'cutstyle' ) => 'pix-font-l',
                        esc_html__( 'XL', 'cutstyle' ) => 'pix-font-xl',
                    ),
                ),
				array(
					'type' => 'segmented_button',
					'heading' => esc_html__( 'Color', 'cutstyle' ),
					'param_name' => 'color',
					'value' => array(
                        'default' => 'pix-colored',
						esc_html__( 'Colored', 'cutstyle' ) => 'pix-colored',
						esc_html__( 'Dark', 'cutstyle' ) => 'pix-dark',
						esc_html__( 'Light', 'cutstyle' ) => 'pix-light',
					),
                    'edit_field_class' => 'vc_col-sm-6',
				),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Alignment', 'cutstyle' ),
                    'param_name' => 'position',
                    'value' => array(
                        'default' => 'pix-text-left',
                        esc_html__( 'Left', 'cutstyle' ) => 'pix-text-left',
                        esc_html__( 'Center', 'cutstyle' ) => 'pix-text-center',
                        esc_html__( 'Right', 'cutstyle' ) => 'pix-text-right',
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => esc_html__( 'Css', 'cutstyle' ),
                    'param_name' => 'css',
                    'group' => esc_html__( 'Design options', 'cutstyle' ),
                ),
			)
		)
	);



	/// common_box_icon
	vc_map(
		array(
			'name' => esc_html__( 'Icon Box', 'cutstyle' ),
			'base' => 'common_icon_box',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array_merge(
				array(
					array(
						'type' => 'radio_images',
						'heading' => esc_html__( 'Style', 'cutstyle' ),
						'param_name' => 'style',
						'value' => array(
                            'icon_box_item-review.png' => 'pix-item-review',
							'icon_box_item-left.png' => 'pix-item-left',
							'icon_box_item-default-bordered.png' => 'pix-item-default pix-item-default-bordered',
							'icon_box_item-default-filled.png' => 'pix-item-default pix-item-default-filled',
                            'services_cat_flip.png' => 'pix-item-flip',
						),
						'description' => '',
					),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Background Image', 'cutstyle' ),
                        'param_name' => 'bg_image',
                        'description' => esc_html__( 'Select image.', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-flip')
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'switch_button',
                        'heading' => esc_html__( 'Flip Box', 'cutstyle' ),
                        'param_name' => 'flip',
                        'value' => 'on',
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-flip'),
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Box Shape', 'cutstyle' ),
                        'param_name' => 'radius',
                        'value' => array(
                            'default' => 'pix-square',
                            esc_html__( 'Square', 'cutstyle' ) => 'pix-square',
                            esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                            esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-left', 'pix-item-default pix-item-default-bordered', 'pix-item-default pix-item-default-filled', 'pix-item-flip')
                        ),
                    ),
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Type', 'cutstyle' ),
                        'param_name' => 'icon_type',
                        'value' => array(
                            'default' => 'image',
                            esc_html__( 'Image/SVG', 'cutstyle' ) => 'image',
                            esc_html__( 'Font', 'cutstyle' ) => 'font',
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
					array(
						'type' => 'attach_image',
						'heading' => esc_html__( 'Image/SVG', 'cutstyle' ),
						'param_name' => 'image',
						'description' => esc_html__( 'Select image.', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'icon_type',
                            'value' => array('svg', 'image')
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
					),
					
				),
				pixtheme_get_vc_icons($vc_icons_data, 'icon_type', 'font'),
				array(
				    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Size', 'cutstyle' ),
                        'param_name' => 'icon_size',
                        'value' => array(
                            'default' => 'pix-icon-l',
                            esc_html__( 'S', 'cutstyle' ) => 'pix-icon-s',
                            esc_html__( 'M', 'cutstyle' ) => 'pix-icon-m',
                            esc_html__( 'L', 'cutstyle' ) => 'pix-icon-l',
                            esc_html__( 'XL', 'cutstyle' ) => 'pix-icon-xl',
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Background', 'cutstyle' ),
                        'param_name' => 'icon_shape',
                        'value' => array(
                            'default' => 'transparent',
                            esc_html__( 'Transparent', 'cutstyle' ) => 'transparent',
                            esc_html__( 'Round', 'cutstyle' ) => 'round',
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-left', 'pix-item-review', 'pix-item-default pix-item-default-bordered')
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
				    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Color', 'cutstyle' ),
                        'param_name' => 'icon_color',
                        'value' => array(
                            'default' => 'pix-icon-color',
                            esc_html__( 'Color', 'cutstyle' ) => 'pix-icon-color',
                            esc_html__( 'Monochrome', 'cutstyle' ) => 'pix-icon-default',
                        ),
                        'dependency' => array(
                            'element' => 'icon_type',
                            'value' => array('font')
                        ),
                    ),
				    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Alignment', 'cutstyle' ),
                        'param_name' => 'position_with_center',
                        'value' => array(
                            'default' => 'pix-text-left',
                            esc_html__( 'Left', 'cutstyle' ) => 'pix-text-left',
                            esc_html__( 'Center', 'cutstyle' ) => 'pix-text-center',
                            esc_html__( 'Right', 'cutstyle' ) => 'pix-text-right',
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-left', 'pix-item-default pix-item-default-bordered', 'pix-item-default pix-item-default-filled')
                        ),
                    ),
				    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Alignment', 'cutstyle' ),
                        'param_name' => 'position_no_center',
                        'value' => array(
                            'default' => 'pix-text-review-left',
                            esc_html__( 'Left', 'cutstyle' ) => 'pix-text-review-left',
                            esc_html__( 'Right', 'cutstyle' ) => 'pix-text-review-right',
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-review')
                        ),
                    ),
				    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'cutstyle' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Enter text used as title of icon.', 'cutstyle' ),
                        'admin_label' => true,
                    ),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Button Text', 'cutstyle' ),
						'param_name' => 'btn_txt',
					),
					array(
						'type' => 'vc_link',
						'heading' => esc_html__( 'Link', 'cutstyle' ),
						'param_name' => 'link',
						'value' => '',
						'description' => esc_html__( 'Button link', 'cutstyle' )
					),
					array(
                        'type' => 'switch_button',
                        'heading' => esc_html__( 'Link Overlay', 'cutstyle' ),
                        'param_name' => 'link_overlay',
                        'value' => 'on',
                        'description' => esc_html__( 'The whole box is a link. Don\'t use links in content', 'cutstyle' )
                    ),
					array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Content Position', 'cutstyle' ),
                        'param_name' => 'content_position',
                        'value' => array(
                            'default' => 'pix-top',
                            esc_html__( 'Top', 'cutstyle' ) => 'pix-top',
                            esc_html__( 'Middle', 'cutstyle' ) => 'pix-middle',
                            esc_html__( 'Bottom', 'cutstyle' ) => 'pix-bottom',
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('pix-item-review')
                        ),
                    ),
					array(
						'type' => 'textarea_html',
						'holder' => 'div',
						'heading' => esc_html__( 'Content', 'cutstyle' ),
						'param_name' => 'content',
						'value' => '',
						'description' => esc_html__( 'Enter information.', 'cutstyle' )
					),
                    array(
                        'type' => 'css_editor',
                        'heading' => esc_html__( 'Css', 'cutstyle' ),
                        'param_name' => 'css',
                        'group' => esc_html__( 'Design options', 'cutstyle' ),
                    ),
				)
			),
		)
	);




	/// common_amount_box
	vc_map(
		array(
			'name' => esc_html__( 'Amount Box', 'cutstyle' ),
			'base' => 'common_amount_box',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array_merge(
			    array(
			        array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Type', 'cutstyle' ),
                        'param_name' => 'icon_type',
                        'value' => array(
                            'default' => 'svg',
                            esc_html__( 'SVG', 'cutstyle' ) => 'svg',
                            esc_html__( 'Image', 'cutstyle' ) => 'image',
                            esc_html__( 'Font', 'cutstyle' ) => 'font',
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
					array(
						'type' => 'attach_image',
						'heading' => esc_html__( 'Image/SVG', 'cutstyle' ),
						'param_name' => 'image',
						'description' => esc_html__( 'Select image.', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'icon_type',
                            'value' => array('svg', 'image')
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
					),
                ),
                pixtheme_get_vc_icons($vc_icons_data, 'icon_type', 'font'),
                array(
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Size', 'cutstyle' ),
                        'param_name' => 'icon_size',
                        'value' => array(
                            'default' => 'pix-icon-l',
                            esc_html__( 'S', 'cutstyle' ) => 'pix-icon-s',
                            esc_html__( 'M', 'cutstyle' ) => 'pix-icon-m',
                            esc_html__( 'L', 'cutstyle' ) => 'pix-icon-l',
                            esc_html__( 'XL', 'cutstyle' ) => 'pix-icon-xl',
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Alignment', 'cutstyle' ),
                        'param_name' => 'position',
                        'value' => array(
                            'default' => 'pix-text-center',
                            esc_html__( 'Left', 'cutstyle' ) => 'pix-text-left',
                            esc_html__( 'Center', 'cutstyle' ) => 'pix-text-center',
                            esc_html__( 'Right', 'cutstyle' ) => 'pix-text-right',
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Icon Color', 'cutstyle' ),
                        'param_name' => 'icon_color',
                        'value' => array(
                            'default' => 'pix-icon-color',
                            esc_html__( 'Color', 'cutstyle' ) => 'pix-icon-color',
                            esc_html__( 'Monochrome', 'cutstyle' ) => 'pix-icon-default',
                        ),
                        'dependency' => array(
                            'element' => 'icon_type',
                            'value' => array('font')
                        ),
                    ),
                    array(
                        'type' => 'textfield',
                        'holder' => 'div',
                        'heading' => esc_html__( 'Title', 'cutstyle' ),
                        'param_name' => 'title',
                        'value' => '',
                        'description' => esc_html__( 'Title.', 'cutstyle' )
                    ),
                    array(
                        'type' => 'textfield',
                        'holder' => 'div',
                        'heading' => esc_html__( 'Amount', 'cutstyle' ),
                        'param_name' => 'amount',
                        'value' => '',
                        'description' => esc_html__( 'Amount.', 'cutstyle' )
                    ),
			    ),
                $add_animation
            )
		)
	);

	/// common_mailchimp
	vc_map(
		array(
			'name' => esc_html__( 'Mailchimp Box', 'cutstyle' ),
			'base' => 'common_mailchimp',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'show_settings_on_create' => false,
			'content_element' => true,
			'params' => array(),
		)
	);
	//////////////////////////////////////////////////////////////////////


    /// common_cform7
    vc_map(
        array(
            'name' => esc_html__( 'Contact Form 7', 'cutstyle' ),
            'base' => 'common_cform7',
            'class' => 'pix-theme-icon-common',
            'category' => esc_html__( 'CutStyle', 'cutstyle'),
            'params' => array(
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Contact Form', 'cutstyle' ),
                    'param_name' => 'form_id',
                    'value' => $cform7,
                    'description' => esc_html__( 'Select contact form to show', 'cutstyle' )
                ),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Boxes Shape', 'cutstyle' ),
                    'param_name' => 'radius',
                    'value' => array(
                        'default' => 'pix-square',
                        esc_html__( 'Square', 'cutstyle' ) => 'pix-square',
                        esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                        esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                    ),
                ),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Send Button Position', 'cutstyle' ),
                    'param_name' => 'btn_position',
                    'value' => array(
                        'default' => 'pix-text-left',
                        esc_html__( 'Left', 'cutstyle' ) => 'pix-text-left',
                        esc_html__( 'Center', 'cutstyle' ) => 'pix-text-center',
                        esc_html__( 'Right', 'cutstyle' ) => 'pix-text-right',
                        esc_html__( 'Full Width', 'cutstyle' ) => 'pix-text-full-width',
                    ),
                ),
            )
        )
    );


    /// block_progress
    vc_map(
        array(
            'name' => esc_html__( 'Progress Bar', 'cutstyle' ),
            'base' => 'common_progress',
            'class' => 'pix-theme-icon-common',
            'category' => esc_html__( 'CutStyle', 'cutstyle'),
            'params' => array(
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Values', 'cutstyle' ),
                    'param_name' => 'values',
                    'description' => esc_html__( 'Enter values for graph - title and value.', 'cutstyle' ),
                    'value' => urlencode( json_encode( array(
                        array(
                            'label' => esc_html__( 'Stomatology', 'cutstyle' ),
                            'value' => '90',
                        ),
                        array(
                            'label' => esc_html__( 'Psychology', 'cutstyle' ),
                            'value' => '70',
                        ),
                        array(
                            'label' => esc_html__( 'Pediatry', 'cutstyle' ),
                            'value' => '70',
                        ),
                        array(
                            'label' => esc_html__( 'Orthopedy', 'cutstyle' ),
                            'value' => '50',
                        ),
                    ) ) ),
                    'params' => array(
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Label', 'cutstyle' ),
                            'param_name' => 'label',
                            'description' => esc_html__( 'Enter text used as title of bar.', 'cutstyle' ),
                            'admin_label' => true,
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Value', 'cutstyle' ),
                            'param_name' => 'value',
                            'description' => esc_html__( 'Enter value of bar.', 'cutstyle' ),
                            'admin_label' => true,
                        ),
                    ),
                ),
            ),
        )
    );



	/// common_posts_block
	vc_map(
		array(
			'name' => esc_html__( 'Posts Block', 'cutstyle' ),
			'base' => 'common_posts_block',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array(
                array(
                    'type' => 'radio_images',
                    'heading' => esc_html__( 'Style', 'cutstyle' ),
                    'param_name' => 'style',
                    'value' => array(
                        'posts_block-latest.png' => 'news-card-latest',
                        'posts_block-long.png' => 'news-card-long',
                        'posts_block-centered.png' => 'news-card-centered',
                        'posts_block-gradient.png' => 'news-card-gradient',
                    ),
                    'description' => '',
                ),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Boxes Shape', 'cutstyle' ),
                    'param_name' => 'radius',
                    'value' => array(
                        'default' => 'default',
                        esc_html__( 'Square', 'cutstyle' ) => 'default',
                        esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                        esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Greyscale Images', 'cutstyle' ),
                    'param_name' => 'greyscale',
                    'value' => 'off',
                    'description' => esc_html__( 'Show greyscale image with colored hover', 'cutstyle' ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Categories', 'cutstyle' ),
					'param_name' => 'cats',
					'value' => $cats_post,
					'description' => esc_html__( 'Select categories to show. If empty, display last posts.', 'cutstyle' )
				),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Items Count', 'cutstyle' ),
                    'param_name' => 'count',
                    'description' => esc_html__( 'Select number posts to show. Default 3.', 'cutstyle' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Title', 'cutstyle' ),
                    'param_name' => 'title',
                    'value' => '',
                    'dependency' => array(
                        'element' => 'style',
                        'value' => 'news-card-latest'
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Button Text', 'cutstyle' ),
                    'param_name' => 'btntxt',
                    'value' => '',
                    'description' => '',
                    'dependency' => array(
                        'element' => 'style',
                        'value' => 'news-card-latest'
                    ),
                ),
                array(
                    'type' => 'vc_link',
                    'heading' => esc_html__( 'Button Link', 'cutstyle' ),
                    'param_name' => 'link',
                    'description' => '',
                    'dependency' => array(
                        'element' => 'style',
                        'value' => 'news-card-latest'
                    ),
                ),
                array(
					'type' => 'textarea_html',
					'heading' => esc_html__( 'Content', 'cutstyle' ),
					'param_name' => 'content',
                    'value' => '',
                    'dependency' => array(
                        'element' => 'style',
                        'value' => 'news-card-latest'
                    ),
				),

			)
		)
	);



    /// common_reviews
    vc_map( array(
        'name' => esc_html__( 'Reviews', 'cutstyle' ),
        'base' => 'common_reviews',
        'class' => 'pix-theme-icon-common',
        'category' => esc_html__( 'CutStyle', 'cutstyle'),
        'params' => array(
            array(
                'type' => 'radio_images',
                'heading' => esc_html__( 'Style', 'cutstyle' ),
                'param_name' => 'style',
                'value' => array(
                    'reviews_people.png' => 'news-card-people',
                    'reviews_feedback.png' => 'news-card-feedback',
                    'reviews_message.png' => 'news-card-message',
                    'reviews_profile.png' => 'news-card-profile',
                ),
                'description' => '',
            ),
            array(
                'type' => 'segmented_button',
                'heading' => esc_html__( 'Boxes Shape', 'cutstyle' ),
                'param_name' => 'radius',
                'value' => array(
                    'default' => 'pix-square',
                    esc_html__( 'Square', 'cutstyle' ) => 'pix-square',
                    esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                    esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                ),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Reviews', 'cutstyle' ),
                'param_name' => 'reviews',
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'cutstyle' ),
                        'param_name' => 'image',
                        'description' => esc_html__( 'Select image.', 'cutstyle' )
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Name', 'cutstyle' ),
                        'param_name' => 'name',
                        'description' => '',
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Position', 'cutstyle' ),
                        'param_name' => 'position',
                        'description' => '',
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Facebook', 'cutstyle' ),
                        'param_name' => 'facebook',
                        'description' => esc_html__( 'Profile link', 'cutstyle' ),
                        'edit_field_class' => 'vc_col-sm-4',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Twitter', 'cutstyle' ),
                        'param_name' => 'twitter',
                        'description' => esc_html__( 'Profile link', 'cutstyle' ),
                        'edit_field_class' => 'vc_col-sm-4',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Instagram', 'cutstyle' ),
                        'param_name' => 'instagram',
                        'description' => esc_html__( 'Profile link', 'cutstyle' ),
                        'edit_field_class' => 'vc_col-sm-4',
                    ),
                    array(
                        'type' => 'vc_link',
                        'heading' => esc_html__( 'Link', 'cutstyle' ),
                        'param_name' => 'link',
                        'description' => esc_html__( 'Author link', 'cutstyle' )
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' => esc_html__( 'Review Text', 'cutstyle' ),
                        'param_name' => 'content_d',
                        'value' => wp_kses_post(__( 'I am test text block. Click edit button to change this text.', 'cutstyle' )),
                        'description' => esc_html__( 'Enter text.', 'cutstyle' )
                    ),
                ),
            ),
        ),
    
    
    ) );

    
    
    /// common_video
    vc_map(
		array(
			'name' => esc_html__( 'Video', 'cutstyle' ),
			'base' => 'common_video',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle' ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'cutstyle' ),
					'param_name' => 'title',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'YouTube or Vimeo Link', 'cutstyle' ),
					'param_name' => 'url',
					'value' => 'https://www.youtube.com/watch?v=tpBI7RhVHNI',
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'heading' => esc_html__( 'Height', 'cutstyle' ),
					'param_name' => 'height',
                    'description' => esc_html__( 'Default 500px', 'cutstyle' ),
                    'edit_field_class' => 'vc_col-sm-6',
				),
				array(
                    'type' => 'colorpicker',
                    'heading' => esc_html__( 'Overlay Color', 'cutstyle' ),
                    'param_name' => 'color',
                    'value' => '#000',
                    'description' => '',
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
                    'type' => 'range_slider',
                    'heading' => esc_html__( 'Overlay Opacity', 'cutstyle' ),
                    'param_name' => 'video_opacity',
                    'value' => array(
                        'default' => '75',
                        'min' => '0',
                        'max' => '100',
                        'unit' => '%',
                    ),
                ),
				array(
					'type' => 'textarea_html',
					'holder' => 'div',
					'heading' => esc_html__( 'Content', 'cutstyle' ),
					'param_name' => 'content',
                    'value' => ''
				),
			)
		)
	);


    

    /// common_google_map
    vc_map(
        array(
            'name' => esc_html__( 'Google Map', 'cutstyle' ),
            'base' => 'common_google_map',
            'class' => 'pix-theme-icon-common',
            'category' => esc_html__( 'CutStyle', 'cutstyle'),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Marker Image', 'cutstyle' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'cutstyle' )
                ),
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Locations', 'cutstyle' ),
                    'param_name' => 'locations',
                    'params' => array(
                        array(
                            'type' => 'textfield',
                            'holder' => 'div',
                            'heading' => esc_html__( 'LatLng', 'cutstyle' ),
                            'param_name' => 'latlng',
                            'value' => '40.6700,-73.9400',
                            'description' => esc_html__( 'Latitude, Longtitude (Example: 40.6700,-73.9400)', 'cutstyle' )
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Description', 'cutstyle' ),
                            'param_name' => 'description',
                            'value' => '',
                            'description' => '',
                        ),
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'holder' => 'div',
                    'heading' => esc_html__( 'Map Width', 'cutstyle' ),
                    'param_name' => 'width',
                    'value' => '',
                    'description' => esc_html__( 'Default 100%', 'cutstyle' )
                ),
                array(
                    'type' => 'textfield',
                    'holder' => 'div',
                    'heading' => esc_html__( 'Map Height', 'cutstyle' ),
                    'param_name' => 'height',
                    'value' => '',
                    'description' => esc_html__( 'Default 500px', 'cutstyle' )
                ),
                array(
                    'type' => 'textfield',
                    'holder' => 'div',
                    'heading' => esc_html__( 'Zoom', 'cutstyle' ),
                    'param_name' => 'zoom',
                    'value' => '',
                    'description' => esc_html__( 'Zoom 0-20. Default 9.', 'cutstyle' )
                ),
                array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Scroll Wheel', 'cutstyle' ),
                    'param_name' => 'scrollwheel',
                    'value' => 'off',
                    'description' => esc_html__( 'Zoom map with scroll', 'cutstyle' )
                ),
            )
        )
    );


    
    


    vc_map( array(
        'name' => esc_html__( 'Grid Portfolio/Services', 'cutstyle' ),
        'base' => 'common_section_grid',
        'class' => 'pix-theme-icon-common',
        'category' => esc_html__( 'CutStyle', 'cutstyle'),
        'params' => array(
            array(
                'type' => 'radio_images',
                'heading' => esc_html__( 'Style', 'cutstyle' ),
                'param_name' => 'style',
                'value' => array(
                    'grid_five.jpg' => 'grid-fives',
                    'grid_three.jpg' => 'grid-three',
                    'grid_four.jpg' => 'grid-four',
                ),
                'col' => 3,
                'description' => '',
            ),
            array(
                'type' => 'segmented_button',
                'heading' => esc_html__( 'Posts Type', 'cutstyle' ),
                'param_name' => 'post_type',
                'value' => array(
                    'default' => 'services',
                    esc_html__('Services', 'cutstyle') => 'services',
                    esc_html__('Portfolio', 'cutstyle') => 'portfolio',
                    esc_html__('Custom', 'cutstyle') => 'custom',
                ),
                'description' => esc_html__( 'Select posts type to show', 'cutstyle' )
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__( 'Portfolio Categories', 'cutstyle' ),
                'param_name' => 'portfolio_category',
                'value' => $cats,
                'description' => esc_html__( 'Select categories to show', 'cutstyle' ),
                'dependency' => array(
                    'element' => 'post_type',
                    'value' => array('portfolio'),
                )
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__( 'Departments', 'cutstyle' ),
                'param_name' => 'services_category',
                'value' => $cats_serv,
                'description' => esc_html__( 'Select categories to show', 'cutstyle' ),
                'dependency' => array(
                    'element' => 'post_type',
                    'value' => array('services'),
                )
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__('Items', 'cutstyle'),
                'param_name' => 'custom_items',
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'cutstyle' ),
                        'param_name' => 'image',
                        'description' => esc_html__( 'Select image.', 'cutstyle' ),
                        'edit_field_class' => 'vc_col-sm-4',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'cutstyle' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title for image.', 'cutstyle' ),
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-sm-8',
                    ),
                    array(
                        'type' => 'vc_link',
                        'heading' => esc_html__( 'Link', 'cutstyle' ),
                        'param_name' => 'link',
                        'value' => '',
                        'description' => esc_html__( 'Button link', 'cutstyle' ),
                    ),
                ),
                'dependency' => array(
                    'element' => 'post_type',
                    'value' => array('custom'),
                )
            ),
            array(
                'type' => 'switch_button',
                'heading' => esc_html__( 'Greyscale Images', 'cutstyle' ),
                'param_name' => 'greyscale',
                'value' => 'off',
                'description' => esc_html__( 'Show greyscale image with colored hover', 'cutstyle' ),
            ),
            array(
                'type' => 'segmented_button',
                'heading' => esc_html__( 'Large Image Position', 'cutstyle' ),
                'param_name' => 'position',
                'value' => array(
                    'default' => 'right',
                    esc_html__('Left', 'cutstyle') => 'left',
                    esc_html__('Center', 'cutstyle') => 'center',
                    esc_html__('Right', 'cutstyle') => 'right',
                ),
                'dependency' => array(
                    'element' => 'style',
                    'value' => array('grid-fives'),
                )
            ),
            array(
                'type' => 'segmented_button',
                'heading' => esc_html__( 'Order', 'cutstyle' ),
                'param_name' => 'order',
                'value' => array(
                    'default' => 'default',
                    esc_html__('First posts', 'cutstyle') => 'default',
                    esc_html__('Custom IDs', 'cutstyle') => 'ids',
                ),
                'description' => esc_html__( 'Select first posts or custom', 'cutstyle' ),
                'dependency' => array(
                    'element' => 'post_type',
                    'value' => array('services', 'portfolio'),
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Custom IDs', 'cutstyle' ),
                'param_name' => 'items',
                'description' => esc_html__( 'Input items IDs. First id is large image. (example: 307,304,302,301,300)', 'cutstyle' ),
                'dependency' => array(
                    'element' => 'order',
                    'value' => array('ids'),
                )
            ),
        )
    
    ) );


	//////////////////////////////////////////////////////////////////////

	
	vc_map(
		array(
			'name' => esc_html__( 'Portfolio', 'cutstyle' ),
			'base' => 'common_portfolio',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle' ),
			'params' => array_merge(
                array(
                    array(
                        'type' => 'radio_images',
                        'heading' => esc_html__( 'Style', 'cutstyle' ),
                        'param_name' => 'style',
                        'value' => array(
                            'portfolio_grid-portfolio.png' => 'grid-portfolio',
                            //'portfolio_grid-cat.png' => 'grid-cat',
                            'portfolio_portfolio-cards.png' => 'portfolio-cards',
                            'portfolio_cards-beyond.png' => 'cards-beyond',
                            'portfolio_person.png' => 'person',
                        ),
                        'description' => '',
                    ),
                    array(
                        'type' => 'switch_button',
                        'heading' => esc_html__( 'Greyscale Images', 'cutstyle' ),
                        'param_name' => 'greyscale',
                        'value' => 'off',
                        'description' => esc_html__( 'Show greyscale picture with colored hover', 'cutstyle' ),
                    ),
                    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Boxes Shape', 'cutstyle' ),
                        'param_name' => 'radius',
                        'value' => array(
                            'default' => 'default',
                            esc_html__( 'Square', 'cutstyle' ) => 'default',
                            esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                            esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'switch_button',
                        'heading' => esc_html__( 'Show filter', 'cutstyle' ),
                        'param_name' => 'filter',
                        'value' => 'on',
                        'description' => '',
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('grid-cat', 'grid-portfolio'),
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'checkbox',
                        'heading' => esc_html__( 'Categories', 'cutstyle' ),
                        'param_name' => 'cat_port',
                        'value' => $cats,
                        'description' => esc_html__( 'Select categories to show their portfolio.', 'cutstyle' ),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Items Count', 'cutstyle' ),
                        'param_name' => 'count',
                        'description' => esc_html__( 'Select number portfolio works to show per page. Leave empty to show all warks.', 'cutstyle' ),
                        'edit_field_class' => 'vc_col-sm-6',

                    ),
                    array(
                        'type' => 'switch_button',
                        'heading' => esc_html__( 'Show Load more button', 'cutstyle' ),
                        'param_name' => 'btnshow',
                        'value' => 'on',
                        'dependency' => array(
                            'element' => 'style',
                            'value' => array('grid-cat'),
                        ),
                        'description' => esc_html__( 'Show or not button Load more', 'cutstyle' ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Button text', 'cutstyle' ),
                        'param_name' => 'btntext',
                        'value' => esc_html__( 'Load more', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'btnshow',
                            'value' => array('on'),
                        ),
                    ),
                    array(
                        'type' => 'textarea_html',
                        'holder' => 'div',
                        'heading' => esc_html__( 'Description', 'cutstyle' ),
                        'param_name' => 'content',
                        'value' => '',
                    ),

                    array(
                        'type' => 'tab_id',
                        'heading' => esc_html__( 'ID', 'cutstyle' ),
                        'param_name' => 'tab_id',
                    ),
                ),
                $add_animation_group
            )
		)
	);


if(2+2 == 5) {
    vc_map(
        array(
            'name' => esc_html__('Portfolio Latest Works', 'cutstyle'),
            'base' => 'common_portfolio_latest_works',
            'class' => 'pix-theme-icon-common',
            'category' => esc_html__('CutStyle', 'cutstyle'),
            'params' => array(
                array(
                    'type' => 'checkbox',
                    'heading' => esc_html__('Categories', 'cutstyle'),
                    'param_name' => 'cat_port',
                    'value' => $cats,
                    'description' => esc_html__('Select categories to show their portfolio.', 'cutstyle'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Items Count', 'cutstyle'),
                    'param_name' => 'count',
                    'description' => esc_html__('Select number portfolio works to show. Leave empty to show all warks.', 'cutstyle'),
                ),
            )
        )
    );
    ////////////////////////
}

	
	/// common_services_cat
	vc_map(
		array(
			'name' => esc_html__( 'Departments', 'cutstyle' ),
			'base' => 'common_services_cat',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array(
                array(
                    'type' => 'radio_images',
                    'heading' => esc_html__( 'Style', 'cutstyle' ),
                    'param_name' => 'style',
                    'value' => array(
                        'services_cat_flip.png' => 'service-box-3',
                        'services_cat_box4.png' => 'service-box-4',
                        'services_cat_box7.png' => 'service-box-7',
                    ),
                    'description' => '',
                ),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Icon Size', 'cutstyle' ),
                    'param_name' => 'icon_size',
                    'value' => array(
                        'default' => 'pix-icon-l',
                        esc_html__( 'S', 'cutstyle' ) => 'pix-icon-s',
                        esc_html__( 'M', 'cutstyle' ) => 'pix-icon-m',
                        esc_html__( 'L', 'cutstyle' ) => 'pix-icon-l',
                        esc_html__( 'XL', 'cutstyle' ) => 'pix-icon-xl',
                    ),
                    'dependency' => array(
                        'element' => 'style',
                        'value' => array('service-box-3'),
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
                array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Flip Box', 'cutstyle' ),
                    'param_name' => 'flip',
                    'value' => 'off',
                    'dependency' => array(
                        'element' => 'style',
                        'value' => array('service-box-3'),
                    ),
                    'edit_field_class' => 'vc_col-sm-6',
                ),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Link text', 'cutstyle' ),
					'param_name' => 'btntext',
					'value' => esc_html__( 'read more', 'cutstyle' ),
					'dependency' => array(
                        'element' => 'style',
                        'value' => array('service-box-3'),
                    ),
				),
				array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Use defaults links', 'cutstyle' ),
                    'param_name' => 'links',
                    'value' => 'on',
                    'description' => esc_html__( 'Without links like presentation mode', 'cutstyle' ),
                ),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Departments', 'cutstyle' ),
					'param_name' => 'cats',
					'value' => $cats_serv,
					'description' => esc_html__( 'Select departments to show', 'cutstyle' ),
				),
			)
		)
	);
	
	//////////////////////////////////////////////////////////////////////


	/// common_services
	vc_map(
		array(
			'name' => esc_html__( 'Services', 'cutstyle' ),
			'base' => 'common_services',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array(
				array(
					'type' => 'segmented_button',
					'heading' => esc_html__( 'Use Template With', 'cutstyle' ),
					'param_name' => 'template',
					'value' => array(
					    'default' => 'menu',
						esc_html__( 'With Department Menu', 'cutstyle' ) => 'menu',
						esc_html__( 'Isotop Filter', 'cutstyle' ) => 'isotop',
						esc_html__( 'Without Menu And Filter', 'cutstyle' ) => 'landing',
					),
					'description' => esc_html__('In "With Department Menu" and "Isotop Filter" template you can\'t select departments.', 'cutstyle' ),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Departmens', 'cutstyle' ),
					'param_name' => 'cat_serv',
					'value' => $cats_serv,
					'description' => esc_html__( 'Select departmens to show their services.', 'cutstyle' ),
					'dependency' => array(
						'element' => 'template',
						'value' => array('landing'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Items Count', 'cutstyle' ),
					'param_name' => 'count',
					'description' => esc_html__( 'Select number services to show.', 'cutstyle' ),
					'dependency' => array(
						'element' => 'template',
						'value' => array('menu', 'landing'),
					),
				),
                array(
                    'type' => 'segmented_button',
                    'heading' => esc_html__( 'Boxes Shape', 'cutstyle' ),
                    'param_name' => 'radius',
                    'value' => array(
                        'default' => 'default',
                        esc_html__( 'Square', 'cutstyle' ) => 'default',
                        esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                        esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                    ),
                ),

			)
		)
	);
	
	//////////////////////////////////////////////////////////////////////


	if ( class_exists( 'booked_plugin' ) ) {
		/// common_appointment
		vc_map(
			array(
				'name' => esc_html__( 'Book An Appointment', 'cutstyle' ),
				'base' => 'common_appointment',
				'class' => 'pix-theme-icon-common',
				'category' => esc_html__( 'CutStyle', 'cutstyle'),
				'params' => array(
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Calendar Type', 'cutstyle' ),
						'param_name' => 'calendar_type',
						'value' => array(
							esc_html__( 'With Departments Select', 'cutstyle' ) => 'switcher',
							esc_html__( 'Single', 'cutstyle' ) => 'single',
						),
						'description' => esc_html__( 'Select appointment calendar to show', 'cutstyle' )
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Calendar', 'cutstyle' ),
						'param_name' => 'calendar_id',
						'value' => $calendars,
						'description' => esc_html__( 'Select appointment calendar to show', 'cutstyle' ),
						'dependency' => array(
							'element' => 'calendar_type',
							'value' => 'single',
						),
					),
				)
			)
		);
	}


	
	/// common_brands
	vc_map(
		array(
			'name' => esc_html__( 'Brands', 'cutstyle' ),
			'base' => 'common_brands',
			'class' => 'pix-theme-icon-common',
			'category' => esc_html__( 'CutStyle', 'cutstyle'),
			'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Brands per page', 'cutstyle' ),
                    'param_name' => 'brands_per_page',
                    'description' => esc_html__( 'Select number of columns. Default 5.', 'cutstyle' ),
                ),
                array(
                    'type' => 'switch_button',
                    'heading' => esc_html__( 'Greyscale Images', 'cutstyle' ),
                    'param_name' => 'greyscale',
                    'value' => 'off',
                    'description' => esc_html__( 'Show greyscale image with colored hover', 'cutstyle' ),
                ),
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Brands', 'cutstyle' ),
                    'param_name' => 'brands',
                    'params' => array(
                        array(
                            'type' => 'attach_image',
                            'heading' => esc_html__( 'Image', 'cutstyle' ),
                            'param_name' => 'image',
                            'value' => '',
                            'description' => esc_html__( 'Select image from media library.', 'cutstyle' )
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Brand Title', 'cutstyle' ),
                            'param_name' => 'title',
                            'value' => '',
                        ),
                        array(
                            'type' => 'vc_link',
                            'heading' => esc_html__( 'Link', 'cutstyle' ),
                            'param_name' => 'link',
                            'value' => '#',
                        ),
                    )
                ),
            ),
		)

	);
	////////////////////////



	/// common_section_pricetable
	//////// Price Table ////////
	vc_map( array(
		'name' => esc_html__( 'Price Table', 'cutstyle' ),
		'base' => 'common_price_table',
		'class' => 'pix-theme-icon-common',
		'category' => esc_html__( 'CutStyle', 'cutstyle'),
		'params' => array(
		    array(
                'type' => 'radio_images',
                'heading' => esc_html__( 'Style', 'cutstyle' ),
                'param_name' => 'style',
                'value' => array(
                    'price_table_default.png' => 'news-card-price',
                    'price_table_long.png' => 'news-item-price-long',
                    //'price_table_compare.png' => 'news-item-price-compare',
                ),
                'description' => '',
            ),
            array(
                'type' => 'segmented_button',
                'heading' => esc_html__( 'Boxes Shape', 'cutstyle' ),
                'param_name' => 'radius',
                'value' => array(
                    'default' => 'pix-square',
                    esc_html__( 'Square', 'cutstyle' ) => 'pix-square',
                    esc_html__( 'Rounded', 'cutstyle' ) => 'pix-rounded',
                    esc_html__( 'Round', 'cutstyle' ) => 'pix-round',
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'segmented_button',
                'heading' => esc_html__( 'Table Type', 'cutstyle' ),
                'param_name' => 'typetable',
                'value' => array(
                    'default' => 'single',
                    esc_html__( 'Single', 'cutstyle' ) => 'single',
                    esc_html__( 'Double', 'cutstyle' ) => 'double',
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Single Text', 'cutstyle' ),
				'param_name' => 'first_text',
				'value' => 'Monthly',
				'description' => esc_html__( 'Change text for First tab button', 'cutstyle' ),
				'dependency' => array(
					'element' => 'typetable',
					'value' => array('double'),
				),
                'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Second Text', 'cutstyle' ),
				'param_name' => 'second_text',
				'value' => 'Yearly',
				'description' => esc_html__( 'Change text for Second tab button', 'cutstyle' ),
				'dependency' => array(
					'element' => 'typetable',
					'value' => array('double'),
				),
                'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Currency', 'cutstyle' ),
				'param_name' => 'currency',
				'value' => '$',
				'description' => esc_html__( 'Change currency', 'cutstyle' ),
                'edit_field_class' => 'vc_col-sm-6',
			),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Button Text', 'cutstyle' ),
                'param_name' => 'btntext',
                'description' => esc_html__( 'Button text.', 'cutstyle' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
//            array(
//                'type' => 'switch_button',
//                'heading' => esc_html__( 'Use Options List', 'cutstyle' ),
//                'param_name' => 'use_options_list',
//                'value' => 'off',
//                'description' => esc_html__( 'Use enable/disable options', 'cutstyle' ),
//            ),
//            array(
//                'type' => 'textarea',
//                'holder' => 'div',
//                'heading' => esc_html__( 'Options List', 'cutstyle' ),
//                'param_name' => 'options_list',
//                'value' => '',
//                'description' => esc_html__( 'This List is compared with every box options and set enable/disable', 'cutstyle' ),
//                'dependency' => array(
//                    'element' => 'use_options_list',
//                    'value' => array('on')
//                )
//            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Price Boxes', 'cutstyle' ),
                'param_name' => 'prices',
                'params' => array_merge(
                    array(
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Title', 'cutstyle' ),
                            'param_name' => 'title',
                            'description' => esc_html__( 'Column title.', 'cutstyle' )
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Subtitle', 'cutstyle' ),
                            'param_name' => 'subtitle',
                            'description' => esc_html__( 'Subtitle text.', 'cutstyle' ),
                        ),
                        array(
                            'type' => 'segmented_button',
                            'heading' => esc_html__( 'Icon Type', 'cutstyle' ),
                            'param_name' => 'icon_type',
                            'value' => array(
                                'default' => 'svg',
                                esc_html__( 'SVG', 'cutstyle' ) => 'svg',
                                esc_html__( 'Image', 'cutstyle' ) => 'image',
                                esc_html__( 'Font', 'cutstyle' ) => 'font',
                            ),
                            'edit_field_class' => 'vc_col-sm-6',
                        ),
                        array(
                            'type' => 'attach_image',
                            'heading' => esc_html__( 'Image/SVG', 'cutstyle' ),
                            'param_name' => 'image',
                            'description' => esc_html__( 'Select image.', 'cutstyle' ),
                            'dependency' => array(
                                'element' => 'icon_type',
                                'value' => array('svg', 'image')
                            ),
                            'edit_field_class' => 'vc_col-sm-6',
                        ),
                    ),
                    pixtheme_get_vc_icons($vc_icons_data, 'icon_type', 'font'),
                    array(
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'First Price', 'cutstyle' ),
                            'param_name' => 'first_price',
                            'description' => esc_html__( 'Price for the month.', 'cutstyle' ),
                            'edit_field_class' => 'vc_col-sm-4',
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Second Price', 'cutstyle' ),
                            'param_name' => 'second_price',
                            'description' => esc_html__( 'Price for the year.', 'cutstyle' ),
                            'edit_field_class' => 'vc_col-sm-4',
                        ),
                        array(
                            'type' => 'switch_button',
                            'heading' => esc_html__( 'Popular', 'cutstyle' ),
                            'param_name' => 'ispopular',
                            'value' => 'off',
                            'edit_field_class' => 'vc_col-sm-4',
                        ),
                        array(
                            'type' => 'vc_link',
                            'heading' => esc_html__( 'Link', 'cutstyle' ),
                            'param_name' => 'link',
                            'description' => esc_html__( 'Item link.', 'cutstyle' )
                        ),
                        array(
                            'type' => 'textarea',
                            'holder' => 'div',
                            'heading' => esc_html__( 'Content', 'cutstyle' ),
                            'param_name' => 'price_content',
                            'value' => esc_html__( 'I am test text block. Click edit button to change this text.', 'cutstyle' ),
                            'description' => esc_html__( 'Enter information.', 'cutstyle' )
                        ),
                    )
                ),
            ),
		),

	) );



	////////////////////////

	if ( class_exists( 'WooCommerce' ) ) {
		/// common_woocommerce
		//////// Woocommerce Products ////////
		vc_map(
			array(
				'name' => esc_html__( 'Woocommerce Products', 'cutstyle' ),
				'base' => 'common_woocommerce',
				'class' => 'pix-theme-icon-common',
				'category' => esc_html__( 'CutStyle', 'cutstyle'),
				'params' => array(
				    array(
                        'type' => 'segmented_button',
                        'heading' => esc_html__( 'Products by', 'cutstyle' ),
                        'param_name' => 'select_type',
                        'value' => array(
                            'default' => 'default',
                            esc_html__('Category', 'cutstyle') => 'default',
                            esc_html__('IDs', 'cutstyle') => 'ids',
                        ),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'IDs', 'cutstyle' ),
                        'param_name' => 'items',
                        'description' => esc_html__( 'Input products ID.  (example: 307,304,302,301,300)', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'select_type',
                            'value' => array('ids'),
                        )
                    ),
					array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Categories', 'cutstyle' ),
						'param_name' => 'cats',
						'value' => $cats_woo,
						'description' => esc_html__( 'Select categories to show', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'select_type',
                            'value' => array('default'),
                        )
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Items Count', 'cutstyle' ),
						'param_name' => 'count',
						'description' => esc_html__( 'Select number products.', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'select_type',
                            'value' => array('default'),
                        )
					),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Products per page', 'cutstyle' ),
                        'param_name' => 'per_page',
                        'description' => esc_html__( 'Default 3.', 'cutstyle' ),
                        'dependency' => array(
                            'element' => 'carousel',
                            'value' => 'on',
                        ),
                    ),
				)
			)
		);
	}


	if ( class_exists( 'WPBakeryShortCode' ) && class_exists( 'WPBakeryShortCodesContainer' ) ) {

		class WPBakeryShortCode_Box_Container extends WPBakeryShortCodesContainer {
			protected $controls_css_settings = 'out-tc vc_controls-content-widget';
			protected $controls_list = array( 'add', 'edit', 'clone', 'delete' );

			public function __construct( $settings ) {
				parent::__construct( $settings );
			}

			public function contentAdmin( $atts, $content = null ) {

				$elem = $this->getElementHolder( '' );
				$elem = str_ireplace( 'wpb_content_element', '', $elem );
				$elem = str_ireplace( '%wpb_element_content%', '<div class="wpb_column_container vc_container_for_children vc_clearfix vc_empty-container ui-sortable ui-droppable"></div>', $elem );
				$output = $elem;

				return $output;
			}
		}

        class WPBakeryShortCode_Progress extends WPBakeryShortCode {
            public static function convertAttributesToNewProgressBar( $atts ) {
                if ( isset( $atts['values'] ) && strlen( $atts['values'] ) > 0 ) {
                    $values = vc_param_group_parse_atts( $atts['values'] );
                    if ( ! is_array( $values ) ) {
                        $temp = explode( ',', $atts['values'] );
                        $paramValues = array();
                        foreach ( $temp as $value ) {
                            $data = explode( '|', $value );
                            $colorIndex = 2;
                            $newLine = array();
                            $newLine['value'] = isset( $data[0] ) ? $data[0] : 0;
                            $newLine['label'] = isset( $data[1] ) ? $data[1] : '';
                            if ( isset( $data[1] ) && preg_match( '/^\d{1,3}\%$/', $data[1] ) ) {
                                $colorIndex += 1;
                                $newLine['value'] = (float) str_replace( '%', '', $data[1] );
                                $newLine['label'] = isset( $data[2] ) ? $data[2] : '';
                            }
                            if ( isset( $data[ $colorIndex ] ) ) {
                                $newLine['customcolor'] = $data[ $colorIndex ];
                            }
                            $paramValues[] = $newLine;
                        }
                        $atts['values'] = urlencode( json_encode( $paramValues ) );
                    }
                }

                return $atts;
            }
        }


        class WPBakeryShortCode_Common_Title extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Button extends WPBakeryShortCode {}
		class WPBakeryShortCode_Common_Icon_Box extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Posts_Block extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Progress extends WPBakeryShortCode_Progress {}
        class WPBakeryShortCode_Common_Reviews extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Video extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Google_Map extends WPBakeryShortCode {}
		class WPBakeryShortCode_Common_Price_Table extends WPBakeryShortCode {}
		class WPBakeryShortCode_Common_Amount_Box extends WPBakeryShortCode {}
		class WPBakeryShortCode_Common_Brands extends WPBakeryShortCode {}
		class WPBakeryShortCode_Common_Mailchimp extends WPBakeryShortCode {}
		class WPBakeryShortCode_Common_Cform7 extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Section_Grid extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Portfolio extends WPBakeryShortCode {}
        //class WPBakeryShortCode_Common_Portfolio_Latest_Works extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Services_Cat extends WPBakeryShortCode {}
        class WPBakeryShortCode_Common_Services extends WPBakeryShortCode {}
        if ( class_exists( 'booked_plugin' ) ) {
		    class WPBakeryShortCode_Common_Appointment extends WPBakeryShortCode {}
        }
		class WPBakeryShortCode_Common_Woocommerce extends WPBakeryShortCode {}
		//class WPBakeryShortCode_Common_Woocommerce_Cat extends WPBakeryShortCode {}

	}
?>