<?php
/*
Plugin Name: Mikado Twitter Feed
Description: Plugin that adds Twitter feed functionality to our theme
Author: Mikado Themes
Version: 1.1
*/


include_once 'load.php';

use MikadoTwitter\Shortcodes\Lib;

Lib\ShortcodeLoader::getInstance()->load();

if(!function_exists('mkd_twitter_get_shortcode_module_template_part')) {
	/**
	 * Loads module template part.
	 *
	 * @param string $shortcode name of the shortcode folder
	 * @param string $template name of the template to load
	 * @param string $slug
	 * @param array $params array of parameters to pass to template
	 *
	 * @see buro_mikado_get_template_part()
	 */
	function mkd_twitter_get_shortcode_module_template_part($shortcode,$template, $slug = '', $params = array()) {

		//HTML Content from template
		$html = '';
		$template_path = MIKADO_TWITTER_ABS_PATH.'/shortcodes/'.$shortcode.'/templates';
		
		$temp = $template_path.'/'.$template;
		if(is_array($params) && count($params)) {
			extract($params);
		}
		
		$template = '';

		if($temp !== '') {
			if($slug !== '') {
				$template = "{$temp}-{$slug}.php";
			}
			$template = $temp.'.php';
		}

		if($template) {
			ob_start();
			include($template);
			$html = ob_get_clean();
		}

		return $html;
	}
}


if(!function_exists('mkd_twitter_feed_text_domain')) {
    /**
     * Loads plugin text domain so it can be used in translation
     */
    function mkd_twitter_feed_text_domain() {
        load_plugin_textdomain('mikado-twitter-feed', false, MIKADO_TWITTER_REL_PATH.'/languages');
    }

    add_action('plugins_loaded', 'mkd_twitter_feed_text_domain');
}