<?php
namespace BuroMikado\Modules\Shortcodes\Accordion;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
	* class Accordions
*/
class Accordion implements ShortcodeInterface{
	/**
	 * @var string
	 */
	private $base;

	function __construct() {
		$this->base = 'mkd_accordion';
		add_action('vc_before_init', array($this, 'vcMap'));
	}

	public function getBase() {
		return	$this->base;
	}

	public function vcMap() {

		vc_map( array(
			'name' => esc_html__('Accordion', 'buro'),
			'base' => $this->base,
			'as_parent' => array('only' => 'mkd_accordion_tab'),
			'content_element' => true,
			'category' => esc_html__('by MIKADO', 'buro'),
			'icon' => 'icon-wpb-accordion extended-custom-icon',
			'show_settings_on_create' => true,
			'js_view' => 'VcColumnView',
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'buro' ),
					'param_name' => 'el_class',
					'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'buro' )
				),
				array(
					'type' => 'dropdown',
					'class' => '',
					'heading' => esc_html__('Style', 'buro'),
					'param_name' => 'style',
					'value' => array(
						esc_html__('Accordion', 'buro') => 'accordion',
						esc_html__('Toggle', 'buro') => 'toggle'
					),
					'save_always' => true
				),
				array(
					'type' => 'dropdown',
					'class' => '',
					'heading' => esc_html__('Color Style','buro'),
					'param_name' => 'color_style',
					'value' => [
						esc_html__('Default','buro') => '',
						esc_html__('Grey','buro') => 'grey',
						esc_html__('White','buro') => 'white',
                        esc_html__('Transparent','buro') => 'transparent'
                    ],
					'description' => ''
				)
			)
		) );
	}
	public function render($atts, $content = null) {
		$default_atts=(array(
			'title' => '',
			'style' => 'accordion',
			'color_style' => ''
		));
		$params = shortcode_atts($default_atts, $atts);
		extract($params);
		
 		$acc_class = $this->getAccordionClasses($params);
		$params['acc_class'] = $acc_class;
		$params['content'] = $content;
		
		$output = '';
		
		$output .= mkd_core_get_module_shortcode_template_part('templates/accordion-holder-template','accordions', '', $params);

		return $output;
	}

	/**
	   * Generates accordion classes
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function getAccordionClasses($params){
		
		$acc_class = '';
		$style = $params['style'];
		switch($style) {
			case 'toggle':
				$acc_class .= 'mkd-toggle mkd-initial';
				break;
			default:
				$acc_class = 'mkd-accordion mkd-initial';
		}

		if ($params['color_style'] !== ''){
			$acc_class .= ' mkd-style-'.$params['color_style'];
		}

		return $acc_class;
	}
}
