<?php
namespace BuroMikado\Modules\Shortcodes\Banner;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class ItemShowcase
 */
class Banner implements ShortcodeInterface	{
	private $base; 
	
	function __construct() {
		$this->base = 'mkd_banner';

		add_action('vc_before_init', array($this, 'vcMap'));
	}
	
	/**
		* Returns base for shortcode
		* @return string
	 */
	public function getBase() {
		return $this->base;
	}	
	
    public function vcMap() {
						
		vc_map( array(
			'name' => esc_html__('Banner', 'buro'),
			'base' => $this->base,
			'category' => esc_html__('by MIKADO','buro'),
			'icon' => 'icon-wpb-banner extended-custom-icon',
			'params' =>	array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__('Image','buro'),
                    'param_name' => 'item_image'
                ),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Link','buro'),
					'param_name' => 'link'
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__('Link Target','buro'),
					'param_name' => 'link_target',
					'value' => array(
						'' => '',
						esc_html__('Self','buro') => '_self',
						esc_html__('Blank','buro') => '_blank'
					)
				),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Title','buro'),
                    'admin_label' => true,                    
                    'param_name' => 'banner_title',
                ),
                array(
                	'type' => 'dropdown',
                	'heading' => esc_html__('Title Tag','buro'),
                	'param_name' => 'title_tag',
                	'value' => array(
                		'' => '',
                		'h2' => 'h2',
                		'h3' => 'h3',
                		'h4' => 'h4',
                		'h5' => 'h5',
                		'h6' => 'h6',
            		)
            	),
                array(
                    'type'       => 'textfield',
                    'param_name' => 'custom_size',
                    'heading'    => esc_html__('Custom Title Size (px)', 'buro')
                ),
                array(
                    'type'       => 'colorpicker',
                    'param_name' => 'color',
                    'heading'    => esc_html__('Title Color', 'buro'),
                    'dependency' => array('element' => 'banner_title', 'not_empty' => true)
                ),
                array(
                    'type'       => 'colorpicker',
                    'param_name' => 'hover_color',
                    'heading'    => esc_html__('Title Hover Color', 'buro'),
                    'dependency' => array('element' => 'banner_title', 'not_empty' => true)
                ),
                array(
                    'type'        => 'dropdown',
                    'param_name'  => 'vertical_alignment',
                    'heading'     => esc_html__('Content Vertical Alignment', 'buro'),
                    'value'       => array(
                        esc_html__('Top', 'buro')    => 'top',
                        esc_html__('Middle', 'buro') => 'middle',
                        esc_html__('Bottom', 'buro') => 'bottom',
                    ),
                    'save_always' => true
                ),
                array(
                    'type'        => 'dropdown',
                    'param_name'  => 'horizontal_alignment',
                    'heading'     => esc_html__('Content Horizontal Alignment', 'buro'),
                    'value'       => array(
                        esc_html__('Left', 'buro')   => 'left',
                        esc_html__('Center', 'buro') => 'center',
                        esc_html__('Right', 'buro') => 'right',
                    ),
                    'save_always' => true
                ),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__('Image Hover','buro'),
					'param_name' => 'image_hover',
					'value' => array(
						esc_html__('No Hover','buro') => '',
						esc_html__('Zoom','buro') => 'zoom'
					),
					'dependency' => array('element' => 'item_image', 'not_empty' => true),
				)
            )
		) );

	}

    /**
     * Renders shortcodes HTML
     *
     * @param $atts array of shortcode params
     * @param $content string shortcode content
     * @return string
     */

	public function render($atts, $content = null) {
		
		$args = array(
            'item_image' => '',
            'banner_title' => '',
            'custom_size' => '',
            'color' => '',
            'hover_color' => '',
            'title_tag' => 'h2',
			'link' => '',
			'link_target' => '',
            'vertical_alignment'   => 'middle',
            'horizontal_alignment' => 'center',
			'image_hover' => ''

        );

		$params = shortcode_atts($args, $atts);
        $params['banner_classes'] = $this->getBannerClass($params);
        $params['title_styles'] = $this->getTitleStyles($params);
        $params['title_hover_styles'] = $this->getTitleHoverStyles($params);

        extract($params);

		if($params['link_target'] == ''){
			$params['link_target'] = '_self';
		}

        $html = mkd_core_get_module_shortcode_template_part('templates/banner-template', 'banner', '', $params);

        return $html;

	}

    /**
     * Return Separator classes
     *
     * @param $params
     * @return array
     */
    private function getBannerClass($params) {

        $banner_classes = array();

        if ($params['vertical_alignment'] == 'middle') {
            $banner_classes[] = 'vertical-alignment-middle';
        } elseif ($params['vertical_alignment'] == 'bottom') {
            $banner_classes[] = 'vertical-alignment-bottom';
        } else {
            $banner_classes[] = 'vertical-alignment-top';
        }

        if ($params['horizontal_alignment'] == 'center') {
            $banner_classes[] = 'horizontal-alignment-center';
        } elseif ($params['horizontal_alignment'] == 'right') {
            $banner_classes[] = 'horizontal-alignment-right';
        } else {
            $banner_classes[] = 'horizontal-alignment-left';
        }

		if($params['image_hover'] != '') {
            $banner_classes[] = 'mkd-bih-'.$params['image_hover'];
        }

        return implode(' ', $banner_classes);

    }

    private function getTitleStyles($params) {
        $styles = array();

        if($params['color'] != '') {
            $styles[] = 'color: '.$params['color'];
        }

        if($params['custom_size'] != '') {
            $styles[] = 'font-size: '.$params['custom_size'];
        }

        return $styles;
    }

    private function getTitleHoverStyles($params) {
        $data = array();

        if(!empty($params['hover_color'])) {
            $data['data-hover-color'] = $params['hover_color'];
        }

        return $data;
    }

  }
