<?php

namespace BuroMikado\Modules\Shortcodes\BlogList;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class BlogList
 */
class BlogList implements ShortcodeInterface {
	/**
	* @var string
	*/
	private $base;
	
	function __construct() {
		$this->base = 'mkd_blog_list';
		
		add_action('vc_before_init', array($this,'vcMap'));
	}
	
	public function getBase() {
		return $this->base;
	}
	public function vcMap() {

		vc_map( array(
			'name' => esc_html__('Blog List', 'buro'),
			'base' => $this->base,
			'icon' => 'icon-wpb-blog-list extended-custom-icon',
			'category' => esc_html__('by MIKADO', 'buro'),
			'allowed_container_element' => 'vc_row',
			'params' => array(
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Type', 'buro'),
						'param_name' => 'type',
						'value' => array(
							esc_html__('Simple', 'buro') => 'simple',
							esc_html__('Boxes', 'buro') => 'boxes',
							esc_html__('Minimal', 'buro') => 'minimal',
							esc_html__('Image in box', 'buro') => 'image_in_box'
						),
						'admin_label' => true
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Number of Posts', 'buro'),
						'param_name' => 'number_of_posts'
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Show Posts with Listed IDs','buro'),
						'param_name' => 'selected_posts',
						'value' => '',
						'admin_label' => true,
						'description' => esc_html__('Delimit ID numbers by comma (leave empty for all)','buro')
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Number of Columns', 'buro'),
						'param_name' => 'number_of_columns',
						'value' => array(
							esc_html__('One', 'buro')=> '1',
							esc_html__('Two', 'buro') => '2',
							esc_html__('Three', 'buro') => '3',
							esc_html__('Four', 'buro') => '4'
						),
						'dependency' => Array('element' => 'type', 'value' => array('boxes','simple')),
                        'save_always' => true
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Order By', 'buro'),
						'param_name' => 'order_by',
						'value' => array(
							esc_html__('Title', 'buro') => 'title',
							esc_html__('Date', 'buro') => 'date'
						),
						'save_always' => true,
						'description' => ''
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Order', 'buro'),
						'param_name' => 'order',
						'value' => array(
							esc_html__('ASC', 'buro') => 'ASC',
							esc_html__('DESC', 'buro') => 'DESC'
						),
						'save_always' => true,
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Category Slug', 'buro'),
						'param_name' => 'category',
						'admin_label' => true,
						'description' => esc_html__('Leave empty for all or use comma for list', 'buro')
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('List Title', 'buro'),
						'param_name' => 'list_title',
						'dependency' => Array('element' => 'type', 'value' => array('boxes')),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('List Highlighted Text', 'buro'),
						'param_name' => 'list_highlighted',
						'description' => esc_html__('Highlighted text will be appended to title', 'buro'),
						'dependency' => Array('element' => 'type', 'value' => array('boxes')),
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Show Image', 'buro'),
						'param_name' => 'show_image',
						'value' => array(
							esc_html__('No', 'buro') => 'no',
							esc_html__('Yes', 'buro') => 'yes'
						),
						'dependency' => Array('element' => 'type', 'value' => array('simple')),
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Image Size', 'buro'),
						'param_name' => 'image_size',
						'value' => array(
							esc_html__('Original', 'buro') => 'original',
							esc_html__('Landscape', 'buro') => 'landscape',
							esc_html__('Square', 'buro') => 'square'
						),
						'dependency' => Array('element' => 'show_image', 'value' => array('yes')),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Text length', 'buro'),
						'param_name' => 'text_length',
						'description' => esc_html__('Number of characters', 'buro')
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__('Title Tag', 'buro'),
						'param_name' => 'title_tag',
						'value' => array(
							''   => '',
							'h2' => 'h2',
							'h3' => 'h3',
							'h4' => 'h4',
							'h5' => 'h5',
							'h6' => 'h6',
						)
					)
				)
		) );

	}
	public function render($atts, $content = null) {
		
		$default_atts = array(
			'type' 					=> 'simple',
            'number_of_posts' 		=> '',
            'selected_posts'		=> '',
            'number_of_columns'		=> '',
            'show_image'			=> 'no',
            'image_size'			=> 'original',
            'order_by'				=> '',
            'order'					=> '',
            'category'				=> '',
            'title_tag'				=> 'h3',
			'text_length'			=> '90',
			'list_title'			=> '',
			'list_highlighted'		=> ''
        );
		
		$params = shortcode_atts($default_atts, $atts);
		extract($params);
		$params['holder_classes'] = $this->getBlogHolderClasses($params);
	
		$queryArray = $this->generateBlogQueryArray($params);
		$query_result = new \WP_Query($queryArray);
		$params['query_result'] = $query_result;	
     
		
        $thumbImageSize = $this->generateImageSize($params);
		$params['thumb_image_size'] = $thumbImageSize;

		$html ='';
        $html .= mkd_core_get_module_shortcode_template_part('templates/blog-list-holder', 'blog-list', '', $params);
		return $html;
		
	}

	/**
	   * Generates holder classes
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function getBlogHolderClasses($params){
		$holderClasses = '';
		
		$columnNumber = $this->getColumnNumberClass($params);
		
		if(!empty($params['type'])){
			switch($params['type']){
				case 'image_in_box':
					$holderClasses = 'mkd-image-in-box';
				break;
				case 'simple' : 
					$holderClasses = 'mkd-simple';
				break;	
				case 'boxes' : 
					$holderClasses = 'mkd-boxes';
				break;	
				case 'masonry' : 
					$holderClasses = 'mkd-masonry';
				break;
				case 'minimal' :
					$holderClasses = 'mkd-minimal';
				break;
				default: 
					$holderClasses = 'mkd-simple';
			}
		}
		
		$holderClasses .= ' '.$columnNumber;
		
		return $holderClasses;
		
	}

	/** 
	   * Generates column classes for boxes type
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function getColumnNumberClass($params){
		
		$columnsNumber = '';
		$type = $params['type'];
		$columns = $params['number_of_columns'];
		
        if ($type == 'boxes' || $type == 'simple') {
            switch ($columns) {
                case 1:
                    $columnsNumber = 'mkd-one-column';
                    break;
                case 2:
                    $columnsNumber = 'mkd-two-columns';
                    break;
                case 3:
                    $columnsNumber = 'mkd-three-columns';
                    break;
                case 4:
                    $columnsNumber = 'mkd-four-columns';
                    break;
                default:
					$columnsNumber = 'mkd-one-column';
                    break;
            }
        }
		return $columnsNumber;
	}

	/**
	   * Generates query array
	   *
	   * @param $params
	   *
	   * @return array
	*/
	public function generateBlogQueryArray($params){
		
		$queryArray = array(
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'category_name' => $params['category']
		);

		$post_ids = null;
		if (!empty($params['selected_posts'])) {
			$post_ids = explode(',', $params['selected_posts']);
			$queryArray['post__in'] = $post_ids;
		}

		return $queryArray;
	}

	/**
	   * Generates image size option
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function generateImageSize($params){
		$thumbImageSize = '';
		$imageSize = $params['image_size'];
		
		if ($imageSize !== '' && $imageSize == 'landscape') {
            $thumbImageSize .= 'buro_mikado_landscape';
        } else if($imageSize === 'square'){
			$thumbImageSize .= 'buro_mikado_square';
		} else if ($imageSize !== '' && $imageSize == 'original') {
            $thumbImageSize .= 'full';
        }
		return $thumbImageSize;
	}
	
}
