<?php

if(!function_exists('buro_mikado_button_typography_styles')) {
    /**
     * Typography styles for all button types
     */
    function buro_mikado_button_typography_styles() {
        $selector = '.mkd-btn';
        $styles = array();

        $font_family = buro_mikado_options()->getOptionValue('button_font_family');
        if(buro_mikado_is_font_option_valid($font_family)) {
            $styles['font-family'] = buro_mikado_get_font_option_val($font_family);
        }

        $text_transform = buro_mikado_options()->getOptionValue('button_text_transform');
        if(!empty($text_transform)) {
            $styles['text-transform'] = $text_transform;
        }

        $font_style = buro_mikado_options()->getOptionValue('button_font_style');
        if(!empty($font_style)) {
            $styles['font-style'] = $font_style;
        }

        $letter_spacing = buro_mikado_options()->getOptionValue('button_letter_spacing');
        if($letter_spacing !== '') {
            $styles['letter-spacing'] = buro_mikado_filter_px($letter_spacing).'px';
        }

        $font_weight = buro_mikado_options()->getOptionValue('button_font_weight');
        if(!empty($font_weight)) {
            $styles['font-weight'] = $font_weight;
        }

        echo buro_mikado_dynamic_css($selector, $styles);
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_button_typography_styles');
}

if(!function_exists('buro_mikado_button_solid_styles')) {
    /**
     * Generate styles for solid type buttons
     */
    function buro_mikado_button_solid_styles() {
        //solid styles
        $solid_selector = '.mkd-btn.mkd-btn-solid';
        $solid_icon_selector = '.mkd-btn.mkd-btn-solid .mkd-btn-icon-holder';
        $solid_styles = array();
        $solid_icon_styles = array();

        if(buro_mikado_options()->getOptionValue('btn_solid_text_color')) {
            $solid_styles['color'] = buro_mikado_options()->getOptionValue('btn_solid_text_color');
        }

        if(buro_mikado_options()->getOptionValue('btn_solid_border_color')) {
            $solid_styles['border-color'] = buro_mikado_options()->getOptionValue('btn_solid_border_color');
            $solid_styles['border-width'] = '1px';
            $solid_styles['border-style'] = 'solid';
        }

        if(buro_mikado_options()->getOptionValue('btn_solid_bg_color')) {
            $solid_styles['background-color'] = buro_mikado_options()->getOptionValue('btn_solid_bg_color');
        }

        //solid hover styles
        if(buro_mikado_options()->getOptionValue('btn_solid_hover_text_color')) {
            echo buro_mikado_dynamic_css(
                '.mkd-btn.mkd-btn-solid:not(.mkd-btn-custom-hover-color):hover',
                array('color' => buro_mikado_options()->getOptionValue('btn_solid_hover_text_color').'!important')
            );
        }

        if(buro_mikado_options()->getOptionValue('btn_solid_hover_bg_color')) {
            echo buro_mikado_dynamic_css(
                '.mkd-btn.mkd-btn-solid.mkd-btn-bckg-hover:hover',
                array('background-color' => buro_mikado_options()->getOptionValue('btn_solid_hover_bg_color').'!important')
            );
        }

        if(buro_mikado_options()->getOptionValue('btn_solid_hover_border_color')) {
            echo buro_mikado_dynamic_css(
                '.mkd-btn.mkd-btn-solid:not(.mkd-btn-custom-border-hover):hover',
                array('border-color' => buro_mikado_options()->getOptionValue('btn_solid_hover_border_color').'!important')
            );

			if (!isset($solid_styles['border-width'])){
				$solid_styles['border-width'] = '1px';
				$solid_styles['border-style'] = 'solid';
				$solid_styles['border-color'] = 'transparent';
			}
        }

        if(buro_mikado_options()->getOptionValue('btn_solid_icon_color')) {
            $solid_icon_styles['color'] = buro_mikado_options()->getOptionValue('btn_solid_icon_color');
        }

        if(buro_mikado_options()->getOptionValue('btn_solid_icon_bg_color')) {
            $solid_icon_styles['background-color'] = buro_mikado_options()->getOptionValue('btn_solid_icon_bg_color');
        }

        echo buro_mikado_dynamic_css($solid_selector, $solid_styles);
        echo buro_mikado_dynamic_css($solid_icon_selector, $solid_icon_styles);
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_button_solid_styles');
}


if(!function_exists('buro_mikado_button_transparent_styles')) {
    /**
     * Generate styles for transparent type buttons
     */
    function buro_mikado_button_transparent_styles() {

        if(buro_mikado_options()->getOptionValue('btn_transparent_text_color')) {
            echo buro_mikado_dynamic_css(
                '.mkd-btn.mkd-btn-transparent',
                array('color' => buro_mikado_options()->getOptionValue('btn_transparent_text_color'))
            );
        }

        //solid hover styles
        if(buro_mikado_options()->getOptionValue('btn_transparent_hover_text_color')) {
            echo buro_mikado_dynamic_css(
                '.mkd-btn.mkd-btn-transparent:not(.mkd-btn-custom-hover-color):hover',
                array('color' => buro_mikado_options()->getOptionValue('btn_transparent_hover_text_color').'!important')
            );
        }

        if(buro_mikado_options()->getOptionValue('btn_transparent_icon_color')) {
            echo buro_mikado_dynamic_css(
                '.mkd-btn.mkd-btn-transparent .mkd-btn-icon-holder',
                array('color' => buro_mikado_options()->getOptionValue('btn_transparent_icon_color'))
            );
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_button_transparent_styles');
}