<?php

if(!function_exists('buro_mikado_button_map')) {
    function buro_mikado_button_map() {
        $panel = buro_mikado_add_admin_panel(array(
            'title' => esc_html__('Button', 'buro'),
            'name'  => 'panel_button',
            'page'  => '_elements_page'
        ));

        //Typography options
        buro_mikado_add_admin_section_title(array(
            'name' => 'typography_section_title',
            'title' => esc_html__('Typography', 'buro'),
            'parent' => $panel
        ));

        $typography_group = buro_mikado_add_admin_group(array(
            'name' => 'typography_group',
            'title' => esc_html__('Typography', 'buro'),
            'description' => esc_html__('Setup typography for all button types', 'buro'),
            'parent' => $panel
        ));

        $typography_row = buro_mikado_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $typography_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'fontsimple',
            'name'          => 'button_font_family',
            'default_value' => '',
            'label'         => esc_html__('Font Family', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'button_text_transform',
            'default_value' => '',
            'label'         => esc_html__('Text Transform', 'buro'),
            'options'       => buro_mikado_get_text_transform_array()
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'button_font_style',
            'default_value' => '',
            'label'         => esc_html__('Font Style', 'buro'),
            'options'       => buro_mikado_get_font_style_array()
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'textsimple',
            'name'          => 'button_letter_spacing',
            'default_value' => '',
            'label'         => esc_html__('Letter Spacing', 'buro'),
            'args'          => array(
                'suffix' => 'px'
            )
        ));

        $typography_row2 = buro_mikado_add_admin_row(array(
            'name' => 'typography_row2',
            'next' => true,
            'parent' => $typography_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row2,
            'type'          => 'selectsimple',
            'name'          => 'button_font_weight',
            'default_value' => '',
            'label'         => esc_html__('Font Weight', 'buro'),
            'options'       => buro_mikado_get_font_weight_array()
        ));

        //Outline type options
        buro_mikado_add_admin_section_title(array(
            'name' => 'type_section_title',
            'title' => esc_html__('Types', 'buro'),
            'parent' => $panel
        ));

        //Solid type options
        $solid_group = buro_mikado_add_admin_group(array(
            'name' => 'solid_group',
            'title' => esc_html__('Solid Type', 'buro'),
            'description' => esc_html__('Setup solid button type', 'buro'),
            'parent' => $panel
        ));

        $solid_row = buro_mikado_add_admin_row(array(
            'name' => 'solid_row',
            'next' => true,
            'parent' => $solid_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_text_color',
            'default_value' => '',
            'label'         => esc_html__('Text Color', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_hover_text_color',
            'default_value' => '',
            'label'         => esc_html__('Text Hover Color','buro')
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_bg_color',
            'default_value' => '',
            'label'         => esc_html__('Background Color', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_hover_bg_color',
            'default_value' => '',
            'label'         => esc_html__('Hover Background Color','buro')
        ));


        $solid_row2 = buro_mikado_add_admin_row(array(
            'name' => 'solid_row2',
            'next' => true,
            'parent' => $solid_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row2,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_border_color',
            'default_value' => '',
            'label'         => esc_html__('Border Color', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row2,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_hover_border_color',
            'default_value' => '',
            'label'         => esc_html__('Hover Border Color','buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row2,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_icon_color',
            'default_value' => '',
            'label'         => esc_html__('Icon Color', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $solid_row2,
            'type'          => 'colorsimple',
            'name'          => 'btn_solid_icon_bg_color',
            'default_value' => '',
            'label'         => esc_html__('Icon Background Color', 'buro'),
        ));

        //Transparent type options
        $transparent_group = buro_mikado_add_admin_group(array(
            'name' => 'transparent_group',
            'title' => esc_html__('Transparent Type', 'buro'),
            'description' => esc_html__('Setup transparent button type', 'buro'),
            'parent' => $panel
        ));

        $transparent_row = buro_mikado_add_admin_row(array(
            'name' => 'transparent_row',
            'next' => true,
            'parent' => $transparent_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $transparent_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_transparent_text_color',
            'default_value' => '',
            'label'         => esc_html__('Text Color', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $transparent_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_transparent_hover_text_color',
            'default_value' => '',
            'label'         => esc_html__('Text Hover Color','buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $transparent_row,
            'type'          => 'colorsimple',
            'name'          => 'btn_transparent_icon_color',
            'default_value' => '',
            'label'         => esc_html__('Icon Color', 'buro'),
        ));

    }

    add_action('buro_mikado_options_elements_map', 'buro_mikado_button_map');
}