<?php
namespace BuroMikado\Modules\Shortcodes\Clients;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class Clients
 */

class Clients implements ShortcodeInterface{
	private $base;
	function __construct() {
		$this->base = 'mkd_clients';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map( array(
			'name' => esc_html__('Clients', 'buro'),
			'base' => $this->base,
			'as_parent' => array('only' => 'mkd_client'),
			'content_element' => true,
			'category' => esc_html__('by MIKADO', 'buro'),
			'icon' => 'icon-wpb-clients extended-custom-icon',
			'show_settings_on_create' => true,
			'params' => array(
				array(
					'type' => 'dropdown',
					'admin_label' => true,
					'heading' => esc_html__('Columns', 'buro'),
					'param_name' => 'columns',
					'value' => array(
						esc_html__('Two', 'buro') => 'two-columns',
						esc_html__('Three','buro') => 'three-columns',
						esc_html__('Four', 'buro') => 'four-columns',
						esc_html__('Five', 'buro') => 'five-columns',
						esc_html__('Six', 'buro') => 'six-columns'
					),
					'save_always' => true,
				)
			),
			'js_view' => 'VcColumnView'

		));
	}

	public function render($atts, $content = null) {
	
		$args = array(
			'columns' 			=> ''
		);
		$params = shortcode_atts($args, $atts);
		extract($params);
		$params['content']= $content;
		$html						= '';

		$html = mkd_core_get_module_shortcode_template_part('templates/clients-template', 'clients', '', $params);

		return $html;

	}

}
