<?php
namespace BuroMikado\Modules\Shortcodes\Lib;

use BuroMikado\Modules\Shortcodes\Accordion\Accordion;
use BuroMikado\Modules\Shortcodes\AccordionTab\AccordionTab;
use BuroMikado\Modules\Shortcodes\Blockquote\Blockquote;
use BuroMikado\Modules\Shortcodes\BlogList\BlogList;
use BuroMikado\Modules\Shortcodes\BlogSlider\BlogSlider;
use BuroMikado\Modules\Shortcodes\Button\Button;
use BuroMikado\Modules\Shortcodes\CallToAction\CallToAction;
use BuroMikado\Modules\Shortcodes\Counter\Countdown;
use BuroMikado\Modules\Shortcodes\Counter\Counter;
use BuroMikado\Modules\Shortcodes\CustomFont\CustomFont;
use BuroMikado\Modules\Shortcodes\Dropcaps\Dropcaps;
use BuroMikado\Modules\Shortcodes\ElementsHolder\ElementsHolder;
use BuroMikado\Modules\Shortcodes\ElementsHolderItem\ElementsHolderItem;
use BuroMikado\Modules\Shortcodes\GoogleMap\GoogleMap;
use BuroMikado\Modules\Shortcodes\Highlight\Highlight;
use BuroMikado\Modules\Shortcodes\Icon\Icon;
use BuroMikado\Modules\Shortcodes\IconListItem\IconListItem;
use BuroMikado\Modules\Shortcodes\IconWithText\IconWithText;
use BuroMikado\Modules\Shortcodes\ImageGallery\ImageGallery;
use BuroMikado\Modules\Shortcodes\Message\Message;
use BuroMikado\Modules\Shortcodes\OrderedList\OrderedList;
use BuroMikado\Modules\Shortcodes\PieCharts\PieChartBasic\PieChartBasic;
use BuroMikado\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartDoughnut;
use BuroMikado\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartPie;
use BuroMikado\Modules\Shortcodes\PieCharts\PieChartWithIcon\PieChartWithIcon;
use BuroMikado\Modules\Shortcodes\PricingTables\PricingTables;
use BuroMikado\Modules\Shortcodes\PricingTable\PricingTable;
use BuroMikado\Modules\Shortcodes\Process\ProcessHolder;
use BuroMikado\Modules\Shortcodes\Process\ProcessItem;
use BuroMikado\Modules\Shortcodes\ProgressBar\ProgressBar;
use BuroMikado\Modules\Shortcodes\Separator\Separator;
use BuroMikado\Modules\Shortcodes\SocialShare\SocialShare;
use BuroMikado\Modules\Shortcodes\Tabs\Tabs;
use BuroMikado\Modules\Shortcodes\Tab\Tab;
use BuroMikado\Modules\Shortcodes\Team\Team;
use BuroMikado\Modules\Shortcodes\UnorderedList\UnorderedList;
use BuroMikado\Modules\Shortcodes\VerticalSplitSlider\VerticalSplitSlider;
use BuroMikado\Modules\Shortcodes\VerticalSplitSliderContentItem\VerticalSplitSliderContentItem;
use BuroMikado\Modules\Shortcodes\VerticalSplitSliderLeftPanel\VerticalSplitSliderLeftPanel;
use BuroMikado\Modules\Shortcodes\VerticalSplitSliderRightPanel\VerticalSplitSliderRightPanel;
use BuroMikado\Modules\Shortcodes\VideoButton\VideoButton;
use BuroMikado\Modules\Shortcodes\Clients\Clients;
use BuroMikado\Modules\Shortcodes\Client\Client;
use BuroMikado\Modules\Shortcodes\SectionSubtitle\SectionSubtitle;
use BuroMikado\Modules\Shortcodes\SectionTitle\SectionTitle;
use BuroMikado\Modules\Shortcodes\SectionHolder\SectionHolder;
use BuroMikado\Modules\Shortcodes\SectionItem\SectionItem;
use BuroMikado\Modules\Shortcodes\ImageWithText\ImageWithText;
use BuroMikado\Modules\Shortcodes\TextSlider\TextSlider;
use BuroMikado\Modules\Shortcodes\TextSliderItem\TextSliderItem;
use BuroMikado\Modules\Shortcodes\InteractiveItems\InteractiveItems;
use BuroMikado\Modules\Shortcodes\InteractiveItem\InteractiveItem;
use BuroMikado\Modules\Shortcodes\Banner\Banner;
use BuroMikado\Modules\Shortcodes\Underliner\Underliner;
use BuroMikado\Modules\Shortcodes\InteractiveLinkShowcase\InteractiveLinkShowcase;
use BuroMikado\Modules\Shortcodes\HeroTypographyLayout\HeroTypographyLayout;

/**
 * Class ShortcodeLoader
 */
class ShortcodeLoader {
	/**
	 * @var private instance of current class
	 */
	private static $instance;
	/**
	 * @var array
	 */
	private $loadedShortcodes = array();

	/**
	 * Private constuct because of Singletone
	 */
	private function __construct() {}

	/**
	 * Private sleep because of Singletone
	 */
	private function __wakeup() {}

	/**
	 * Private clone because of Singletone
	 */
	private function __clone() {}

	/**
	 * Returns current instance of class
	 * @return ShortcodeLoader
	 */
	public static function getInstance() {
		if(self::$instance == null) {
			return new self;
		}

		return self::$instance;
	}

	/**
	 * Adds new shortcode. Object that it takes must implement ShortcodeInterface
	 * @param ShortcodeInterface $shortcode
	 */
	private function addShortcode(ShortcodeInterface $shortcode) {
		if(!array_key_exists($shortcode->getBase(), $this->loadedShortcodes)) {
			$this->loadedShortcodes[$shortcode->getBase()] = $shortcode;
		}
	}

	/**
	 * Adds all shortcodes.
	 *
	 * @see ShortcodeLoader::addShortcode()
	 */
	private function addShortcodes() {
		$this->addShortcode(new Accordion());
		$this->addShortcode(new AccordionTab());
		$this->addShortcode(new Blockquote());
		$this->addShortcode(new BlogList());
		$this->addShortcode(new BlogSlider());
		$this->addShortcode(new Button());
		$this->addShortcode(new CallToAction());
		$this->addShortcode(new Counter());
		$this->addShortcode(new Countdown());
		$this->addShortcode(new CustomFont());
		$this->addShortcode(new Dropcaps());
		$this->addShortcode(new ElementsHolder());
		$this->addShortcode(new ElementsHolderItem());
		$this->addShortcode(new GoogleMap());
		$this->addShortcode(new Highlight());
		$this->addShortcode(new Icon());
		$this->addShortcode(new IconListItem());
		$this->addShortcode(new IconWithText());
		$this->addShortcode(new ImageGallery());
		$this->addShortcode(new Message());
		$this->addShortcode(new OrderedList());
		$this->addShortcode(new PieChartBasic());
		$this->addShortcode(new PieChartPie());
		$this->addShortcode(new PieChartDoughnut());
		$this->addShortcode(new PieChartWithIcon());
		$this->addShortcode(new PricingTables());
		$this->addShortcode(new PricingTable());
		$this->addShortcode(new ProgressBar());
		$this->addShortcode(new ProcessHolder());
		$this->addShortcode(new ProcessItem());
		$this->addShortcode(new Separator());
		$this->addShortcode(new SocialShare());
		$this->addShortcode(new Tabs());
		$this->addShortcode(new Tab());
		$this->addShortcode(new Team());
		$this->addShortcode(new UnorderedList());
		$this->addShortcode(new VideoButton());
		$this->addShortcode(new VerticalSplitSlider());
		$this->addShortcode(new VerticalSplitSliderLeftPanel());
		$this->addShortcode(new VerticalSplitSliderRightPanel());
		$this->addShortcode(new VerticalSplitSliderContentItem());
		$this->addShortcode(new Clients());
		$this->addShortcode(new Client());
		$this->addShortcode(new SectionSubtitle());
		$this->addShortcode(new SectionTitle());
		$this->addShortcode(new SectionHolder());
		$this->addShortcode(new SectionItem());
		$this->addShortcode(new ImageWithText());
		$this->addShortcode(new TextSlider());
		$this->addShortcode(new TextSliderItem());
		$this->addShortcode(new InteractiveItems());
		$this->addShortcode(new InteractiveItem());
		$this->addShortcode(new Banner());
        $this->addShortcode(new Underliner());
        $this->addShortcode(new InteractiveLinkShowcase());
        $this->addShortcode(new HeroTypographyLayout());
	}
	/**
	 * Calls ShortcodeLoader::addShortcodes and than loops through added shortcodes and calls render method
	 * of each shortcode object
	 */
	public function load() {
		$this->addShortcodes();

		foreach ($this->loadedShortcodes as $shortcode) {
			add_shortcode($shortcode->getBase(), array($shortcode, 'render'));
		}
	}
}

$shortcodeLoader = ShortcodeLoader::getInstance();
$shortcodeLoader->load();