<?php
namespace BuroMikado\Modules\Shortcodes\PricingTable;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;

class PricingTable implements ShortcodeInterface{
	private $base;
	function __construct() {
		$this->base = 'mkd_pricing_table';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map( array(
			'name' => esc_html__('Pricing Table', 'buro'),
			'base' => $this->base,
			'icon' => 'icon-wpb-pricing-table extended-custom-icon',
			'category' => esc_html__('by MIKADO', 'buro'),
			'allowed_container_element' => 'vc_row',
			'as_child' => array('only' => 'mkd_pricing_tables'),
			'params' => array(
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Title', 'buro'),
					'param_name' => 'title',
					'value' => 'Basic Plan',
				),
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Price', 'buro'),
					'param_name' => 'price',
					'description' => esc_html__('Default value is 100', 'buro'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Currency', 'buro'),
					'param_name' => 'currency',
					'description' => esc_html__('Default mark is $', 'buro'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Price Period', 'buro'),
					'param_name' => 'price_period',
					'description' => esc_html__('Default label is "per month"', 'buro')
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__('Show Button', 'buro'),
					'param_name' => 'show_button',
					'value' => array(
						esc_html__('Default', 'buro') => '',
						esc_html__('Yes', 'buro') => 'yes',
						esc_html__('No', 'buro') => 'no'
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Button Text', 'buro'),
					'param_name' => 'button_text',
					'dependency' => array('element' => 'show_button',  'value' => 'yes') 
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Button Link', 'buro'),
					'param_name' => 'link',
					'dependency' => array('element' => 'show_button',  'value' => 'yes')
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__('Active', 'buro'),
					'param_name' => 'active',
					'value' => array(
						esc_html__('No', 'buro') => 'no',
						esc_html__('Yes', 'buro') => 'yes'
					),
					'save_always' => true,
				),
				array(
					'type' => 'textarea_html',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__('Content', 'buro'),
					'param_name' => 'content',
					'value' => '<li>content content content</li><li>content content content</li><li>content content content</li>',
				)
			)
		));
	}

	public function render($atts, $content = null) {
	
		$args = array(
			'title'         			   => 'Basic Plan',
			'price'         			   => '100',
			'currency'      			   => '$',
			'price_period'  			   => 'Per Month',
			'active'        			   => 'no',
			'show_button'				   => 'yes',
			'link'          			   => '',
			'button_text'   			   => 'button'
		);
		$params = shortcode_atts($args, $atts);
		extract($params);

		$html						= '';
		$pricing_table_clasess		= 'mkd-price-table';
		
		if($active == 'yes') {
			$pricing_table_clasess .= ' mkd-active';
		}
		
		$params['pricing_table_classes'] = $pricing_table_clasess;
        $params['content'] = preg_replace('#^<\/p>|<p>$#', '', $content);
		
		$html .= mkd_core_get_module_shortcode_template_part('templates/pricing-table-template','pricing-table', '', $params);
		return $html;

	}

}
